/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Logging;

import com.ibm.cgsBus.Logging.CGSConsoleLogger;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CGSFileLogger
extends CGSConsoleLogger {
    private BufferedWriter m_pLogFileStream = null;

    public CGSFileLogger() {
    }

    public CGSFileLogger(boolean bl) {
        this.m_outputEnabled = bl;
    }

    @Override
    public void open() {
        if (!this.m_outputEnabled) {
            return;
        }
        try {
            String string = this.generateFilename();
            this.m_pLogFileStream = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, true), "UTF8"));
        }
        catch (Exception exception) {
            this.m_pLogFileStream = null;
        }
    }

    @Override
    public void close() {
        if (!this.m_outputEnabled) {
            return;
        }
        if (this.m_pLogFileStream == null) {
            return;
        }
        try {
            this.m_pLogFileStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected synchronized void log(String string) {
        if (!this.m_outputEnabled) {
            return;
        }
        this.open();
        if (this.m_pLogFileStream == null) {
            return;
        }
        try {
            this.m_pLogFileStream.append("CGSJava" + this.getSeparator() + this.getProcessPid() + this.getSeparator() + string);
            this.m_pLogFileStream.newLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.close();
    }

    @Override
    protected String getSeparator() {
        return "\t";
    }

    private String generateFilename() {
        String string = "cgsjava.log";
        if (!this.m_pid.equals("<pid>")) {
            string = "cgsjava-@" + this.m_pid + ".log";
        }
        return string;
    }
}

