/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Properties;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.Interfaces.CGSIPropOutline;
import com.ibm.cgsBus.Interfaces.CGSIPropShowDataLabels;
import com.ibm.cgsBus.Properties.CGSPropFont;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBool;
import com.ibm.cgsBus.Types.CGSTypeColor;
import com.ibm.cgsBus.Types.CGSTypeString;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CGSPropMapLayer
extends CGSProp
implements CGSIPropOutline,
CGSIPropShowDataLabels {
    protected CGSTypeString m_LayerId = null;
    protected CGSTypeBool m_ShowDataLabels = null;
    protected CGSTypeBool m_HideOverlappingDataLabels = null;
    protected CGSTypeBool m_ShowOutline = null;
    protected CGSTypeColor m_OutlineColor = null;
    protected CGSPropFont m_font = null;

    public CGSPropMapLayer(CGSEnums.PropType propType) {
        super(propType);
        this.initializeMapLayer();
    }

    protected void initializeMapLayer() {
        this.m_LayerId = new CGSTypeString();
        this.m_ShowDataLabels = new CGSTypeBool(false);
        this.m_HideOverlappingDataLabels = new CGSTypeBool(false);
        this.m_ShowOutline = new CGSTypeBool(false);
        this.m_OutlineColor = new CGSTypeColor(Color.BLACK);
        this.m_font = new CGSPropFont();
        this.m_props.add(this.m_font);
    }

    @Override
    public void copyAttributes(CGSProp cGSProp) {
        super.copyAttributes(cGSProp);
        CGSPropMapLayer cGSPropMapLayer = (CGSPropMapLayer)cGSProp;
        this.m_LayerId.setValue(cGSPropMapLayer.m_LayerId.getValue());
        this.m_ShowDataLabels.setValue(cGSPropMapLayer.m_ShowDataLabels.getValue());
        this.m_HideOverlappingDataLabels.setValue(cGSPropMapLayer.m_HideOverlappingDataLabels.getValue());
        this.m_ShowOutline.setValue(cGSPropMapLayer.m_ShowOutline.getValue());
        this.m_OutlineColor.setValue(cGSPropMapLayer.m_OutlineColor.getValue());
    }

    @Override
    public void save(DataOutputStream dataOutputStream) {
        try {
            this.m_LayerId.save(dataOutputStream);
            this.m_ShowDataLabels.save(dataOutputStream);
            this.m_HideOverlappingDataLabels.save(dataOutputStream);
            this.m_ShowOutline.save(dataOutputStream);
            this.m_OutlineColor.save(dataOutputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to save property:" + iOException.getMessage());
        }
    }

    @Override
    public void restore(DataInputStream dataInputStream) {
        try {
            this.m_LayerId.restore(dataInputStream);
            this.m_ShowDataLabels.restore(dataInputStream);
            this.m_HideOverlappingDataLabels.restore(dataInputStream);
            this.m_ShowOutline.restore(dataInputStream);
            this.m_OutlineColor.restore(dataInputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to restore property:" + iOException.getMessage());
        }
    }

    public void setLayerId(String string) {
        this.m_LayerId.setValue(string);
    }

    public String getLayerId() {
        return this.m_LayerId.getValue();
    }

    @Override
    public void setShowDataLabels(boolean bl) {
        this.m_ShowDataLabels.setValue(bl);
    }

    @Override
    public boolean getShowDataLabels() {
        return this.m_ShowDataLabels.getValue();
    }

    @Override
    public void setHideOverlappingDataLabels(boolean bl) {
        this.m_HideOverlappingDataLabels.setValue(bl);
    }

    @Override
    public boolean getHideOverlappingDataLabels() {
        return this.m_HideOverlappingDataLabels.getValue();
    }

    @Override
    public void setShowOutline(boolean bl) {
        this.m_ShowOutline.setValue(bl);
    }

    @Override
    public boolean getShowOutline() {
        return this.m_ShowOutline.getValue();
    }

    @Override
    public void setOutlineColor(Color color) {
        this.m_OutlineColor.setValue(color);
    }

    @Override
    public Color getOutlineColor() {
        return this.m_OutlineColor.getValue();
    }
}

