/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Properties;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.Interfaces.CGSIPropNumericAxis;
import com.ibm.cgsBus.Interfaces.CGSIPropWaterline;
import com.ibm.cgsBus.Properties.CGSPropAxis;
import com.ibm.cgsBus.Properties.CGSPropTickLabelNumeric;
import com.ibm.cgsBus.Properties.CGSPropWaterline;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBool;
import com.ibm.cgsBus.Types.CGSTypeDouble;
import com.ibm.cgsBus.Types.CGSTypeString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public abstract class CGSPropNumericAxis
extends CGSPropAxis
implements CGSIPropWaterline,
CGSIPropNumericAxis {
    protected CGSTypeString m_FormatString = null;
    protected CGSTypeString m_FormatStringPercent = null;
    protected CGSTypeBool m_UseManualMin = null;
    protected CGSTypeDouble m_ManualMinValue = null;
    protected CGSTypeBool m_UseManualMax = null;
    protected CGSTypeDouble m_ManualMaxValue = null;
    protected CGSTypeBool m_UseManualInterval = null;
    protected CGSTypeDouble m_ManualIntervalValue = null;
    protected CGSTypeBool m_LogarithmicScale = null;
    protected CGSTypeBool m_IncludeZero = null;
    protected CGSTypeString m_ExcelFormatString = null;
    protected CGSTypeString m_ExcelFormatStringPercent = null;
    protected CGSPropTickLabelNumeric m_tickLabelNumeric = null;
    protected Vector<CGSPropWaterline> m_Waterline = new Vector();

    public CGSPropNumericAxis(CGSEnums.PropType propType) {
        super(propType);
        this.initializeNumericAxis();
    }

    protected void initializeNumericAxis() {
        this.m_FormatString = new CGSTypeString();
        this.m_FormatStringPercent = new CGSTypeString();
        this.m_UseManualMin = new CGSTypeBool(false);
        this.m_ManualMinValue = new CGSTypeDouble(0.0);
        this.m_UseManualMax = new CGSTypeBool(false);
        this.m_ManualMaxValue = new CGSTypeDouble(0.0);
        this.m_UseManualInterval = new CGSTypeBool(false);
        this.m_ManualIntervalValue = new CGSTypeDouble(0.0);
        this.m_LogarithmicScale = new CGSTypeBool(false);
        this.m_IncludeZero = new CGSTypeBool(true);
        this.m_ExcelFormatString = new CGSTypeString(new String("0.0"));
        this.m_ExcelFormatStringPercent = new CGSTypeString(new String("0.0%"));
        this.m_tickLabelNumeric = new CGSPropTickLabelNumeric();
        this.m_props.add(this.m_tickLabelNumeric);
    }

    @Override
    public void copyAttributes(CGSProp cGSProp) {
        super.copyAttributes(cGSProp);
        CGSPropNumericAxis cGSPropNumericAxis = (CGSPropNumericAxis)cGSProp;
        this.m_FormatString.setValue(cGSPropNumericAxis.m_FormatString.getValue());
        this.m_FormatStringPercent.setValue(cGSPropNumericAxis.m_FormatStringPercent.getValue());
        this.m_UseManualMin.setValue(cGSPropNumericAxis.m_UseManualMin.getValue());
        this.m_ManualMinValue.setValue(cGSPropNumericAxis.m_ManualMinValue.getValue());
        this.m_UseManualMax.setValue(cGSPropNumericAxis.m_UseManualMax.getValue());
        this.m_ManualMaxValue.setValue(cGSPropNumericAxis.m_ManualMaxValue.getValue());
        this.m_UseManualInterval.setValue(cGSPropNumericAxis.m_UseManualInterval.getValue());
        this.m_ManualIntervalValue.setValue(cGSPropNumericAxis.m_ManualIntervalValue.getValue());
        this.m_LogarithmicScale.setValue(cGSPropNumericAxis.m_LogarithmicScale.getValue());
        this.m_IncludeZero.setValue(cGSPropNumericAxis.m_IncludeZero.getValue());
        this.m_ExcelFormatString.setValue(cGSPropNumericAxis.m_ExcelFormatString.getValue());
        this.m_ExcelFormatStringPercent.setValue(cGSPropNumericAxis.m_ExcelFormatStringPercent.getValue());
    }

    @Override
    public void copy(CGSProp cGSProp) {
        super.copy(cGSProp);
        CGSPropNumericAxis cGSPropNumericAxis = (CGSPropNumericAxis)cGSProp;
        this.m_Waterline.setSize(cGSPropNumericAxis.m_Waterline.size());
        for (int i = 0; i < cGSPropNumericAxis.m_Waterline.size(); ++i) {
            CGSPropWaterline cGSPropWaterline = new CGSPropWaterline();
            cGSPropWaterline.copy(cGSPropNumericAxis.m_Waterline.elementAt(i));
            this.m_Waterline.setElementAt(cGSPropWaterline, i);
        }
    }

    @Override
    public void save(DataOutputStream dataOutputStream) {
        super.save(dataOutputStream);
        try {
            this.m_FormatString.save(dataOutputStream);
            this.m_FormatStringPercent.save(dataOutputStream);
            this.m_UseManualMin.save(dataOutputStream);
            this.m_ManualMinValue.save(dataOutputStream);
            this.m_UseManualMax.save(dataOutputStream);
            this.m_ManualMaxValue.save(dataOutputStream);
            this.m_UseManualInterval.save(dataOutputStream);
            this.m_ManualIntervalValue.save(dataOutputStream);
            this.m_LogarithmicScale.save(dataOutputStream);
            this.m_IncludeZero.save(dataOutputStream);
            this.m_ExcelFormatString.save(dataOutputStream);
            this.m_ExcelFormatStringPercent.save(dataOutputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to save property:" + iOException.getMessage());
        }
    }

    @Override
    public void restore(DataInputStream dataInputStream) {
        super.restore(dataInputStream);
        try {
            this.m_FormatString.restore(dataInputStream);
            this.m_FormatStringPercent.restore(dataInputStream);
            this.m_UseManualMin.restore(dataInputStream);
            this.m_ManualMinValue.restore(dataInputStream);
            this.m_UseManualMax.restore(dataInputStream);
            this.m_ManualMaxValue.restore(dataInputStream);
            this.m_UseManualInterval.restore(dataInputStream);
            this.m_ManualIntervalValue.restore(dataInputStream);
            this.m_LogarithmicScale.restore(dataInputStream);
            this.m_IncludeZero.restore(dataInputStream);
            this.m_ExcelFormatString.restore(dataInputStream);
            this.m_ExcelFormatStringPercent.restore(dataInputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to restore property:" + iOException.getMessage());
        }
    }

    public void setFormatString(String string) {
        this.m_FormatString.setValue(string);
    }

    public String getFormatString() {
        return this.m_FormatString.getValue();
    }

    public void setFormatStringPercent(String string) {
        this.m_FormatStringPercent.setValue(string);
    }

    public String getFormatStringPercent() {
        return this.m_FormatStringPercent.getValue();
    }

    @Override
    public void setUseManualMin(boolean bl) {
        this.m_UseManualMin.setValue(bl);
    }

    @Override
    public boolean getUseManualMin() {
        return this.m_UseManualMin.getValue();
    }

    @Override
    public void setManualMinValue(double d) {
        this.m_ManualMinValue.setValue(d);
    }

    @Override
    public double getManualMinValue() {
        return this.m_ManualMinValue.getValue();
    }

    @Override
    public void setUseManualMax(boolean bl) {
        this.m_UseManualMax.setValue(bl);
    }

    @Override
    public boolean getUseManualMax() {
        return this.m_UseManualMax.getValue();
    }

    @Override
    public void setManualMaxValue(double d) {
        this.m_ManualMaxValue.setValue(d);
    }

    @Override
    public double getManualMaxValue() {
        return this.m_ManualMaxValue.getValue();
    }

    @Override
    public void setUseManualInterval(boolean bl) {
        this.m_UseManualInterval.setValue(bl);
    }

    @Override
    public boolean getUseManualInterval() {
        return this.m_UseManualInterval.getValue();
    }

    @Override
    public void setManualIntervalValue(double d) {
        this.m_ManualIntervalValue.setValue(d);
    }

    @Override
    public double getManualIntervalValue() {
        return this.m_ManualIntervalValue.getValue();
    }

    @Override
    public void setLogarithmicScale(boolean bl) {
        this.m_LogarithmicScale.setValue(bl);
    }

    @Override
    public boolean getLogarithmicScale() {
        return this.m_LogarithmicScale.getValue();
    }

    @Override
    public void setIncludeZero(boolean bl) {
        this.m_IncludeZero.setValue(bl);
    }

    @Override
    public boolean getIncludeZero() {
        return this.m_IncludeZero.getValue();
    }

    @Override
    public void setExcelFormatString(String string) {
        this.m_ExcelFormatString.setValue(string);
    }

    @Override
    public String getExcelFormatString() {
        return this.m_ExcelFormatString.getValue();
    }

    @Override
    public void setExcelFormatStringPercent(String string) {
        this.m_ExcelFormatStringPercent.setValue(string);
    }

    @Override
    public String getExcelFormatStringPercent() {
        return this.m_ExcelFormatStringPercent.getValue();
    }

    @Override
    public void setWaterlineCount(int n) {
        int n2 = this.m_Waterline.size();
        this.m_Waterline.setSize(n);
        for (int i = n2; i < n; ++i) {
            this.m_Waterline.setElementAt(new CGSPropWaterline(), i);
        }
    }

    @Override
    public int getWaterlineCount() {
        return this.m_Waterline.size();
    }

    @Override
    public CGSPropWaterline getWaterline(int n) {
        return this.m_Waterline.elementAt(n);
    }

    @Override
    public CGSPropWaterline appendWaterline() {
        this.setWaterlineCount(this.m_Waterline.size() + 1);
        return this.m_Waterline.set(this.m_Waterline.size() - 1, new CGSPropWaterline());
    }

    @Override
    public Vector<CGSPropWaterline> getWaterlineList() {
        return this.m_Waterline;
    }
}

