/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.service;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.async.service.AsyncRequestHandler;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.async.service.connection.IConnectionFactory;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportExecutingRequests;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.reportservice.IRSHandler;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerAttributeMonitor;
import com.cognos.pogo.reportservice.ReportServerInProgressRequests;
import com.cognos.pogo.reportservice.ReportServerQueue;
import com.cognos.pogo.reportservice.ReportServerQueueCallback;
import com.cognos.pogo.reportservice.RequestInvoker;
import com.ibm.cgsBus.service.GraphicsServiceComponentFactory;
import com.ibm.cgsBus.service.GraphicsServiceProcessManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class GraphicsServiceConnectionFactory
implements IConnectionFactory {
    private static final Logger LOGGER = Hierarchy.getDefaultHierarchy().getLoggerFor("com.cognos.cgs.GraphicsServiceConnectionFactory");
    private static final String PROCESS_MANAGER_THREAD_NAME = "GraphicsServiceProcessManager";
    private static final String CGS_REQUEST_PATH = "/cgs2";
    private static final String SERVICE_PREFIX = "gs";
    private static final int DEFAULT_MAX_PROCESSES = 1;
    private Element configurationElement;
    private GraphicsServiceProcessManager processManager;
    private RSComponentFactory componentFactory;
    private ReportServerQueue processQueue;
    private InteractiveReportExecutingRequests executingRequests;
    private RequestInvoker requestInvoker;
    private ReportServerInProgressRequests inProcessRequests;
    private boolean prestartExternalProcess = true;
    private ReportServerAttributeMonitor attributeMonitor;

    public void compose(AsyncRequestHandler asyncRequestHandler, PogoEngine pogoEngine, Element element) throws PogoException {
        this.compose((IRSHandler)asyncRequestHandler, pogoEngine, element);
    }

    public void compose(IRSHandler iRSHandler, PogoEngine pogoEngine, Element element) throws PogoException {
        try {
            this.configurationElement = element;
            this.componentFactory = new GraphicsServiceComponentFactory();
            this.componentFactory.setHandler(iRSHandler);
            this.composeProcessManager();
            this.composeRequestInvoker();
            this.inProcessRequests = this.componentFactory.newReportServerInProgressRequests();
        }
        catch (Exception exception) {
            LOGGER.error("Problem composing " + GraphicsServiceConnectionFactory.class.getName(), (Throwable)exception);
            throw new PogoException(DispatcherStrings.getInstance().getString("Dispatcher.detectedError"), exception);
        }
    }

    public void configure(Configuration configuration) {
        if (configuration == null) {
            LOGGER.error("null configuration passed to configure()");
            return;
        }
        this.configureProcessManager(configuration);
        this.configureRequestInvoker(configuration);
    }

    public IConnection getConnection() {
        return null;
    }

    public void init() {
    }

    public void start() {
        this.startProcessManager();
    }

    public void stop() {
        this.stopProcessManager();
        this.stopProcessQueue();
    }

    public void suspend(boolean bl) {
        this.suspendProcessManager(bl);
        this.suspendProcessQueue(bl);
    }

    public void resume() {
        this.resumeProcessQueue();
        this.resumeProcessManager();
    }

    private void composeRequestInvoker() throws PogoException {
        Element element = this.configurationElement.element("externalProcess");
        Map<String, String> map = this.getInitParams(element.elements("init-param"));
        this.executingRequests = this.componentFactory.newInteractiveReportExecutingRequests();
        this.requestInvoker = this.componentFactory.newRequestInvoker(this.executingRequests);
        this.requestInvoker.setCnRequestInfo(this.getRequiredAttribute("cnRequestInfo"));
        this.requestInvoker.setDefaultTimeout((long)Integer.parseInt(this.getRequiredProcessValue(map, "queue_time_limit_ms")));
        this.requestInvoker.setReportServerPath(CGS_REQUEST_PATH);
        this.requestInvoker.setCleanListName(this.getRequiredAttribute("cn_cleanup_list"));
    }

    private void configureRequestInvoker(Configuration configuration) {
        this.requestInvoker.setDispatcherGuid(NodeID.getSelf().getGuid());
        String string = configuration.getValue("gsQueueLimit");
        if (string != null && string.length() > 0) {
            long l = Integer.parseInt(string) * 1000;
            this.requestInvoker.setDefaultTimeout(l);
        }
    }

    private void composeProcessManager() throws PogoException {
        Element element = this.configurationElement.element("externalProcess");
        List list = element.elements("child-proc-cmd");
        Map<String, String> map = this.getInitParams(element.elements("init-param"));
        boolean bl = false;
        String[] stringArray = this.buildProcessCommandLine(map, list);
        int n = Integer.parseInt(this.getRequiredProcessValue(map, "server_port"));
        String string = "localhost";
        if (n > 0) {
            string = this.getRequiredProcessValue(map, "server_host");
        }
        this.processQueue = new ReportServerQueue();
        this.processManager = new GraphicsServiceProcessManager(this.componentFactory, PROCESS_MANAGER_THREAD_NAME, (ReportServerQueueCallback)this.processQueue, stringArray, element, string, n, bl);
        this.processManager.setMinProcessCount(Integer.parseInt(this.getRequiredProcessValue(map, "linger_process")));
        this.processManager.setMaxProcessCount(Integer.parseInt(this.getRequiredProcessValue(map, "max_process")));
        this.processManager.setShutdownTimeLimit(Integer.parseInt(this.getRequiredProcessValue(map, "process_shutdown_timeout_ms")));
        this.processManager.setRequestCountLimit(Integer.parseInt(this.getRequiredProcessValue(map, "default_process_use_limit")));
        long l = -1L;
        if (map.containsKey("max_wait_for_expired_process_to_become_idle_secs")) {
            Long.parseLong(this.getRequiredProcessValue(map, "idle_process_check_interval_ms"));
        }
        this.processManager.setIdleProcessTimeout(Integer.parseInt(this.getRequiredProcessValue(map, "idle_process_check_interval_ms")), Integer.parseInt(this.getRequiredProcessValue(map, "idle_process_max_idle_ticks")), l);
        if (map.containsKey("process_cleaner_interval")) {
            this.processManager.setProcessCleanerInterval(Integer.parseInt(this.getRequiredProcessValue(map, "process_cleaner_interval")));
        }
        this.processQueue.setProcessList(this.processManager.getProcessList());
        this.prestartExternalProcess = Boolean.valueOf(this.getRequiredProcessValue(map, "prestart_process"));
        this.attributeMonitor = new ReportServerAttributeMonitor(this.configurationElement);
    }

    private void configureProcessManager(Configuration configuration) {
        Element element = configuration.getCmResponse();
        if (element == null) {
            LOGGER.error("Received null configuration element from Content Manager");
        } else {
            this.processManager.setCclConfiguration(element);
        }
        boolean bl = "true".equalsIgnoreCase(configuration.getValue("inPeakDemandPeriod"));
        try {
            int n = 1;
            try {
                n = Integer.parseInt(this.getConfigValue(configuration, "MaximumProcesses", bl));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warn("Unable to fetch value for gs" + (bl ? "Peak" : "") + "MaximumProcesses - using default value: " + 1);
            }
            this.processManager.setMaxProcessCount(n);
            String string = this.getConfigValue(configuration, "AffineConnections", bl);
            String string2 = this.getConfigValue(configuration, "NonAffineConnections", bl);
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                int n2 = Integer.parseInt(string);
                int n3 = Integer.parseInt(string2);
                this.processManager.updateConnectionsPerProcess(n2, n3);
                LOGGER.debug("configureProcessManager(): maxProcessCount=" + n + ", maxAffineConnections=" + string + ", maxNonAffineConnections=" + string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Received non-numeric configuration value from Content Manager");
        }
        this.processManager.updateActiveCM(configuration.getValue("contentManager"));
        this.processManager.correctProcessBinaryPath(configuration.getICCLConfiguration());
        String string = System.getProperty("os.arch");
        String string3 = "../bin";
        if ("amd64".equals(string) || "x86_64".equals(string) || "ppc64".equals(string) || "ppc64le".equals(string) || "sparc64".equals(string) || "s390x".equals(string)) {
            string3 = "../bin64";
        }
        this.processManager.setWorkingDirectory(configuration.getICCLConfiguration().resolveEffectivePath(string3));
        this.processManager.setEnvironmentReplacement("");
        if (this.attributeMonitor.checkConfiguration(configuration)) {
            this.processManager.forceProcessRestart();
        }
        this.processManager.useNewConfiguration();
    }

    private String getConfigValue(Configuration configuration, String string, boolean bl) {
        String string2;
        String string3 = SERVICE_PREFIX;
        if (bl) {
            string3 = string3 + "Peak";
        }
        if ((string2 = configuration.getValue(string3 + string)).length() == 0) {
            string2 = configuration.getValue(SERVICE_PREFIX + string);
        }
        return string2;
    }

    private String[] buildProcessCommandLine(Map<String, String> map, List list) throws PogoException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getRequiredProcessValue(map, "exe_name"));
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(((Element)list.get(i)).getTextTrim());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getRequiredProcessValue(Map<String, String> map, String string) throws PogoException {
        String string2 = map.get(string);
        if (string2 == null || string2.length() == 0) {
            String string3 = String.format("graphicsService requires {0} parameter for external process configuration", string);
            LOGGER.error(string3);
            throw new PogoException(string3);
        }
        return string2;
    }

    private String getRequiredAttribute(String string) throws PogoException {
        String string2 = this.configurationElement.attributeValue(string);
        if (string2 == null || string2.length() == 0) {
            String string3 = String.format("graphicsService requires {0} attribute", string);
            LOGGER.error(string3);
            throw new PogoException(string3);
        }
        return string2;
    }

    private Map<String, String> getInitParams(List list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            hashMap.put(element.elementTextTrim("param-name"), element.elementText("param-value"));
        }
        return hashMap;
    }

    private void startProcessManager() {
        int n = this.processManager.getMinProcessCount();
        int n2 = this.processManager.getMaxProcessCount();
        n = Math.min(n, n2);
        if (this.prestartExternalProcess && n > 0) {
            this.processManager.createAnotherProcess(n);
        }
        this.processManager.start();
    }

    private void stopProcessManager() {
        if (this.processManager != null) {
            this.processManager.shutdown();
        }
    }

    private void suspendProcessManager(boolean bl) {
        if (this.processManager != null) {
            this.processManager.suspend(bl);
        }
    }

    private void resumeProcessManager() {
        if (this.processManager != null) {
            this.processManager.resumeIt();
        }
    }

    private void stopProcessQueue() {
        if (this.processQueue != null) {
            this.processQueue.shutdown();
        }
    }

    private void suspendProcessQueue(boolean bl) {
        this.processQueue.suspend(bl);
    }

    private void resumeProcessQueue() {
        this.processQueue.resume();
    }

    ProcessManager getProcessManager() {
        return this.processManager;
    }

    ReportServerQueue getReportServerQueue() {
        return this.processQueue;
    }

    RequestInvoker getRequestInvoker() {
        return this.requestInvoker;
    }

    ReportServerInProgressRequests getRequestMonitor() {
        return this.inProcessRequests;
    }
}

