/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.service;

import com.cognos.pogo.monitoring.QueueableRequestReportingHandler;
import com.cognos.pogo.monitoring.RequestInfo;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.xml.PooledSAXReader;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.cognos.pogo.reportservice.IRSHandler;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.ReportServerInProgressRequests;
import com.cognos.pogo.reportservice.ReportServerQueue;
import com.cognos.pogo.util.StringUtils;
import com.ibm.cgsBus.CGSRequestHelper;
import com.ibm.cgsBus.CGSSOAPException;
import com.ibm.cgsBus.service.GraphicsServiceConnectionFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class GraphicsServiceHandler
extends BasicHandler
implements IRSHandler {
    private static final Logger LOGGER = Hierarchy.getDefaultHierarchy().getLoggerFor("com.cognos.cgs.GraphicsServiceHandler");
    private static final String ERROR_MESSAGE_CODE_PREFIX = "GraphicsServiceRSHandler";
    private Element configurationElement;
    private PogoEngine pogoEngine;
    private GraphicsServiceConnectionFactory connectionFactory;
    private QueueableRequestReportingHandler queueableReportingHandler;
    private boolean suspended = false;
    private boolean useExternalProcess = true;
    private String requestInfoName;

    public GraphicsServiceHandler() {
        super(LOGGER);
    }

    public GraphicsServiceHandler(Logger logger) {
        super(logger);
    }

    public void invokeImpl(MessageContext messageContext) throws PogoException {
        if (this.isDisabled()) {
            this.replyWithDisabledFault(messageContext);
        } else if (this.useExternalProcess) {
            this.invokeExternalRequest(messageContext);
        } else {
            this.invokeInternalRequest(messageContext);
        }
    }

    private void invokeInternalRequest(MessageContext messageContext) {
        RequestInfo requestInfo = new RequestInfo();
        messageContext.setProperty(this.requestInfoName, (Object)requestInfo);
        BIBusEnvelope bIBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        Element element = bIBusEnvelope.getBody();
        String string = ((Element)element.elements().get(0)).getQName().getName();
        try {
            if (!"renderChart".equals(string)) {
                throw new CGSSOAPException(bIBusEnvelope, false, "Unknown SOAP method: " + string, null);
            }
            this.processRenderChart(bIBusEnvelope, messageContext);
        }
        catch (CGSSOAPException cGSSOAPException) {
            LOGGER.error("CGSSOAPException", (Throwable)cGSSOAPException);
            this.replyWithFault(messageContext, "GraphicsService Error", cGSSOAPException.getErrorMessage(), !cGSSOAPException.isServerError());
        }
    }

    private void processRenderChart(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CGSSOAPException {
        byte[] byArray = null;
        String string = CGSRequestHelper.getAttachmentEncoding((BIBusEnvelope)bIBusEnvelope);
        try {
            String string2 = CGSRequestHelper.getChartSpecification((BIBusEnvelope)bIBusEnvelope);
            byArray = CGSRequestHelper.generateBytesFromSpecification((String)string2);
            boolean bl = CGSRequestHelper.isResponseCompressed((String)string);
            if (bl) {
                byArray = CGSRequestHelper.compressChartData((byte[])byArray);
            }
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>(1);
            hashMap.put(".png", byArray);
            BIBusEnvelope bIBusEnvelope2 = CGSRequestHelper.buildRenderChartResponse((BIBusEnvelope)bIBusEnvelope, (String)string, hashMap);
            List<ByteArrayInputStream> list = GraphicsServiceHandler.buildAttachment(byArray, bl);
            messageContext.setProperty("response.status_code", (Object)"200");
            messageContext.setProperty("response.status_msg", (Object)"OK");
            messageContext.setProperty("response.headers", (Object)new InternetHeaders());
            messageContext.setProperty("response.envelope", (Object)bIBusEnvelope2);
            messageContext.setProperty("response.attachments", list.listIterator());
            messageContext.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
            messageContext.setResponseName("response");
        }
        catch (IOException iOException) {
            throw new CGSSOAPException(bIBusEnvelope, true, "Internal server error", (Throwable)iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new CGSSOAPException(bIBusEnvelope, true, "Rendering interrupted", (Throwable)interruptedException);
        }
    }

    private static List<ByteArrayInputStream> buildAttachment(byte[] byArray, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CGSRequestHelper.appendHeader((StringBuilder)stringBuilder, (String)"Content-ID: ", (String)"<cgsImageData.Id@cognos.ibm.com>");
        CGSRequestHelper.appendHeader((StringBuilder)stringBuilder, (String)"Content-Transfer-Encoding: binary");
        CGSRequestHelper.appendHeader((StringBuilder)stringBuilder, (String)"Content-Type: image/png");
        if (bl) {
            CGSRequestHelper.appendHeader((StringBuilder)stringBuilder, (String)"Content-Encoding: gzip");
        }
        stringBuilder.append("\r\n");
        byte[] byArray2 = stringBuilder.toString().getBytes("UTF-8");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length + byArray.length);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray);
        ArrayList<ByteArrayInputStream> arrayList = new ArrayList<ByteArrayInputStream>(1);
        arrayList.add(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        return arrayList;
    }

    private void invokeExternalRequest(MessageContext messageContext) {
        this.connectionFactory.getRequestInvoker().invoke(messageContext);
        if (messageContext.isFaulted()) {
            return;
        }
        BIBusEnvelope bIBusEnvelope = (BIBusEnvelope)messageContext.getProperty("response.envelope");
        Element element = bIBusEnvelope.getBody();
        if (element != null) {
            List list = element.content();
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof Element)) continue;
                Element element2 = (Element)list.get(i);
                if (!"Fault".equals(element2.getName())) break;
                Fault fault = new Fault("Error", (SOAPEnvelope)bIBusEnvelope);
                messageContext.setFault(fault);
                break;
            }
        }
    }

    private void replyWithFault(MessageContext messageContext, String string, String string2, boolean bl) {
        Fault fault = new Fault(string);
        if (string2 != null && string2.length() > 0) {
            fault.setDetailMessasge(string2);
        }
        fault.setClientFault(bl);
        messageContext.setFault(fault);
        messageContext.setProperty("response.status_code", (Object)"500");
        messageContext.setProperty("response.headers", (Object)new InternetHeaders());
        messageContext.setProperty("response.status_msg", (Object)"Internal Server Error");
        BIBusEnvelope bIBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        SOAPEnvelope sOAPEnvelope = fault.generateEnvelope(bIBusEnvelope);
        sOAPEnvelope.getEnvelope().add(Namespace.get((String)"xs", (String)"http://www.w3.org/2001/XMLSchema"));
        messageContext.setProperty("response.envelope", (Object)sOAPEnvelope);
        try {
            messageContext.respond("response");
        }
        catch (Exception exception) {
            LOGGER.warn("Exception while attempting to send SOAP response: ", (Throwable)exception);
        }
    }

    private void replyWithDisabledFault(MessageContext messageContext) {
        this.replyWithFault(messageContext, "Graphics service is disabled", "The service is disabled.", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureFromAdvancedProperties(String string) {
        PooledSAXReader pooledSAXReader = null;
        try {
            pooledSAXReader = SAXReaderPool.getInstance().get();
            Document document = pooledSAXReader.read((Reader)new StringReader(string));
            Node node = document.getRootElement().selectSingleNode("//setting[@name='CGS.useExternalProcess']");
            if (node != null && node.getNodeType() == 1) {
                String string2 = ((Element)node).getTextTrim();
                if ("false".equalsIgnoreCase(string2)) {
                    this.useExternalProcess = false;
                } else if ("true".equalsIgnoreCase(string2)) {
                    this.useExternalProcess = true;
                } else {
                    LOGGER.error("Invalid value for CGS.useExternalProcess: " + string2);
                }
            }
        }
        catch (DocumentException documentException) {
            LOGGER.error("unabled to parse advancedProperties string: " + string, (Throwable)documentException);
            return;
        }
        finally {
            if (pooledSAXReader != null) {
                pooledSAXReader.release();
            }
        }
    }

    public void contextualize(Element element) throws PogoException {
        super.contextualize(element);
        this.configurationElement = element;
    }

    public void compose_impl(PogoEngine pogoEngine) throws PogoException {
        super.compose_impl(pogoEngine);
        this.pogoEngine = pogoEngine;
        this.requestInfoName = this.getRequiredAttribute(LOGGER, "cnRequestInfo");
        String string = this.getRequiredAttribute(LOGGER, "runTimeInfoReporter");
        this.queueableReportingHandler = (QueueableRequestReportingHandler)pogoEngine.lookupHandler(string);
    }

    public void configure(Configuration configuration) {
        String string;
        super.configure(configuration);
        Element element = (Element)configuration.getCmResponse("graphicsService").selectSingleNode("//advancedSettings/value");
        if (element != null && (string = element.getTextTrim()) != null && string.length() > 0) {
            this.configureFromAdvancedProperties(string);
        }
        if (this.useExternalProcess) {
            this.connectionFactory = new GraphicsServiceConnectionFactory();
            try {
                this.connectionFactory.compose(this, this.pogoEngine, this.configurationElement);
            }
            catch (PogoException pogoException) {
                LOGGER.error("Error constructing connection factory", (Throwable)pogoException);
                return;
            }
            this.connectionFactory.configure(configuration);
        }
    }

    public void reconfigure(Configuration configuration) {
        super.reconfigure(configuration);
    }

    public void initialize() {
        super.initialize();
        if (this.useExternalProcess) {
            this.connectionFactory.init();
            this.connectionFactory.getProcessManager().setRequestReporter(this.queueableReportingHandler.getQueueableRequestReporter());
        }
    }

    public void start() {
        LOGGER.debug("Starting GraphicsServiceHandler");
        super.start();
        if (this.useExternalProcess) {
            this.connectionFactory.start();
        }
    }

    public void stop() {
        LOGGER.debug("Stopping GraphicsServiceHandler");
        super.stop();
        if (this.useExternalProcess) {
            this.connectionFactory.stop();
        }
    }

    public void suspend(boolean bl) {
        super.suspend(bl);
        this.suspended = true;
        if (this.useExternalProcess) {
            this.connectionFactory.suspend(bl);
        }
    }

    public void resume() {
        super.resume();
        this.suspended = false;
        if (this.useExternalProcess) {
            this.connectionFactory.resume();
        }
    }

    protected boolean isDisabled() {
        return this.suspended;
    }

    public String constructMessageID(String string) {
        String string2 = ERROR_MESSAGE_CODE_PREFIX + string;
        LOGGER.debug("Generated message id: " + string2);
        return string2;
    }

    public int getCurrentCapacity() {
        return -1;
    }

    public ReportServerInProgressRequests getInProgressRequests() {
        return this.connectionFactory.getRequestMonitor();
    }

    public ProcessManager getProcessManager() {
        return this.connectionFactory.getProcessManager();
    }

    public String getProcessUseLimitPropertyName() {
        throw new UnsupportedOperationException();
    }

    public ReportServerQueue getReportServerQueue() {
        return this.connectionFactory.getReportServerQueue();
    }

    public int getRequestUsage() {
        return this.connectionFactory.getProcessManager().getRequestUsage();
    }

    public void testFinishedStopping() {
        throw new UnsupportedOperationException();
    }
}

