/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.admin.common.AdminConfigProperties;
import com.cognos.admin.common.CacheManagerSingleton;
import com.cognos.admin.common.InstalledComponents;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.cache.AdminCache;
import com.cognos.admin.common.cache.CacheManager;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.services.IContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.parser.XsltParseException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class AdminMetadataRetriever {
    private static final String METADATAFILENAME = "/iManage-metadata.xml";
    private static final String CLASS_ELEMENT = "class";
    private static final String CLASS_NAME_ATTRIBUTE = "name";
    private static final String IS_SERVICE_ATTRIBUTE = "isService";
    private static final String CLASS_DEPENDENCY = "dependency";
    private static final String SERVICES_LIST = "AllServiceTypesList";
    private static final String RESOURCE_CAPTION_LIST = "ResourceCaptionList";
    private static final String RESOURCE_DEPENDS_LIST = "ResourceDependencyList";
    private Element m_d4jElemMetadata;
    private AdminCache m_metadataCache = null;
    private AdminCache m_wsdlCache = null;
    private Stylesheet m_transformer = null;
    private String application = "cm";
    private String iManageMetadata = "/iManage-metadata.xml";
    private static final Map<String, AdminMetadataRetriever> metadataRetrievers = new HashMap<String, AdminMetadataRetriever>();
    private static final String sbxPathFilterProps = new StringBuffer("/*[local-name()='").append(AdminConfigProperties.COG_METADATADESC.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_METADATADESC.getNamespaceURI()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTY.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_PROPERTY.getNamespaceURI()).append("']").toString();
    private static final String sbXPathLocalizeProperty = new StringBuffer("/*[local-name()='").append(AdminConfigProperties.COG_METADATADESC.getLocalPart()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTY.getLocalPart()).append("']").toString();
    private static final String sbXPathLocalizeEnums = new StringBuffer("*[local-name()='").append(AdminConfigProperties.COG_ENUMERATION.getLocalPart()).append("']/*[local-name()='").append(AdminConfigProperties.COG_ENUM.getLocalPart()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTY_NAME.getLocalPart()).append("'][@localize='true']").toString();
    private static final String sbXPathLocalizeGroups = new StringBuffer("/*[local-name()='").append(AdminConfigProperties.COG_METADATADESC.getLocalPart()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTIES_GROUPS.getLocalPart()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTIES_GROUP.getLocalPart()).append("']").toString();
    private static final String sbXPathLocalizeActions = new StringBuffer("/*[local-name()='").append(AdminConfigProperties.COG_METADATADESC.getLocalPart()).append("']/*[local-name()='").append(AdminConfigProperties.COG_ACTION.getLocalPart()).append("']").toString();
    private static final String sbXPathContext = new StringBuffer("*[local-name()='").append(AdminConfigProperties.COG_ACTION_CONTEXT.getLocalPart()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTY_NAME.getLocalPart()).append("']").toString();

    AdminMetadataRetriever(String application) {
        this.application = ResourceLookupManager.getInstance().getApplication(application);
        if (!"cm".equals(this.application)) {
            this.iManageMetadata = "/iManage-metadata-" + this.application + ".xml";
        }
    }

    AdminMetadataRetriever() {
        this(null);
    }

    public String getSource() {
        return this.iManageMetadata;
    }

    private synchronized void load() throws CacheException {
        try {
            InputStream aStream = this.getClass().getResourceAsStream(this.iManageMetadata);
            this.m_d4jElemMetadata = new SAXReader().read(aStream).getRootElement();
            CacheManager cacheManager = CacheManagerSingleton.getInstance();
            this.m_metadataCache = cacheManager.getCache("AdminMetadataCache" + this.application);
            if (this.m_metadataCache == null) {
                this.m_metadataCache = cacheManager.createCache("AdminMetadataCache" + this.application);
            }
            this.m_wsdlCache = cacheManager.getCache("AdminWSDLCache" + this.application);
            if (this.m_wsdlCache == null) {
                this.m_wsdlCache = cacheManager.createCache("AdminWSDLCache" + this.application);
            }
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("load", e);
            throw new CacheException(e.getMessage(), (Throwable)e);
        }
    }

    public static AdminMetadataRetriever getInstance(IContext context) {
        return AdminMetadataRetriever.getInstance(ResourceLookupManager.getInstance().getApplication(context));
    }

    public static AdminMetadataRetriever getInstance(String application) throws CacheException {
        AdminMetadataRetriever m_Instance;
        if (application == null || "null".equals(application)) {
            application = "cm";
        }
        if (null == (m_Instance = metadataRetrievers.get(application))) {
            m_Instance = new AdminMetadataRetriever(application);
            metadataRetrievers.put(application, m_Instance);
            m_Instance.load();
        }
        return m_Instance;
    }

    public Element getRawMetadata() {
        return this.m_d4jElemMetadata;
    }

    public Element getAllMetadataProperties(String resourceType, Locale tl) throws CacheException {
        Element metadataElem = this.getAllMetadataPropertiesRO(resourceType, tl).createCopy();
        ResourcePropertiesRetriever.getInstance(this.application).purgeMDD(metadataElem);
        return metadataElem;
    }

    Element getAllMetadataPropertiesRO(String resourceType, Locale tl) throws CacheException {
        Element obj = null;
        try {
            String cacheKey = new StringBuffer(resourceType).append(tl).toString();
            obj = (Element)this.m_metadataCache.get(cacheKey);
            if (obj == null) {
                obj = this.readMetadata(resourceType, tl);
                this.m_metadataCache.put(cacheKey, (Serializable)obj);
                if (CogAdminLogger.getInstance().isDebugEnabled()) {
                    CogAdminLogger.getInstance().debug("Cached metadata for resource type '" + resourceType + "', locale '" + tl + "' : " + obj.asXML());
                }
            }
            return obj;
        }
        catch (CacheException e) {
            CogAdminLogger.getInstance().error("getAllMetadataProperties", e);
            throw e;
        }
    }

    public ArrayList getServiceTypeIds() throws CacheException {
        ArrayList<String> serviceType = (ArrayList<String>)this.m_metadataCache.get(SERVICES_LIST);
        if (serviceType == null) {
            List list = this.m_d4jElemMetadata.elements(CLASS_ELEMENT);
            serviceType = new ArrayList<String>(list.size());
            for (Element serviceTypeElem : list) {
                Attribute name = serviceTypeElem.attribute(CLASS_NAME_ATTRIBUTE);
                Attribute isService = serviceTypeElem.attribute(IS_SERVICE_ATTRIBUTE);
                if (name == null || isService == null || !Boolean.valueOf(isService.getStringValue()).booleanValue()) continue;
                serviceType.add(name.getStringValue());
            }
            this.m_metadataCache.put(SERVICES_LIST, serviceType);
        }
        return new ArrayList(serviceType);
    }

    public ArrayList getInstalledServiceTypeIds() {
        ArrayList serviceTypeIds = this.getServiceTypeIds();
        List<String> installedComponents = InstalledComponents.getInstalledComponents();
        Map resourceDependency = this.getResourceTypeDependency();
        ArrayList<String> installedServiceTypeIds = new ArrayList<String>(serviceTypeIds.size());
        for (String sServiceType : serviceTypeIds) {
            String sDependency = (String)resourceDependency.get(sServiceType);
            if (!InstalledComponents.isInstalled(sDependency, installedComponents)) continue;
            installedServiceTypeIds.add(sServiceType);
        }
        return installedServiceTypeIds;
    }

    public ArrayList getResourceTypeIds() throws CacheException {
        Locale locale = Locale.ENGLISH;
        return new ArrayList(this.getResourceTypeCaptions(locale).keySet());
    }

    public ArrayList getInstalledResourceTypeIds() throws CacheException {
        Locale locale = Locale.ENGLISH;
        return new ArrayList(this.getInstalledResourceTypeCaptions(locale).keySet());
    }

    public Map getResourceTypeCaptions(Locale locale) throws CacheException {
        String key = new StringBuffer(RESOURCE_CAPTION_LIST).append(locale).toString();
        HashMap<String, String> resourceTypeCaptions = (HashMap<String, String>)this.m_metadataCache.get(key);
        if (resourceTypeCaptions == null) {
            List list = this.m_d4jElemMetadata.elements(CLASS_ELEMENT);
            resourceTypeCaptions = new HashMap<String, String>();
            for (Element serviceTypeElem : list) {
                Attribute name = serviceTypeElem.attribute(CLASS_NAME_ATTRIBUTE);
                if (name == null) continue;
                String sName = name.getStringValue();
                String sCaption = MessagesManagerFacade.getInstance().getMessage(locale, sName + ".caption");
                resourceTypeCaptions.put(sName, sCaption);
            }
            this.m_metadataCache.put(key, resourceTypeCaptions);
        }
        return resourceTypeCaptions;
    }

    private Map getResourceTypeDependency() throws CacheException {
        HashMap<String, String> resourceTypeDependencies = (HashMap<String, String>)this.m_metadataCache.get(RESOURCE_DEPENDS_LIST);
        if (resourceTypeDependencies == null) {
            List list = this.m_d4jElemMetadata.elements(CLASS_ELEMENT);
            resourceTypeDependencies = new HashMap<String, String>();
            for (Element serviceTypeElem : list) {
                Attribute name = serviceTypeElem.attribute(CLASS_NAME_ATTRIBUTE);
                if (name == null) continue;
                String sName = name.getStringValue();
                String sDependencies = serviceTypeElem.attributeValue(CLASS_DEPENDENCY);
                resourceTypeDependencies.put(sName, sDependencies);
            }
            this.m_metadataCache.put(RESOURCE_DEPENDS_LIST, resourceTypeDependencies);
        }
        return resourceTypeDependencies;
    }

    public Map getInstalledResourceTypeCaptions(Locale locale) throws CacheException {
        HashMap<String, String> installedResourceTypeCaptions = new HashMap<String, String>();
        Map resourceCaptions = this.getResourceTypeCaptions(locale);
        List<String> installedComponents = InstalledComponents.getInstalledComponents();
        Map resourceDependency = this.getResourceTypeDependency();
        for (Map.Entry entry : resourceDependency.entrySet()) {
            String sCaption;
            String sDependency = (String)entry.getValue();
            String resourceType = (String)entry.getKey();
            if (!InstalledComponents.isInstalled(sDependency, installedComponents) || (sCaption = (String)resourceCaptions.get(resourceType)) == null) continue;
            installedResourceTypeCaptions.put(resourceType, sCaption);
        }
        return installedResourceTypeCaptions;
    }

    protected Element getMetadataProperties(String resourceType, ArrayList propList, Locale tl) throws CacheException {
        Element obj = this.getAllMetadataProperties(resourceType, tl);
        this.filterRequestedProps(obj, propList);
        return obj;
    }

    private void filterRequestedProps(Element obj, ArrayList propList) {
        if (propList == null) {
            return;
        }
        List list = obj.selectNodes(sbxPathFilterProps);
        for (Element property : list) {
            Element name = property.element(AdminConfigProperties.NAME);
            if (name == null || !this.propertyNotListed(name.getText(), propList)) continue;
            obj.remove(property);
        }
    }

    private boolean propertyNotListed(String aProp, ArrayList propList) {
        for (String listedProp : propList) {
            if (listedProp.compareToIgnoreCase(aProp) != 0) continue;
            return false;
        }
        return true;
    }

    private Stylesheet getMetadataStyleSheet() throws IOException, SAXException, XsltParseException {
        if (this.m_transformer == null) {
            this.m_transformer = new Stylesheet();
            this.m_transformer.setup(new XmlSource("", this.getClass().getResourceAsStream("/generate-resource-md.xslt"), true));
        }
        return this.m_transformer;
    }

    protected InputStream getMetadataInput() {
        return this.getClass().getResourceAsStream(this.iManageMetadata);
    }

    private Element readMetadata(String resourceType, Locale tl) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transformMetadata(baos, resourceType);
        Element root = null;
        try {
            Document doc = DocumentHelper.parseText((String)baos.toString());
            root = doc.getRootElement();
        }
        catch (DocumentException ex) {
            CogAdminLogger.getInstance().error("readMetadata", ex);
        }
        this.localizeMDD(root, tl);
        return root;
    }

    protected void transformMetadata(OutputStream os, Object resourceType) {
        try {
            Stylesheet transformer = this.getMetadataStyleSheet();
            transformer.setParameter("gClass", resourceType);
            XmlSource source = new XmlSource("", this.getMetadataInput(), true);
            XsltResult result = new XsltResult("", os, false);
            transformer.transform(source, result);
        }
        catch (IOException e) {
            CogAdminLogger.getInstance().error("readMetadata", e);
        }
        catch (SAXException e) {
            CogAdminLogger.getInstance().error("readMetadata", e);
        }
        catch (XsltParseException e) {
            CogAdminLogger.getInstance().error("readMetadata", e);
        }
    }

    private void localizeMDD(Element obj, Locale tl) {
        Element description;
        Element caption;
        List list = obj.selectNodes(sbXPathLocalizeProperty);
        for (Element property : list) {
            caption = property.element(AdminConfigProperties.CAPTION);
            if (caption != null) {
                caption.setText(MessagesManagerFacade.getInstance().getMessage(tl, caption.getText()));
            }
            if ((description = property.element(AdminConfigProperties.DESCRIPTION)) != null) {
                description.setText(MessagesManagerFacade.getInstance().getMessage(tl, description.getText()));
            }
            List innerList = property.selectNodes(sbXPathLocalizeEnums);
            for (Element enumCaption : innerList) {
                enumCaption.setText(MessagesManagerFacade.getInstance().getMessage(tl, enumCaption.getText()));
            }
        }
        list = obj.selectNodes(sbXPathLocalizeGroups);
        for (Element propertyGroup : list) {
            caption = propertyGroup.element(AdminConfigProperties.CAPTION);
            if (caption != null) {
                String text = caption.getText();
                if (text.indexOf("/") != -1) {
                    text = text.replaceAll("/", "_");
                }
                caption.setText(MessagesManagerFacade.getInstance().getMessage(tl, text));
            }
            if ((description = propertyGroup.element(AdminConfigProperties.DESCRIPTION)) == null) continue;
            String text = description.getText();
            if (text.indexOf("/") != -1) {
                text = text.replaceAll("/", "_");
            }
            description.setText(MessagesManagerFacade.getInstance().getMessage(tl, text));
        }
        list = obj.selectNodes(sbXPathLocalizeActions);
        for (Element action : list) {
            Element confirmCaption;
            Element confirm;
            Element tooltip;
            caption = action.element(AdminConfigProperties.CAPTION);
            if (caption != null) {
                caption.setText(MessagesManagerFacade.getInstance().getMessage(tl, caption.getText()));
            }
            if ((description = action.element(AdminConfigProperties.DESCRIPTION)) != null) {
                description.setText(MessagesManagerFacade.getInstance().getMessage(tl, description.getText()));
            }
            if ((tooltip = action.element(AdminConfigProperties.TOOLTIP)) != null) {
                tooltip.setText(MessagesManagerFacade.getInstance().getMessage(tl, tooltip.getText()));
            }
            if ((confirm = action.element(AdminConfigProperties.CONFIRM)) != null && (confirmCaption = confirm.element(AdminConfigProperties.CAPTION)) != null) {
                confirmCaption.setText(MessagesManagerFacade.getInstance().getMessage(tl, confirmCaption.getText()));
            }
            List innerList = action.selectNodes(sbXPathContext);
            for (Element captionContext : innerList) {
                captionContext.setText(MessagesManagerFacade.getInstance().getMessage(tl, captionContext.getText()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getResourceWSDL(String resourceType, String servletURI, String targetNS) throws BaseFaultType {
        String _wsdl = (String)this.m_wsdlCache.get(resourceType);
        if (_wsdl != null) return _wsdl;
        if (this.getInstalledResourceTypeIds().contains(resourceType)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Stylesheet transformer = new Stylesheet();
                transformer.setup(new XmlSource("", this.getClass().getResourceAsStream("/generate-wsdl.xslt"), true));
                transformer.setParameter("gClass", (Object)resourceType);
                XmlSource source = new XmlSource("", this.getClass().getResourceAsStream(METADATAFILENAME), true);
                XsltResult result = new XsltResult("", (OutputStream)baos, false);
                transformer.transform(source, result);
            }
            catch (IOException e) {
                CogAdminLogger.getInstance().error("getResourceWSDL", e);
                throw new BaseFaultType("error.exception", e);
            }
            catch (SAXException e) {
                CogAdminLogger.getInstance().error("getResourceWSDL", e);
                throw new BaseFaultType("error.exception", e);
            }
            catch (XsltParseException e) {
                CogAdminLogger.getInstance().error("getResourceWSDL", e);
                throw new BaseFaultType("error.exception", e);
            }
            try {
                Document doc = DocumentHelper.parseText((String)baos.toString());
                Element elemWSDL = doc.getRootElement();
                if (elemWSDL == null) return _wsdl;
                _wsdl = elemWSDL.asXML();
                this.m_wsdlCache.put(resourceType, (Serializable)((Object)_wsdl));
                return _wsdl;
            }
            catch (DocumentException e) {
                CogAdminLogger.getInstance().error("getResourceWSDL", e);
                throw new BaseFaultType("error.exception", e);
            }
        }
        Object[] args = new String[]{"getResourceWSDL", resourceType};
        throw new BaseFaultType("error.invalidresourceid", args, null);
    }

    public static void clearCache() {
        CacheManager cacheManager = CacheManagerSingleton.getInstance();
        for (String application : metadataRetrievers.keySet()) {
            cacheManager.removeCache("AdminMetadataCache" + application);
            cacheManager.removeCache("AdminWSDLCache" + application);
            AdminMetadataRetriever.getInstance(application).load();
        }
    }

    public static boolean isService(IContext context, String serviceName) {
        ArrayList services = AdminMetadataRetriever.getInstance(context).getServiceTypeIds();
        return services.contains(serviceName);
    }
}

