/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.utils.SoapUtils;
import com.cognos.cps.common.io.FilterInputStreamReader;
import com.cognos.cps.common.utils.SmallMap;
import com.cognos.cps.services.IContext;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.XTSBusRequest;
import com.cognos.xts.interpreter.instructions.request.XTSBusResult;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.dom4j.Element;

public class BusRequest {
    private static final String COGADMIN_TRUSTED_IDENTIFIER = "COGADMIN";
    private static final String[] TRUSTED_SOAP_HEADERS = new String[]{"<bus:biBusHeader xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"/>"};
    private XTSBusRequest busRequest;
    CAMFactory camFactory;

    public synchronized void initialize(IContext context) throws BaseFaultType {
        String MN = "initialize";
        if (CogAdminLogger.getInstance().isDebugEnabled()) {
            CogAdminLogger.getInstance().enter("initialize");
        }
        this.busRequest = new XTSBusRequest();
        try {
            XTSEnvironment env = (XTSEnvironment)context.getProperty("XTS_ENV");
            String identifier = context.getProperty("XTS_IDENTIFIER") + "_BUS";
            this.busRequest.initialize(env, identifier, null, null);
        }
        catch (XTSInstructionException e) {
            CogAdminLogger.getInstance().error("initialize", e);
            throw new BaseFaultType("error.exception", e);
        }
        this.camFactory = new CAMFactory();
        try {
            String initString = "<initializeDocument><serviceID>COGADMIN</serviceID></initializeDocument>";
            this.camFactory.initialize(initString.getBytes());
        }
        catch (CAMCryptoException e) {
            CogAdminLogger.getInstance().error("initialize", e);
            throw new BaseFaultType("error.exception", e);
        }
        if (CogAdminLogger.getInstance().isDebugEnabled()) {
            CogAdminLogger.getInstance().exit("initialize");
        }
    }

    public synchronized void terminate() throws BaseFaultType {
        String MN = "terminate";
        if (CogAdminLogger.getInstance().isDebugEnabled()) {
            CogAdminLogger.getInstance().enter("terminate");
        }
        try {
            this.busRequest.terminate();
            this.busRequest = null;
        }
        catch (XTSInstructionException e) {
            CogAdminLogger.getInstance().error("terminate", e);
            throw new BaseFaultType("error.exception", e);
        }
        if (CogAdminLogger.getInstance().isDebugEnabled()) {
            CogAdminLogger.getInstance().exit("terminate");
        }
    }

    public Reader send(IContext context, String request) throws BaseFaultType {
        return this.send(context, request, false, true);
    }

    public Reader send(IContext context, String request, boolean trusted, boolean responseEnveloppe) throws BaseFaultType {
        String MN = "sendBusRequest";
        String sTarget = (String)context.getProperty("bustarget");
        String sSoapAction = (String)context.getProperty("soapAction");
        if (CogAdminLogger.getInstance().isDebugEnabled()) {
            CogAdminLogger.getInstance().enter("sendBusRequest");
            CogAdminLogger.getInstance().debug("request is: " + request + ", target is: " + sTarget + ", soapAction is: " + sSoapAction);
        }
        if (this.busRequest == null) {
            throw new BaseFaultType("The bus request is not initialized yet.");
        }
        Reader soapRequest = null;
        if (trusted) {
            if (CogAdminLogger.getInstance().isDebugEnabled()) {
                CogAdminLogger.getInstance().debug("using trusted request");
            }
            soapRequest = this.signRequest(SoapUtils.createSOAPEnvelopeString((String)request, (String[])TRUSTED_SOAP_HEADERS));
        } else {
            String[] headers = new String[]{context.getProperty("BUS_HEADER").toString()};
            soapRequest = SoapUtils.createSOAPEnvelopeReader((String)request, (String[])headers);
        }
        SmallMap busAtts = new SmallMap();
        busAtts.put("target", sTarget);
        SmallMap busParams = new SmallMap();
        busParams.put("soapAction", new String[]{sSoapAction});
        String sResponseEnveloppe = responseEnveloppe ? "true" : "false";
        busParams.put("responseEnvelope", new String[]{sResponseEnveloppe});
        XTSEnvironment requestEnv = (XTSEnvironment)context.getProperty("XTS_ENV");
        try {
            XTSBusResult response = (XTSBusResult)this.busRequest.execute(requestEnv, (Map)busAtts, (Map)busParams, soapRequest);
            Reader reader = response.getResult().getReader();
            if (CogAdminLogger.getInstance().isDebugEnabled()) {
                CogAdminLogger.getInstance().exit("sendBusRequest");
            }
            return reader;
        }
        catch (XTSSoapFaultException e) {
            Element faultElement = e.getFaultXML(requestEnv.getLocale(), false);
            CogAdminLogger.getInstance().error("sendBusRequest", e);
            CogAdminLogger.getInstance().error("fault: " + faultElement.asXML());
            String detailErrorMessage = faultElement.valueOf("./*[local-name()='exceptionDetail']/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='detail']/*[local-name()='exception']/*[local-name()='message']/*[local-name()='messageString']");
            if (detailErrorMessage != null && detailErrorMessage.length() > 0) {
                throw new BaseFaultType("Unable to send bus request. - " + detailErrorMessage, e);
            }
            throw new BaseFaultType("Unable to send bus request.", e);
        }
        catch (XTSInstructionException e) {
            CogAdminLogger.getInstance().error("sendBusRequest", e);
            throw new BaseFaultType("Unable to send bus request.", e);
        }
    }

    private Reader signRequest(String request) throws BaseFaultType {
        String MN = "signRequest";
        if (CogAdminLogger.getInstance().isDebugEnabled()) {
            CogAdminLogger.getInstance().enter("signRequest");
        }
        try {
            TrustedRequestSession trs = this.camFactory.createTrustedSession();
            byte[] signedBytes = trs.setMessageTrust(COGADMIN_TRUSTED_IDENTIFIER, request.getBytes("UTF-8"));
            FilterInputStreamReader reader = new FilterInputStreamReader((InputStream)new ByteArrayInputStream(signedBytes), "UTF-8");
            reader.setFilter("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (CogAdminLogger.getInstance().isDebugEnabled()) {
                CogAdminLogger.getInstance().debug("signed request is: " + new String(signedBytes, "UTF-8"));
                CogAdminLogger.getInstance().exit("signRequest");
            }
            return reader;
        }
        catch (CAMCryptoException e) {
            CogAdminLogger.getInstance().error("signRequest", e);
            throw new BaseFaultType("BusRequest::signRequest", e);
        }
        catch (UnsupportedEncodingException e) {
            CogAdminLogger.getInstance().error("signRequest", e);
            throw new BaseFaultType("BusRequest::signRequest", e);
        }
    }
}

