/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.admin.common.BusRequest;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import com.cognos.xts.XTSEnvironment;
import java.io.Reader;
import java.util.Locale;

public class BusRequestHelper {
    public static Reader makeBusRequest(IContext context, String requestStr, String sTarget, String sSoapAction) throws BaseFaultType {
        return BusRequestHelper.makeBusRequest(context, requestStr, sTarget, sSoapAction, false, true);
    }

    public static Reader makeBusRequest(IContext context, String requestStr, String sTarget, String sSoapAction, boolean trusted, boolean responseEnveloppe) throws BaseFaultType {
        if (requestStr == null || requestStr.length() == 0 || sTarget == null || sTarget.length() == 0) {
            CogAdminLogger.getInstance().error("makeBusRequest: Unable to make bus request: " + requestStr + ", target is: " + sTarget);
            throw new BaseFaultType("makeBusRequest: Unable to make bus request: " + requestStr + ", target is: " + sTarget);
        }
        try {
            BusRequest busRequest = new BusRequest();
            XTSEnvironment env = new XTSEnvironment();
            env.setLocale(new Locale((String)context.getProperty("PRODUCT_LOCALE")));
            context.setProperty("XTS_ENV", (Object)env);
            busRequest.initialize(context);
            context.setProperty("bustarget", (Object)sTarget);
            context.setProperty("soapAction", (Object)sSoapAction);
            Reader busResponse = busRequest.send(context, requestStr, trusted, responseEnveloppe);
            busRequest.terminate();
            return busResponse;
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("makeBusRequest", e);
            throw new BaseFaultType("error.exception", e);
        }
    }
}

