/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.common.sax.IObjectFactory;
import com.cognos.cps.bseries.xts.pagelet.storage.sax.ObjectFactory;
import com.cognos.cps.bseries.xts.request.nav.bus.xmlHandler.BusHeaderXMLHandler;
import com.cognos.cps.bseries.xts.request.nav.bus.xmlHandler.CMResponseXMLHandler;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.ServiceException;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.bus.BusCommand;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.soap.impl.bus.cm.SimpleQuery;
import java.util.List;

public class CMRequest {
    private static final String CM_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201904/";
    private static final String CM_TARGET = "bus://cm";
    private static final String TRUSTED_SOAP_HEADERS = "<bus:biBusHeader xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"/>";
    private ServiceLogger m_logger;
    private IObjectFactory objectFactory = ObjectFactory.getInstance();

    public CMRequest(com.cognos.cps.common.logging.ServiceLogger logger) {
        this.m_logger = new ServiceLoggerImpl(CMRequest.class);
    }

    public void setObjectFactory(IObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public synchronized void initialize(IContext context) throws ServiceException {
    }

    public synchronized void terminate() throws ServiceException {
    }

    public void send(IContext context, String request, boolean trusted) throws Exception {
        SimpleQuery query = new SimpleQuery();
        this.send(context, request, trusted, query);
    }

    public List send(IContext context, String request, boolean trusted, boolean updateRequest) throws Exception {
        SimpleQuery query = new SimpleQuery();
        BusHeaderXMLHandler busHeaderXMLHandler = new BusHeaderXMLHandler();
        CMResponseXMLHandler bodyXMLHandler = new CMResponseXMLHandler(true, updateRequest ? "updateResult" : "queryResult", this.objectFactory);
        query.setResponseHeaderHandler((IXMLHandler)busHeaderXMLHandler);
        query.setResponseBodyHandler((IXMLHandler)bodyXMLHandler);
        this.send(context, request, trusted, query);
        return bodyXMLHandler.getCMResponse().getAllObjects();
    }

    public List<GenericCMObject> send(IContext context, BusCommand query, boolean trusted, boolean updateRequest) throws Exception {
        BusHeaderXMLHandler busHeaderXMLHandler = new BusHeaderXMLHandler();
        CMResponseXMLHandler bodyXMLHandler = new CMResponseXMLHandler(true, updateRequest ? "updateResult" : "queryResult", this.objectFactory);
        query.setResponseHeaderHandler((IXMLHandler)busHeaderXMLHandler);
        query.setResponseBodyHandler((IXMLHandler)bodyXMLHandler);
        this.send(context, trusted, query);
        return bodyXMLHandler.getCMResponse().getAllObjects();
    }

    protected void send(IContext context, String request, boolean trusted, SimpleQuery query) throws Exception {
        query.setBody(request);
        String MN = "sendCMRequest";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
            this.m_logger.debug("request is: " + request);
        }
        this.send(context, trusted, (BusCommand)query);
    }

    protected void send(IContext context, boolean trusted, BusCommand query) throws Exception {
        String MN = "sendCMRequest";
        SOAPConnection connection = null;
        if (trusted) {
            connection = ((SOAPConnectionFactory)context.getProperty("trustedSoapConnectionFactory")).createConnection(this.m_logger);
            query.setBusHeader((Object)TRUSTED_SOAP_HEADERS);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("using trusted request");
            }
        } else {
            connection = ((SOAPConnectionFactory)context.getProperty("SoapConnectionFactory")).createConnection(this.m_logger);
            query.setBusHeader((Object)context.getProperty("BUS_HEADER").toString());
        }
        query.setSOAPAction(CM_SOAP_ACTION);
        connection.execute((SOAPMessage)query, CM_TARGET);
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
    }

    public void send(IContext context, Query query, boolean trusted) throws Exception {
        String MN = "sendCMRequest";
        SOAPConnection connection = null;
        if (trusted) {
            connection = ((SOAPConnectionFactory)context.getProperty("trustedSoapConnectionFactory")).createConnection(this.m_logger);
            query.setBusHeader((Object)TRUSTED_SOAP_HEADERS);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("using trusted request");
            }
        } else {
            connection = ((SOAPConnectionFactory)context.getProperty("SoapConnectionFactory")).createConnection(this.m_logger);
            query.setBusHeader((Object)context.getProperty("BUS_HEADER").toString());
        }
        query.setSOAPAction(CM_SOAP_ACTION);
        connection.execute((SOAPMessage)query, CM_TARGET);
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
    }
}

