/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.admin.common.CMRequest;
import com.cognos.admin.common.TrustedSOAPConnectionFactoryImpl;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.common.sax.IObjectDescriptor;
import com.cognos.cps.bseries.xts.common.sax.IObjectFactory;
import com.cognos.cps.services.IContext;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.bus.BusCommand;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.util.LocaleUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class CMRequestHelper
extends Constants {
    private static final String QUERYSTRING_BEGIN = "<bus:query xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:queryRequest[]\">";
    private static final String QUERYSTRING_END = "</requests></bus:query>";
    private static final String QUERYSTRING_REQUEST_ITEM_BEGIN = "<item xsi:type=\"bus:queryRequest\">";
    private static final String QUERYSTRING_ITEM_END = "</item>";
    private static final String QUERYSTRING_SEARCH_BEGIN = "<search xsi:type=\"xsd:string\">";
    private static final String QUERYSTRING_SEARCH_END = "</search>";
    private static final String QUERYSTRING_PROPERTIES_BEGIN = "<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:propEnum[]\">";
    private static final String QUERYSTRING_PROPERTIES_END = "</properties>";
    private static final String QUERYSTRING_PROP_ITEM_BEGIN = "<item xsi:type=\"bus:propEnum\">";
    private static final CMObjectDescriptor m_CADM_CMdescriptor;
    private static CMRequest cmRequest;
    private static SOAPConnectionFactoryImpl soapConnection;
    private static TrustedSOAPConnectionFactoryImpl trustedSoapConnection;

    public static List<GenericCMObject> makeCMRequest(IContext context, String requestStr) throws BaseFaultType {
        return CMRequestHelper.makeCMRequest(context, requestStr, false, false);
    }

    public static List<GenericCMObject> makeCMRequest(IContext context, String requestStr, boolean trusted, boolean updateRequest) throws BaseFaultType {
        if (requestStr == null || requestStr.length() == 0) {
            CogAdminLogger.getInstance().error("makeCMRequest: Empty CM request string");
            throw new BaseFaultType("empty CM request string");
        }
        try {
            CMRequestHelper.prepareContext(context);
            return cmRequest.send(context, requestStr, trusted, updateRequest);
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("makeCMRequest", e);
            throw new BaseFaultType("error.exception", e);
        }
    }

    public static List<GenericCMObject> makeCMRequest(IContext context, Query query, boolean trusted, boolean updateRequest) throws Exception {
        CMRequestHelper.prepareContext(context);
        return cmRequest.send(context, (BusCommand)query, trusted, updateRequest);
    }

    public static void makeCMRequest(IContext context, BusCommand query, boolean trusted) throws Exception {
        CMRequestHelper.prepareContext(context);
        cmRequest.send(context, trusted, query);
    }

    private static void prepareContext(IContext context) {
        XTSEnvironment xtsEnv = new XTSEnvironment("COGADMIN");
        Locale locale = new Locale(context.getProperty("PRODUCT_LOCALE").toString());
        xtsEnv.setLocale(locale);
        xtsEnv.setLookupList(LocaleUtils.createLookupList((Locale)locale, (boolean)false));
        xtsEnv.setRequestContext("");
        xtsEnv.setSessionContext("");
        xtsEnv.setStepContext("");
        xtsEnv.setSubRequestContext("");
        context.setProperty("XTS_ENV", (Object)xtsEnv);
        context.setProperty("XTS_IDENTIFIER", (Object)"COGADMIN");
        context.setProperty("SoapConnectionFactory", (Object)soapConnection);
        context.setProperty("trustedSoapConnectionFactory", (Object)trustedSoapConnection);
    }

    public static StringBuffer startCMQueryRequest() {
        StringBuffer req = new StringBuffer();
        req.append(QUERYSTRING_BEGIN);
        return req;
    }

    public static void endCMQueryRequest(StringBuffer req) {
        if (req != null) {
            req.append(QUERYSTRING_END);
        }
    }

    public static void appendQueryRequest(StringBuffer req, String sSearchPath, List listOfProperties) throws BaseFaultType {
        if (req != null) {
            if (sSearchPath != null && sSearchPath.length() > 0 && listOfProperties != null && listOfProperties.size() > 0) {
                req.append(QUERYSTRING_REQUEST_ITEM_BEGIN);
                req.append(QUERYSTRING_SEARCH_BEGIN + sSearchPath + QUERYSTRING_SEARCH_END);
                req.append(QUERYSTRING_PROPERTIES_BEGIN);
                for (int i = 0; i < listOfProperties.size(); ++i) {
                    Object propObj = listOfProperties.get(i);
                    if (!PropertyType.class.isAssignableFrom(propObj.getClass())) continue;
                    PropertyType prop = (PropertyType)propObj;
                    String name = prop.getCMObjectName();
                    if (name == null || name.length() == 0) {
                        name = (String)prop.getID();
                    }
                    req.append(QUERYSTRING_PROP_ITEM_BEGIN + name + QUERYSTRING_ITEM_END);
                }
                req.append(QUERYSTRING_PROPERTIES_END);
                req.append(QUERYSTRING_ITEM_END);
                return;
            }
            CogAdminLogger.getInstance().warn("appendQueryRequest: the search path or property list is empty.");
            throw new BaseFaultType("the search path or property list is empty.");
        }
        CogAdminLogger.getInstance().warn("appendQueryRequest: the request string is null");
        throw new BaseFaultType("the request string is null");
    }

    public static String buildCMQueryRequest(String sSearchPath, List listOfProperties) throws BaseFaultType {
        return CMRequestHelper.buildCMQueryRequest(Arrays.asList(sSearchPath), listOfProperties);
    }

    public static String buildCMQueryRequest(List<String> sSearchPaths, List listOfProperties) throws BaseFaultType {
        StringBuffer req = CMRequestHelper.startCMQueryRequest();
        try {
            for (String searchPath : sSearchPaths) {
                CMRequestHelper.appendQueryRequest(req, searchPath, listOfProperties);
            }
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("buildCMQueryRequest", e);
            throw new BaseFaultType("error.exception", e);
        }
        CMRequestHelper.endCMQueryRequest(req);
        return req.toString();
    }

    public static GenericCMObject queryCMSingleRequest(String searchPath, ArrayList props, IContext context) {
        return CMRequestHelper.queryCMSingleRequest(searchPath, props, context, false);
    }

    public static GenericCMObject queryCMSingleRequest(String searchPath, ArrayList props, IContext context, boolean trusted) {
        if (searchPath == null || searchPath.length() == 0 || props == null || props.size() == 0) {
            return null;
        }
        try {
            String req = CMRequestHelper.buildCMQueryRequest(searchPath, (List)props);
            List<GenericCMObject> cmObjects = CMRequestHelper.makeCMRequest(context, req, trusted, false);
            if (cmObjects != null && cmObjects.size() > 0) {
                GenericCMObject cmObj = cmObjects.get(0);
                return cmObj;
            }
            CogAdminLogger.getInstance().error("queryCMSingleRequest - No response from CM.");
        }
        catch (BaseFaultType e) {
            CogAdminLogger.getInstance().error("queryCMSingleRequest", e);
        }
        return null;
    }

    static {
        ContextImpl portalContext;
        block4: {
            m_CADM_CMdescriptor = new CMObjectDescriptor();
            cmRequest = new CMRequest(null);
            cmRequest.setObjectFactory(new CMObjectFactory());
            portalContext = new ContextImpl();
            try {
                portalContext.setProperty("cmPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("contentManager", true)).getFile());
                portalContext.setProperty("dispatcherPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("internalDispatcher", true)).getFile());
            }
            catch (MalformedURLException e) {
                if (CogAdminLogger.getInstance().isInfoEnabled()) {
                    CogAdminLogger.getInstance().info("URL malformed while creating context.");
                }
            }
            catch (CCLConfigurationException e) {
                if (!CogAdminLogger.getInstance().isInfoEnabled()) break block4;
                CogAdminLogger.getInstance().info("Problem getting configuration while creating context.");
            }
        }
        soapConnection = new SOAPConnectionFactoryImpl((com.cognos.portal.utils.IContext)portalContext);
        trustedSoapConnection = new TrustedSOAPConnectionFactoryImpl((com.cognos.portal.utils.IContext)portalContext);
    }

    public static class CMObjectDescriptor
    implements IObjectDescriptor {
        private static ArrayList<String> g_supportedParams = new ArrayList(10);
        private static ArrayList<String> g_supportedArrays;
        private static ArrayList<String> g_supportedMaps;
        private static ArrayList<String> g_supportedDates;
        private static ArrayList<String> g_supportedNumerics;
        private static ArrayList<String> g_supportedChildObjects;

        public final boolean supportsObject(String att) {
            return g_supportedChildObjects.contains(att);
        }

        public final boolean supportsArray(String att) {
            return g_supportedArrays.contains(att);
        }

        public final boolean supportsMap(String att) {
            return g_supportedMaps.contains(att);
        }

        public boolean supportsDate(String att) {
            return g_supportedDates.contains(att);
        }

        public boolean supportsNumeric(String att) {
            return g_supportedNumerics.contains(att);
        }

        public final boolean supportsParameter(String att) {
            return g_supportedParams.contains(att);
        }

        public IXMLSerializable getHandler(String name) {
            return null;
        }

        public boolean hasHandler(String name) {
            return false;
        }

        static {
            g_supportedParams.add("objectClass");
            g_supportedParams.add("searchPath");
            g_supportedParams.add("storeID");
            g_supportedParams.add("tenantID");
            g_supportedParams.add("dispatcherPath");
            g_supportedParams.add("defaultName");
            g_supportedParams.add("defaultScreenTip");
            g_supportedParams.add("hidden");
            g_supportedParams.add("startAsActive");
            g_supportedParams.add("runningState");
            g_supportedParams.add("serverGroup");
            g_supportedMaps = new ArrayList(2);
            g_supportedMaps.add("name");
            g_supportedMaps.add("qsROLAPCubeConfigurations");
            g_supportedDates = new ArrayList();
            g_supportedNumerics = new ArrayList();
            g_supportedArrays = new ArrayList(2);
            g_supportedArrays.add("permissions");
            g_supportedArrays.add("userCapabilities");
            g_supportedChildObjects = new ArrayList(1);
            g_supportedChildObjects.add("parent");
        }
    }

    private static class CMObjectFactory
    implements IObjectFactory {
        private CMObjectFactory() {
        }

        public IObjectDescriptor getObjectDescriptor() {
            return m_CADM_CMdescriptor;
        }

        public GenericCMObject createObject(String type) {
            return new GenericCMObject(type);
        }
    }
}

