/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.i18n.DateTimeFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class COGAdminUtils
extends Constants {
    static final String STD_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static Properties props = null;
    private static final int BUFFER_SIZE = 65535;
    private static final String COGADMIN_PROPERTIES_FILE = "/cog_admin.properties";

    public static StringBuffer readerToStringBuffer(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        char[] cbuf = new char[65535];
        int read_this_time = 0;
        read_this_time = reader.read(cbuf, 0, 65535);
        while (read_this_time != -1) {
            buffer.append(cbuf, 0, read_this_time);
            read_this_time = reader.read(cbuf, 0, 65535);
        }
        reader.close();
        return buffer;
    }

    public static HashMap parseDispatcherPath(String sDispPath) throws BaseFaultType {
        HashMap<String, Object> names = new HashMap<String, Object>();
        String sHost = null;
        String sPort = null;
        String sPath = null;
        Boolean sslEnabled = null;
        Integer iPort = null;
        boolean isValid = true;
        int colonIdx = -1;
        if (sDispPath != null && sDispPath.length() > 0) {
            int nextIdx = sDispPath.indexOf("://");
            if (nextIdx != -1) {
                String sProtocol = sDispPath.substring(0, nextIdx);
                if (sProtocol.equalsIgnoreCase("http")) {
                    sslEnabled = new Boolean(false);
                } else if (sProtocol.equalsIgnoreCase("https")) {
                    sslEnabled = new Boolean(true);
                } else {
                    throw new BaseFaultType("The dispatcher url is invalid: " + sDispPath);
                }
                int bracketIdx = sDispPath.indexOf("]", nextIdx += 3);
                if (bracketIdx != -1) {
                    if (sDispPath.charAt(nextIdx) != '[') {
                        isValid = false;
                    } else {
                        colonIdx = sDispPath.indexOf(":", bracketIdx);
                    }
                } else {
                    colonIdx = sDispPath.indexOf(":", nextIdx);
                }
                if (isValid) {
                    if (colonIdx != -1) {
                        sHost = sDispPath.substring(nextIdx, colonIdx);
                        int pathIdx = sDispPath.indexOf("/", colonIdx + 1);
                        if (pathIdx != -1) {
                            sPort = sDispPath.substring(colonIdx + 1, pathIdx);
                            sPath = sDispPath.substring(pathIdx + 1);
                        } else {
                            sPort = sDispPath.substring(colonIdx + 1);
                        }
                    } else {
                        isValid = false;
                    }
                }
            } else {
                isValid = false;
            }
            try {
                int port = Integer.parseInt(sPort);
                iPort = new Integer(port);
            }
            catch (NumberFormatException ne) {
                isValid = false;
            }
        } else {
            isValid = false;
        }
        if (!isValid || sslEnabled == null || sHost == null || sHost.length() == 0 || sPort == null || sPort.length() == 0) {
            throw new BaseFaultType("The dispathcer url is invalid: " + sDispPath);
        }
        names.put("host", sHost);
        names.put("port", iPort);
        names.put("sslEnabled", sslEnabled);
        names.put("contextPath", sPath);
        return names;
    }

    public static synchronized String getProperty(String key) {
        if (props == null) {
            props = new Properties();
            try {
                InputStream stream = COGAdminUtils.class.getResourceAsStream(COGADMIN_PROPERTIES_FILE);
                props.load(stream);
            }
            catch (IOException e) {
                CogAdminLogger.getInstance().error("getProperty", e);
            }
        }
        return props.getProperty(key);
    }

    public static String RegexEncode(String regex) {
        if (regex.indexOf(92) == -1 && regex.indexOf(36) == -1) {
            return regex;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < regex.length(); ++i) {
            char regexChar = regex.charAt(i);
            if (regexChar == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (regexChar == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(regexChar);
        }
        return sb.toString();
    }

    public static String formatDate(Date date, String timeZoneId) {
        String retValue = null;
        if (date != null) {
            DateTimeFormat outDateFormat = new DateTimeFormat(STD_DATE_TIME_FORMAT);
            if (timeZoneId != null) {
                outDateFormat.setTimeZone(new com.cognos.i18n.TimeZone(timeZoneId));
            }
            retValue = outDateFormat.format(date);
        }
        return retValue;
    }

    public static String getLocalizedMessage(String msgBase, Locale locale, String msgId, Object[] msgArgs) {
        ResourceBundle bundle;
        String sLocalizedMsg = msgId;
        if (msgBase != null && (sLocalizedMsg = (bundle = ResourceBundle.getBundle(msgBase, locale)).getString(msgId)) != null && msgArgs.length > 0) {
            sLocalizedMsg = MessageFormat.format(sLocalizedMsg, msgArgs);
        }
        return sLocalizedMsg;
    }

    public static class XMLSchemaDateFormat {
        private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

        public static String getTimeStamp() {
            return XMLSchemaDateFormat.getTimeStamp(new Date());
        }

        public static String getTimeStamp(Date date) {
            return sdf.format(date);
        }

        static {
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }
}

