/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SystemProtectionSession;
import com.cognos.admin.common.COGAdminUtils;
import com.cognos.admin.common.cache.CacheManager;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.cps.cache.CacheEncryptor;
import com.cognos.cps.cache.CacheException;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.properties.PropertiesManager;
import java.io.File;

public class CacheManagerSingleton {
    private static CacheManager cacheManager;

    private CacheManagerSingleton() {
    }

    public static synchronized CacheManager getInstance() throws CacheException {
        if (cacheManager == null) {
            try {
                cacheManager = new CacheManager("adminCache", new File(CacheManagerSingleton.tempDirPath()), CacheManagerSingleton.timeToIdleSeconds(), CacheManagerSingleton.timeToLiveSeconds(), CacheManagerSingleton.checkExpiryIntervalSeconds(), CacheManagerSingleton.cacheEncryptor(), CacheManagerSingleton.getCacheMaxSize());
            }
            catch (XTSInstructionException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("CacheManagerSingleton.getInstancefailed", e);
                }
                throw new CacheException("CacheManagerSingleton.getInstancefailed", (Throwable)e);
            }
        }
        return cacheManager;
    }

    private static CacheEncryptor cacheEncryptor() throws CacheException {
        String encryptTemporaryFiles = COGAdminUtils.getProperty("properties.config.cache.encryptTemporaryFiles");
        if ("true".equals(encryptTemporaryFiles)) {
            try {
                return new JCAMCacheEncryptor();
            }
            catch (Exception e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("CacheManagerSingleton.cacheEncryptorfailed", e);
                }
                throw new CacheException("CacheManagerSingleton.cacheEncryptorfailed", (Throwable)e);
            }
        }
        return new NullCacheEncryptor();
    }

    private static int timeToIdleSeconds() {
        block3: {
            String sTimeToIdleSeconds = COGAdminUtils.getProperty("properties.config.cache.timeToIdleSeconds");
            if (sTimeToIdleSeconds != null) {
                try {
                    return Integer.parseInt(sTimeToIdleSeconds);
                }
                catch (NumberFormatException e) {
                    if (!CogAdminLogger.getInstance().isWarnEnabled()) break block3;
                    CogAdminLogger.getInstance().warn("CacheManagerSingleton.timeToIdleSecondsfailed. " + sTimeToIdleSeconds + " is not a number. Defaulting to:" + 1800);
                }
            }
        }
        return 1800;
    }

    private static int getCacheMaxSize() {
        int cacheValue;
        String value = COGAdminUtils.getProperty("properties.config.cache.maxCacheSize");
        try {
            cacheValue = value != null ? Integer.parseInt(value) : -1;
        }
        catch (NumberFormatException e) {
            cacheValue = -1;
        }
        return cacheValue;
    }

    private static int timeToLiveSeconds() {
        block3: {
            String sTimeToLiveSeconds = COGAdminUtils.getProperty("properties.config.cache.timeToLiveSeconds");
            if (sTimeToLiveSeconds != null) {
                try {
                    return Integer.parseInt(sTimeToLiveSeconds);
                }
                catch (NumberFormatException e) {
                    if (!CogAdminLogger.getInstance().isWarnEnabled()) break block3;
                    CogAdminLogger.getInstance().warn("CacheManagerSingleton.timeToLiveSecondsfailed. " + sTimeToLiveSeconds + " is not a number. Defaulting to:" + 3600);
                }
            }
        }
        return 3600;
    }

    private static int checkExpiryIntervalSeconds() {
        block3: {
            String sCheckExpiryIntervalSeconds = COGAdminUtils.getProperty("properties.config.cache.checkExpiryIntervalSeconds");
            if (sCheckExpiryIntervalSeconds != null) {
                try {
                    return Integer.parseInt(sCheckExpiryIntervalSeconds);
                }
                catch (NumberFormatException e) {
                    if (!CogAdminLogger.getInstance().isWarnEnabled()) break block3;
                    CogAdminLogger.getInstance().warn("CacheManagerSingleton.timeToIdleSecondsfailed. " + sCheckExpiryIntervalSeconds + " is not a number. Defaulting to:" + 300);
                }
            }
        }
        return 300;
    }

    private static String tempDirPath() throws XTSInstructionException {
        String tempDirPath = PropertiesManager.getInstance().getProperty("xts.tempdir");
        if (tempDirPath == null) {
            if (CogAdminLogger.getInstance().isWarnEnabled()) {
                CogAdminLogger.getInstance().warn("CacheManagerSingleton.tempDirPathfailed. Defaulting to:300");
            }
            tempDirPath = "admin.tempdir";
        }
        return tempDirPath;
    }

    private static class JCAMCacheEncryptor
    implements CacheEncryptor {
        private SystemProtectionSession session = new SystemProtectionSession();

        public synchronized byte[] encrypt(byte[] b) {
            try {
                return this.session.encryptData(b);
            }
            catch (CAMCryptoException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("CacheManagerSingleton.encryptfailed", e);
                }
                throw new CacheException("CacheManagerSingleton.encryptfailed", (Throwable)e);
            }
        }

        public synchronized byte[] decrypt(byte[] b) {
            try {
                return this.session.decryptData(b);
            }
            catch (CAMCryptoException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("CacheManagerSingleton.decryptfailed", e);
                }
                throw new CacheException("CacheManagerSingleton.decryptfailed", (Throwable)e);
            }
        }
    }

    private static class NullCacheEncryptor
    implements CacheEncryptor {
        private NullCacheEncryptor() {
        }

        public byte[] encrypt(byte[] b) {
            return b;
        }

        public byte[] decrypt(byte[] b) {
            return b;
        }
    }
}

