/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.admin.common.DateDurationException;
import com.cognos.admin.common.DurationDefinition;
import com.cognos.admin.common.MsgKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class DateDuration {
    public static final String UNDEFINED_DEFINITION = "UNDEFINED_DEFINITION";
    public static final String UNDEFINED_START_DATE = "UNDEFINED_START_DATE";
    public static final String INVALID_START_DATE = "INVALID_START_DATE";
    public static final String UNDEFINED_DATE_FORMAT = "UNDEFINED_DATE_FORMAT";
    public static final String INVALID_DATE_FORMAT = "INVALID_DATE_FORMAT";
    public static final String UNDEFINED_END_DATE = "UNDEFINED_END_DATE";
    public static final String INVALID_END_DATE = "INVALID_END_DATE";
    public static final String INVALID_START_END_DATES = "INVALID_START_END_DATES";
    Duration duration = null;

    private DateDuration(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public static DateDuration calculateDuration(DurationDefinition definition) throws DatatypeConfigurationException {
        DateConverter dateConverter = null;
        Duration duration = null;
        if (definition == null) {
            throw new DateDurationException("Undefined definition", new MsgKey(UNDEFINED_DEFINITION));
        }
        dateConverter = new DateConverter(definition.getStartDate(), definition.getEndDate(), definition.getDateFormat());
        dateConverter.convertDates();
        duration = DateDuration.calculateDuration(dateConverter.getStart(), dateConverter.getEnd());
        return new DateDuration(duration);
    }

    private static Duration calculateDuration(Date start, Date end) throws DatatypeConfigurationException {
        if (start.after(end)) {
            throw new DateDurationException("Invalid start and end dates", new MsgKey(INVALID_START_END_DATES));
        }
        DatatypeFactory df = DatatypeFactory.newInstance();
        long delta = end.getTime() - start.getTime();
        if (delta == 0L) {
            return df.newDurationDayTime(true, 0, 0, 0, 0);
        }
        return df.newDuration(delta);
    }

    private static class DateConverter {
        private Date start = null;
        private Date end = null;
        private String startDate = null;
        private String endDate = null;
        private String dateFormat = null;

        private DateConverter(String startDate, String endDate, String dateFormat) {
            this.dateFormat = dateFormat;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        private void convertDates() {
            if (!DateConverter.isDateFormatDefined(this.dateFormat)) {
                throw new DateDurationException("Undefined date format", new MsgKey(DateDuration.UNDEFINED_DATE_FORMAT));
            }
            if (!DateConverter.isDateDefined(this.startDate)) {
                throw new DateDurationException("Undefined start date", new MsgKey(DateDuration.UNDEFINED_START_DATE));
            }
            this.start = DateConverter.convertStartDate(this.startDate, this.dateFormat);
            if (!DateConverter.isDateDefined(this.endDate)) {
                throw new DateDurationException("Undefined start date", new MsgKey(DateDuration.UNDEFINED_END_DATE));
            }
            this.end = DateConverter.convertEndDate(this.endDate, this.dateFormat);
        }

        private Date getStart() {
            return this.start;
        }

        private Date getEnd() {
            return this.end;
        }

        private static boolean isDateDefined(String date) {
            return date != null && date.trim().length() > 0;
        }

        private static boolean isDateFormatDefined(String dateFormat) {
            return dateFormat != null && dateFormat.trim().length() > 0;
        }

        private static Date convertStartDate(String startDate, String dateFormat) {
            Date date = null;
            try {
                date = DateConverter.convertString2Date(startDate, dateFormat);
            }
            catch (IllegalArgumentException iaex) {
                throw new DateDurationException("Invalid date format", new MsgKey(DateDuration.INVALID_DATE_FORMAT));
            }
            catch (Exception e) {
                throw new DateDurationException("Invalid start date", new MsgKey(DateDuration.INVALID_START_DATE));
            }
            return date;
        }

        private static Date convertEndDate(String endDate, String dateFormat) {
            Date date = null;
            try {
                date = DateConverter.convertString2Date(endDate, dateFormat);
            }
            catch (IllegalArgumentException iaex) {
                throw new DateDurationException("Invalid date format", new MsgKey(DateDuration.INVALID_DATE_FORMAT));
            }
            catch (Exception e) {
                throw new DateDurationException("Invalid end date", new MsgKey(DateDuration.INVALID_END_DATE));
            }
            return date;
        }

        private static Date convertString2Date(String source, String dateFormat) throws ParseException {
            SimpleDateFormat simpleDateFormat = null;
            Date date = null;
            simpleDateFormat = new SimpleDateFormat(dateFormat);
            date = simpleDateFormat.parse(source);
            return date;
        }
    }
}

