/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.xts.properties.PropertiesManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class InstalledComponents {
    public static boolean isInstalled(String componentToTest) {
        List<String> installedComps = InstalledComponents.getInstalledComponents();
        return installedComps != null ? installedComps.contains(componentToTest) : true;
    }

    public static boolean isInstalled(String componentToTest, String dispatcherPath) throws Exception {
        return InstalledComponents.getInstalledComponents(dispatcherPath).contains(componentToTest);
    }

    public static boolean isInstalled(List<String> componentsToTest) {
        return InstalledComponents.isInstalled(componentsToTest, InstalledComponents.getInstalledComponents());
    }

    public static boolean isInstalled(String componentToTest, List installedComponents) {
        return installedComponents == null || componentToTest == null || installedComponents.contains(componentToTest);
    }

    public static boolean isInstalled(List<String> componentsToTest, List<String> installedComponents) {
        if (installedComponents != null && componentsToTest != null) {
            Iterator<String> iter = componentsToTest.iterator();
            while (iter.hasNext()) {
                if (installedComponents.contains(iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    private static List selectNodes(Document doc, String xPath) {
        return doc.selectNodes(xPath);
    }

    public static List<String> getInstalledComponents() {
        block3: {
            String installedComponentsXML = PropertiesManager.getInstance().getProperty("installedComponents");
            if (installedComponentsXML != null && installedComponentsXML.length() > 0) {
                try {
                    Document installedComponentsDoc = DocumentHelper.parseText((String)installedComponentsXML);
                    return InstalledComponents.getComponentStringListFromElementList(InstalledComponents.selectNodes(installedComponentsDoc, "//component"));
                }
                catch (DocumentException e) {
                    if (!CogAdminLogger.getInstance().isDebugEnabled()) break block3;
                    CogAdminLogger.getInstance().debug("Could not parse the installedComponents XML. Root is " + e.getMessage());
                }
            }
        }
        return null;
    }

    public static List<String> getInstalledComponents(String dispatcherPath) throws Exception {
        if (dispatcherPath == null || dispatcherPath.length() == 0) {
            return InstalledComponents.getInstalledComponents();
        }
        String installedComponentsXML = PropertiesManager.getInstance().getProperty("installedComponents");
        if (installedComponentsXML != null && installedComponentsXML.length() > 0) {
            String propXML = PropertiesManager.getInstance().getProperty("installedComponentsPerDispatcher");
            Document installedComponentsDoc = DocumentHelper.parseText((String)propXML);
            dispatcherPath = InstalledComponents.removeProtocol(dispatcherPath);
            return InstalledComponents.getComponentStringListFromElementList(InstalledComponents.selectNodes(installedComponentsDoc, "//dispatcher[@name='" + dispatcherPath + "']/component"));
        }
        return null;
    }

    public static String removeProtocol(String dispatcherPath) {
        try {
            URL dispUrl = new URL(dispatcherPath);
            String dispName = dispUrl.getAuthority() + dispUrl.getPath();
            return dispName;
        }
        catch (MalformedURLException e) {
            return dispatcherPath;
        }
    }

    private static List<String> getComponentStringListFromElementList(List<Element> elementList) {
        ArrayList<String> installedComponents;
        if (elementList != null) {
            installedComponents = new ArrayList(elementList.size());
            for (Element e : elementList) {
                installedComponents.add(e.getTextTrim());
            }
        } else {
            installedComponents = new ArrayList<String>(0);
        }
        return installedComponents;
    }
}

