/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.admin.common.logging.CogAdminLogger;

public class ReflectionUtils {
    public static void loadClass(Class clas) throws Exception {
        try {
            ReflectionUtils.loadClass(clas.getName());
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("loadClass", e);
            throw e;
        }
    }

    public static void loadClass(String className) throws Exception {
        try {
            ReflectionUtils.class.getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("loadClass", e);
            throw e;
        }
    }

    public static Class classForName(String className) throws Exception {
        return ReflectionUtils.classForName(className, null);
    }

    public static Class classForName(String className, Class instanceOf) throws Exception {
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz != null && instanceOf != null && !instanceOf.isAssignableFrom(clazz)) {
                String errMsg = "classForName(className,instanceOf):" + className + " is not an expected instance of " + instanceOf + ".";
                CogAdminLogger.getInstance().error(errMsg);
                throw new Exception(errMsg);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            CogAdminLogger.getInstance().error("classForName(className,instanceOf):");
            throw e;
        }
    }

    public static Object newInstance(String className) throws Exception {
        return ReflectionUtils.newInstance(className, null);
    }

    public static Object newInstance(Class clazz) throws Exception {
        return ReflectionUtils.newInstance(clazz, null);
    }

    public static Object newInstance(String className, Class instanceOf) throws Exception {
        return ReflectionUtils.newInstance(ReflectionUtils.classForName(className), instanceOf);
    }

    public static Object newInstance(Class clazz, Class instanceOf) throws Exception {
        String className = clazz.getName();
        try {
            return ReflectionUtils.classForName(className, instanceOf).newInstance();
        }
        catch (InstantiationException e) {
            CogAdminLogger.getInstance().error("newInstance(Clazz,instanceOf) An error occured trying to instantiate an instance of " + instanceOf + " for class name:" + className, e);
            throw e;
        }
        catch (IllegalAccessException e) {
            CogAdminLogger.getInstance().error("newInstance(Clazz,instanceOf) An error occured trying to instantiate an instance of " + instanceOf + " for class name:" + className, e);
            throw e;
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("newInstance(Clazz,instanceOf) An error occured trying to instantiate an instance of " + instanceOf + " for class name:" + className, e);
            throw e;
        }
    }
}

