/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.admin.common.ReflectionUtils;
import com.cognos.admin.resource.v1_0.CMResourceID;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import java.util.HashMap;

public class ResourceIdFactory {
    private static final HashMap<String, Class<? extends IResourceID>> applications = new HashMap();

    public static void register(String application, Class<? extends IResourceID> resourceIdClass) {
        applications.put(application, resourceIdClass);
    }

    public static IResourceID getResourceID(String type, String id, IResourceID refResourceId, IContext context) throws BaseFaultType {
        return ResourceIdFactory.getResourceID(ResourceLookupManager.getInstance().getApplication(context), type, id, refResourceId);
    }

    public static IResourceID getResourceID(String application, String type, String id, IResourceID refResourceId) throws BaseFaultType {
        IResourceID instance = ResourceIdFactory.getInstance(application);
        instance.init(type, id, refResourceId);
        return instance;
    }

    public static IResourceID getResourceID(String type, String id, IContext context) throws BaseFaultType {
        return ResourceIdFactory.getResourceID(type, id, null, context);
    }

    public static IResourceID getResourceID(String resourceId) throws BaseFaultType {
        IResourceID instance = ResourceIdFactory.getInstance(resourceId.split(":", 2)[0]);
        instance.init(resourceId);
        return instance;
    }

    private static IResourceID getInstance(String application) throws BaseFaultType {
        try {
            return (IResourceID)ReflectionUtils.newInstance(applications.get(application), IResourceID.class);
        }
        catch (Exception e) {
            throw new BaseFaultType(e);
        }
    }

    static {
        ResourceIdFactory.register("cm", CMResourceID.class);
    }
}

