/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common;

import com.cognos.admin.common.AdminConfigProperties;
import com.cognos.admin.common.AdminMetadataRetriever;
import com.cognos.admin.common.ReflectionUtils;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.Action;
import com.cognos.admin.resource.v1_0.ActionsHandler;
import com.cognos.admin.resource.v1_0.BusActionType;
import com.cognos.admin.resource.v1_0.BusActionsHandler;
import com.cognos.admin.resource.v1_0.DateTimeMBeanType;
import com.cognos.admin.resource.v1_0.DurationMBeanType;
import com.cognos.admin.resource.v1_0.EnumerationMBeanType;
import com.cognos.admin.resource.v1_0.GenericActionsHandler;
import com.cognos.admin.resource.v1_0.MBeanActionType;
import com.cognos.admin.resource.v1_0.MBeanActionsHandler;
import com.cognos.admin.resource.v1_0.MBeanByRefActionsHandler;
import com.cognos.admin.resource.v1_0.MBeanPropertiesHandler;
import com.cognos.admin.resource.v1_0.MBeanType;
import com.cognos.admin.resource.v1_0.MetadataDescriptorPropertyType;
import com.cognos.admin.resource.v1_0.PropertiesHandler;
import com.cognos.admin.resource.v1_0.PropertiesHandlerPropertyType;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.SchemaPropertiesHandler;
import com.cognos.admin.resource.v1_0.StringMBeanType;
import com.cognos.admin.resource.v1_0.UnsignedLongMBeanType;
import com.cognos.admin.resource.v1_0.intf.IActionsHandler;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceAttribute;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.admin.ws.wsrf.wsrf_rp.v1_2.InvalidResourcePropertyQNameFaultType;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.dom4j.Element;

public class ResourcePropertiesRetriever {
    private static ResourcePropertiesRetriever m_Instance = null;
    private AdminMetadataRetriever m_MetadataRetriverInstance = null;
    public static final String MUWS_DEFAULT_TYPE = "default";
    public static final String MUWS_UNSIGNEDLONG_TYPE = "unsignedLong";
    public static final String MUWS_DATETIME_TYPE = "dateTime";
    public static final String MUWS_DURATION_TYPE = "duration";
    public static final String MUWS_ENUMERATION_TYPE = "enumeration";
    public static final String MUWS_STRING_TYPE = "string";
    private static HashMap<String, ResourcePropertiesRetriever> propertyRetrievers = new HashMap();
    private static HashMap mMuwsTypes = new HashMap();
    private static final String PROPERTIES_CACHE = "properties-";
    private static final StringBuffer sbXPathExpPrefix;
    private static final StringBuffer sbXPathExprSuffix;
    private static final String sbXPathHandlersExpr;
    private static final String sbxPathPropertyType;
    private Map resourceCache = Collections.synchronizedMap(new HashMap(22));

    private ResourcePropertiesRetriever() {
    }

    public static ResourcePropertiesRetriever getInstance(String application) throws CacheException {
        m_Instance = propertyRetrievers.get(ResourceLookupManager.getInstance().getApplication(application));
        if (null == m_Instance) {
            m_Instance = new ResourcePropertiesRetriever();
            propertyRetrievers.put(application, m_Instance);
            ResourcePropertiesRetriever.m_Instance.m_MetadataRetriverInstance = AdminMetadataRetriever.getInstance(application);
        }
        return m_Instance;
    }

    public static ResourcePropertiesRetriever getInstance(IContext context) throws CacheException {
        return ResourcePropertiesRetriever.getInstance(ResourceLookupManager.getInstance().getApplication(context));
    }

    private ArrayList getALLiResourceProperties(String resourceType, Locale tl) {
        String cacheKey = new StringBuffer(PROPERTIES_CACHE).append(resourceType).append(tl).toString();
        ArrayList propArray = (ArrayList)this.resourceCache.get(cacheKey);
        if (null == propArray) {
            propArray = this.populatePropsCache(cacheKey, resourceType, tl);
        }
        return propArray;
    }

    private ArrayList getALLiActionsProperties(String resourceType, String sCapability, Locale tl) throws CacheException {
        String sCacheKey;
        String sIdentifier = null;
        if (sCapability == null) {
            sIdentifier = "resource";
            sCapability = "http://cognos.com/admin/supportedactions/" + sIdentifier + "/";
        } else {
            int startIdx;
            int endIdx;
            int foundIdx = sCapability.indexOf("http://cognos.com/admin/supportedactions/");
            if (foundIdx != -1 && (endIdx = sCapability.indexOf("/", startIdx = foundIdx + "http://cognos.com/admin/supportedactions/".length())) != -1) {
                sIdentifier = sCapability.substring(startIdx, endIdx);
            }
        }
        ArrayList actnArray = null;
        if (sIdentifier != null && null == (actnArray = (ArrayList)this.resourceCache.get(sCacheKey = new StringBuffer(sIdentifier).append('-').append(resourceType).append(tl).toString()))) {
            actnArray = this.populateActionsCache(sCacheKey, resourceType, sCapability, tl);
        }
        return actnArray;
    }

    private Object getSingleProperty(String resourceType, String propName, Locale tl) throws CacheException {
        String cacheKey = new StringBuffer(PROPERTIES_CACHE).append(resourceType).append(tl).toString();
        ArrayList propArray = (ArrayList)this.resourceCache.get(cacheKey);
        if (null == propArray) {
            propArray = this.populatePropsCache(cacheKey, resourceType, tl);
        }
        QName qName = QName.valueOf(propName);
        String propShortName = qName.getLocalPart();
        propShortName = propShortName.substring(propShortName.lastIndexOf(":") + 1, propShortName.length());
        for (IResourceProperty thisProp : propArray) {
            if (!propShortName.equalsIgnoreCase((String)thisProp.getID())) continue;
            return thisProp.clone();
        }
        return null;
    }

    private ArrayList getALLiResourceProperties(String resourceType, ArrayList propList, Locale tl) throws Exception {
        return this.filterProps(this.getALLiResourceProperties(resourceType, tl), propList);
    }

    private ArrayList getALLiActionsProperties(String resourceType, ArrayList actionList, String sCapability, Locale tl) throws Exception {
        return this.filterProps(this.getALLiActionsProperties(resourceType, sCapability, tl), actionList);
    }

    private synchronized ArrayList populatePropsCache(String cacheKey, String resourceType, Locale tl) {
        Element resourceElem = this.m_MetadataRetriverInstance.getAllMetadataPropertiesRO(resourceType, tl);
        ArrayList propArray = this.buildTypePropertyArray(resourceElem, resourceType, tl);
        this.resourceCache.put(cacheKey, propArray);
        return propArray;
    }

    private synchronized ArrayList populateActionsCache(String sCacheKey, String resourceType, String sCapability, Locale tl) {
        Element resourceElem = this.m_MetadataRetriverInstance.getAllMetadataPropertiesRO(resourceType, tl);
        ArrayList propArray = this.buildTypeActionArray(resourceElem, sCapability);
        this.resourceCache.put(sCacheKey, propArray);
        return propArray;
    }

    private boolean propertyListed(String aProp, ArrayList propList) {
        for (String listedProp : propList) {
            if (listedProp.compareToIgnoreCase(aProp) != 0) continue;
            return true;
        }
        return false;
    }

    public ArrayList getiResourceCMProperties(String resourceType, ArrayList propList, Locale tl) {
        return this.getCMorGenericProperties(resourceType, propList, "CM", tl);
    }

    private ArrayList getCMorGenericProperties(String resourceType, ArrayList propList, String propSource, Locale tl) {
        ArrayList resultList = this.getALLiResourceProperties(resourceType, tl);
        ArrayList destArray = new ArrayList(resultList.size());
        for (Object property : resultList) {
            PropertyType thisProp;
            if (property instanceof MBeanType || property instanceof PropertyType && (thisProp = (PropertyType)property).getPropSource().compareToIgnoreCase(propSource) != 0) continue;
            destArray.add(property);
        }
        return this.filterProps(destArray, propList);
    }

    private ArrayList filterProps(ArrayList inList, ArrayList iResourcePropertyList) {
        ArrayList<Object> outList = null;
        if (inList != null) {
            if (iResourcePropertyList == null) {
                outList = this.cloneIResourceAttributeArray(inList);
            } else {
                outList = new ArrayList<Object>(inList.size());
                for (IResourceAttribute thisProp : inList) {
                    if (!this.propertyListed((String)thisProp.getID(), iResourcePropertyList)) continue;
                    outList.add(thisProp.clone());
                }
            }
        }
        return outList;
    }

    private ArrayList filterPropsByHandler(ArrayList inList, String handlerName) throws Exception {
        ArrayList<Object> outList = null;
        if (inList != null) {
            if (handlerName == null) {
                outList = this.cloneIResourceAttributeArray(inList);
            } else {
                outList = new ArrayList<Object>(inList.size());
                for (IResourceAttribute thisProp : inList) {
                    if (!thisProp.getHandlerName().equalsIgnoreCase(handlerName)) continue;
                    outList.add(thisProp.clone());
                }
            }
        }
        return outList;
    }

    private void buildPropertyType(Element element, String handlerName, ArrayList resList, String resourceType, String value, Locale tl) {
        try {
            Element typeElem;
            Class propertyTypeClass = Class.forName(handlerName).getAnnotation(PropertiesHandlerPropertyType.class).clazz();
            PropertyType newClazz = (PropertyType)ReflectionUtils.newInstance(propertyTypeClass);
            newClazz.setID(element);
            newClazz.setHandlerName(handlerName);
            newClazz.setValue(value);
            if (newClazz instanceof MetadataDescriptorPropertyType && null != (typeElem = element.element(AdminConfigProperties.COG_TYPE.getLocalPart())) && typeElem.getText().compareToIgnoreCase("XML") == 0) {
                Element metadataElem = this.m_MetadataRetriverInstance.getAllMetadataProperties(resourceType, tl);
                newClazz.setValue(metadataElem);
            }
            resList.add(newClazz);
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("buildPropertyType", e);
        }
    }

    void purgeMDD(Element mddElement) {
        Element someElem;
        Element toBeRemoved = null;
        Iterator iter = mddElement.elementIterator(AdminConfigProperties.COG_PROPERTY.getLocalPart());
        while (iter.hasNext()) {
            someElem = (Element)iter.next();
            toBeRemoved = someElem.element(AdminConfigProperties.COG_PROPERTY_HANDLER.getLocalPart());
            if (null == toBeRemoved) continue;
            someElem.remove(toBeRemoved);
        }
        iter = mddElement.elementIterator(AdminConfigProperties.COG_ACTION.getLocalPart());
        while (iter.hasNext()) {
            someElem = (Element)iter.next();
            toBeRemoved = someElem.element(AdminConfigProperties.COG_PROPERTY_HANDLER.getLocalPart());
            if (null != toBeRemoved) {
                someElem.remove(toBeRemoved);
            }
            if (null != (toBeRemoved = someElem.element(AdminConfigProperties.COG_ACTION_REQUEST.getLocalPart()))) {
                someElem.remove(toBeRemoved);
            }
            if (null == (toBeRemoved = someElem.element(AdminConfigProperties.COG_ACTION_ACCESS.getLocalPart()))) continue;
            someElem.remove(toBeRemoved);
        }
    }

    private void buildActionType(Element element, String sHandlerClassName, ArrayList resList) {
        Action action = null;
        try {
            Class<?> clazz = Class.forName(sHandlerClassName);
            if (BusActionsHandler.class.isAssignableFrom(clazz)) {
                action = new BusActionType(element);
            } else if (MBeanActionsHandler.class.isAssignableFrom(clazz)) {
                action = new MBeanActionType(element);
            } else if (MBeanByRefActionsHandler.class.isAssignableFrom(clazz)) {
                action = new MBeanActionType(element);
            } else if (ActionsHandler.class.isAssignableFrom(clazz)) {
                action = new Action(element);
            } else {
                CogAdminLogger.getInstance().error("Skipping unsupported action handler : " + sHandlerClassName);
                return;
            }
            action.setID(ResourcePropertiesRetriever.getName(element));
            action.setHandlerName(sHandlerClassName);
            resList.add(action);
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("buildTypePropertyArray", e);
        }
    }

    public static String getName(Element aElement) {
        Element nameElem = aElement.element(AdminConfigProperties.COG_NAME.getLocalPart());
        return nameElem.getText();
    }

    private void addMBeansProps(Element aElement, MBeanType mbeanObj) {
        Element mBeanElem = aElement.element(AdminConfigProperties.COG_PROPERTY_HANDLER.getLocalPart());
        if (null != mBeanElem.element(AdminConfigProperties.COG_PROPERTY_HANDLER_OBJ_NAME.getLocalPart())) {
            mbeanObj.setMBeanObjectName(mBeanElem.element(AdminConfigProperties.COG_PROPERTY_HANDLER_OBJ_NAME.getLocalPart()).getText());
        }
        if (null != mBeanElem.element(AdminConfigProperties.COG_PROPERTY_HANDLER_VALUE.getLocalPart())) {
            mbeanObj.setMBeanValueAttrName(mBeanElem.element(AdminConfigProperties.COG_PROPERTY_HANDLER_VALUE.getLocalPart()).getText());
        }
        Iterator attrMapList = mBeanElem.elementIterator(AdminConfigProperties.MBEAN_ATTR_MAP.getLocalPart());
        while (attrMapList.hasNext()) {
            Element attributeElem = (Element)attrMapList.next();
            mbeanObj.setAttributeMap(attributeElem.attributeValue(AdminConfigProperties.MBEAN_ATTR_MAP_DISP.getLocalPart()), attributeElem.attributeValue(AdminConfigProperties.MBEAN_ATTR_MAP_JMX.getLocalPart()));
        }
    }

    private ArrayList buildTypePropertyArray(Element aElem, String resourceType, Locale tl) {
        List list = aElem.selectNodes(sbxPathPropertyType);
        ArrayList<MBeanType> resultList = new ArrayList<MBeanType>(list.size());
        for (Element property : list) {
            Element typeElem = property.element(AdminConfigProperties.TYPE);
            Element handler = property.element(AdminConfigProperties.COG_PROPERTY_HANDLER.getLocalPart());
            if (null == handler) continue;
            try {
                String handlerName = handler.element(AdminConfigProperties.COG_PROPERTY_HANDLER_NAME.getLocalPart()).getText();
                if (null != typeElem && MBeanPropertiesHandler.class.isAssignableFrom(Class.forName(handlerName))) {
                    String aNsType = typeElem.getText();
                    String aType = aNsType.substring(aNsType.lastIndexOf(":") + 1);
                    Class className = (Class)mMuwsTypes.get(aType);
                    if (className == null) {
                        className = (Class)mMuwsTypes.get(MUWS_DEFAULT_TYPE);
                    }
                    MBeanType mBeanType = (MBeanType)ReflectionUtils.newInstance(className);
                    mBeanType.setID(property);
                    mBeanType.setHandlerName(handlerName);
                    this.addMBeansProps(property, mBeanType);
                    Element units = property.element(AdminConfigProperties.UNITS);
                    if (units != null) {
                        mBeanType.setUnits(units.getText());
                    }
                    resultList.add(mBeanType);
                    continue;
                }
                Element eValue = handler.element(AdminConfigProperties.COG_PROPERTY_HANDLER_VALUE.getLocalPart());
                String value = eValue != null ? eValue.getText() : null;
                this.buildPropertyType(property, handlerName, resultList, resourceType, value, tl);
            }
            catch (Exception e) {
                CogAdminLogger.getInstance().error("buildTypePropertyArray", e);
            }
        }
        return resultList;
    }

    private ArrayList buildTypeActionArray(Element aElem, String sCapability) {
        int endIdx;
        ArrayList resultList = new ArrayList(1);
        int foundIdx = sCapability.indexOf("http://cognos.com/admin/supportedactions/");
        if (foundIdx != -1 && (endIdx = sCapability.indexOf("/", "http://cognos.com/admin/supportedactions/".length())) != -1) {
            String sBaseCapability = sCapability.substring(0, endIdx + 1);
            StringBuffer sbXPathExp = new StringBuffer();
            sbXPathExp.append(sbXPathExpPrefix).append(sBaseCapability).append(sbXPathExprSuffix);
            List list = aElem.selectNodes(sbXPathExp.toString());
            for (Element action : list) {
                Element handler = action.element(AdminConfigProperties.COG_PROPERTY_HANDLER.getLocalPart());
                if (null == handler) continue;
                String sHandlerClassName = handler.element(AdminConfigProperties.COG_PROPERTY_HANDLER_NAME.getLocalPart()).getText();
                this.buildActionType(action, sHandlerClassName, resultList);
            }
        }
        return resultList;
    }

    public IPropertiesHandler getPropertiesHandler(IContext context, String resourceType, ArrayList propList) throws BaseFaultType {
        SchemaPropertiesHandler sph = new SchemaPropertiesHandler();
        if (null == context) {
            return sph;
        }
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        Class<PropertiesHandler> propHandlerClas = PropertiesHandler.class;
        try {
            ArrayList resList = this.getALLiResourceProperties(resourceType, propList, tLocale);
            ArrayList handlers = this.getHandlersList(resList);
            for (String aHandler : handlers) {
                PropertiesHandler aH = (PropertiesHandler)ReflectionUtils.newInstance(aHandler, propHandlerClas);
                ArrayList filteredList = this.filterPropsByHandler(resList, aHandler);
                aH.setPropertyList(filteredList);
                sph.addHandler(aH);
            }
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("getPropertiesHandler", e);
            throw new BaseFaultType(e);
        }
        return sph;
    }

    public IPropertiesHandler getSinglePropertyHandler(IContext context, String resourceType, String propName) throws BaseFaultType {
        SchemaPropertiesHandler sph = new SchemaPropertiesHandler();
        if (null == context) {
            return sph;
        }
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        Class<PropertiesHandler> propHandlerClas = PropertiesHandler.class;
        try {
            IResourceProperty retProp = (IResourceProperty)this.getSingleProperty(resourceType, propName, tLocale);
            if (retProp == null) {
                CogAdminLogger.getInstance().error("Invalid property '" + propName + "' for resource type '" + resourceType + "'");
                Object[] args = new String[]{propName};
                throw new InvalidResourcePropertyQNameFaultType(args);
            }
            PropertiesHandler aH = (PropertiesHandler)ReflectionUtils.newInstance(retProp.getHandlerName(), propHandlerClas);
            ArrayList<IResourceProperty> retList = new ArrayList<IResourceProperty>(1);
            retList.add(retProp);
            aH.setPropertyList(retList);
            sph.addHandler(aH);
        }
        catch (Exception e) {
            throw new BaseFaultType(e);
        }
        return sph;
    }

    public IResourceProperty getSingleProperty(IContext context, String resourceType, String propName) throws BaseFaultType {
        IPropertiesHandler handler = this.getSinglePropertyHandler(context, resourceType, propName);
        ArrayList propList = handler.getPropertyList();
        if (propList != null && propList.size() > 0) {
            return (IResourceProperty)propList.get(0);
        }
        return null;
    }

    protected ArrayList getHandlersList(IContext context, String resourceType) {
        return this.getHandlersList(MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE")), resourceType);
    }

    private ArrayList getHandlersList(Locale tl, String resourceType) {
        Element propList = this.m_MetadataRetriverInstance.getAllMetadataPropertiesRO(resourceType, tl);
        List handlerList = propList.selectNodes(sbXPathHandlersExpr);
        ArrayList<String> retObj = new ArrayList<String>(handlerList.size());
        Iterator iter = handlerList.iterator();
        while (iter.hasNext()) {
            String handler = ((Element)iter.next()).getText();
            if (retObj.contains(handler)) continue;
            retObj.add(handler);
        }
        return retObj;
    }

    private ArrayList getHandlersList(ArrayList propList) {
        ArrayList<String> retObj = new ArrayList<String>(propList.size());
        Iterator iter = propList.iterator();
        while (iter.hasNext()) {
            String handlerName = ((IResourceAttribute)iter.next()).getHandlerName();
            if (retObj.contains(handlerName)) continue;
            retObj.add(handlerName);
        }
        return retObj;
    }

    public IActionsHandler getActionsHandler(IContext context, String resourceType, ArrayList actionList, String sCapability) throws BaseFaultType {
        GenericActionsHandler handler = new GenericActionsHandler();
        if (null == context) {
            return handler;
        }
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        Class<ActionsHandler> actionsHandlerClas = ActionsHandler.class;
        try {
            ArrayList resList = this.getALLiActionsProperties(resourceType, actionList, sCapability, tLocale);
            ArrayList handlers = this.getHandlersList(resList);
            for (String aHandler : handlers) {
                ActionsHandler aH = (ActionsHandler)ReflectionUtils.newInstance(aHandler, actionsHandlerClas);
                ArrayList filteredList = this.filterPropsByHandler(resList, aHandler);
                aH.setActionList(filteredList);
                handler.addHandler(aH);
            }
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("getActionsHandler", e);
            throw new BaseFaultType(e);
        }
        return handler;
    }

    private ArrayList cloneIResourceAttributeArray(ArrayList sourceArray) {
        if (sourceArray != null) {
            ArrayList<Object> destArray = new ArrayList<Object>(sourceArray.size());
            Iterator iter = sourceArray.iterator();
            while (iter.hasNext()) {
                destArray.add(((IResourceAttribute)iter.next()).clone());
            }
            return destArray;
        }
        return null;
    }

    public static void clearCache() {
        for (String application : propertyRetrievers.keySet()) {
            ResourcePropertiesRetriever.getInstance((String)application).resourceCache.clear();
        }
    }

    static {
        mMuwsTypes.put(MUWS_DEFAULT_TYPE, MBeanType.class);
        mMuwsTypes.put(MUWS_UNSIGNEDLONG_TYPE, UnsignedLongMBeanType.class);
        mMuwsTypes.put(MUWS_DURATION_TYPE, DurationMBeanType.class);
        mMuwsTypes.put(MUWS_STRING_TYPE, StringMBeanType.class);
        mMuwsTypes.put(MUWS_ENUMERATION_TYPE, EnumerationMBeanType.class);
        mMuwsTypes.put(MUWS_DATETIME_TYPE, DateTimeMBeanType.class);
        sbXPathExpPrefix = new StringBuffer("/*[local-name()='").append(AdminConfigProperties.COG_METADATADESC.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_METADATADESC.getNamespaceURI()).append("']/*[local-name()='").append(AdminConfigProperties.COG_ACTION.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_ACTION.getNamespaceURI()).append("' and ./*[local-name()='").append(AdminConfigProperties.COG_CAPABILITY.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_CAPABILITY.getNamespaceURI()).append("' and starts-with(.,'");
        sbXPathExprSuffix = new StringBuffer("')]]");
        sbXPathHandlersExpr = new StringBuffer("/*[local-name()='").append(AdminConfigProperties.COG_METADATADESC.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_METADATADESC.getNamespaceURI()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTY.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_PROPERTY.getNamespaceURI()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTY_HANDLER.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_PROPERTY_HANDLER.getNamespaceURI()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTY_HANDLER_NAME.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_PROPERTY_HANDLER_NAME.getNamespaceURI()).append("']").toString();
        sbxPathPropertyType = new StringBuffer("/*[local-name()='").append(AdminConfigProperties.COG_METADATADESC.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_METADATADESC.getNamespaceURI()).append("']/*[local-name()='").append(AdminConfigProperties.COG_PROPERTY.getLocalPart()).append("' and namespace-uri()='").append(AdminConfigProperties.COG_PROPERTY.getNamespaceURI()).append("']").toString();
    }
}

