/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common.cache.block;

import com.cognos.admin.common.cache.AdminCache;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.cps.cache.CacheEncryptor;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.cache.block.BlockHandle;
import com.cognos.cps.cache.block.BlockManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BlockCache
extends AdminCache {
    Map cacheMap = Collections.synchronizedMap(new HashMap());
    BlockManager blockManager;
    String m_cacheName;
    private CacheEncryptor cacheEncryptor;

    public BlockCache(BlockManager bm, CacheEncryptor cacheEncryptor, String cacheName) {
        this.blockManager = bm;
        this.cacheEncryptor = cacheEncryptor;
        this.m_cacheName = cacheName;
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ArrayList<BlockCacheElement> freeList = new ArrayList<BlockCacheElement>();
        Map map = this.cacheMap;
        synchronized (map) {
            for (Object key : this.keySet()) {
                BlockCacheElement element = (BlockCacheElement)this.cacheMap.remove(key);
                freeList.add(element);
            }
        }
        for (BlockCacheElement element : freeList) {
            try {
                if (element.blockHandle == null) continue;
                this.blockManager.free(element.blockHandle);
            }
            catch (IOException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("clear", e);
                }
                CogAdminLogger.getInstance().error("clear", e);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cacheMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public Collection values() {
        return super.values();
    }

    @Override
    public void putAll(Map t) {
        if (t instanceof BlockCache) {
            this.cacheMap.putAll(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set entrySet() {
        HashSet<BlockCacheEntry> entrySet = new HashSet<BlockCacheEntry>();
        Map map = this.cacheMap;
        synchronized (map) {
            for (Object key : this.cacheMap.keySet()) {
                if (key == null) continue;
                entrySet.add(new BlockCacheEntry(key));
            }
        }
        return entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set keySet() {
        HashSet copy;
        Map map = this.cacheMap;
        synchronized (map) {
            copy = new HashSet(this.cacheMap.keySet());
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        BlockCacheElement element;
        Map map = this.cacheMap;
        synchronized (map) {
            element = (BlockCacheElement)this.cacheMap.get(key);
            if (element != null) {
                element.touch();
                if (element.cachedObject != null) {
                    return element.cachedObject;
                }
            }
        }
        if (element != null && element.blockHandle != null) {
            byte[] bytes = new byte[element.size];
            try {
                Serializable cachedObject;
                this.blockManager.read(element.blockHandle, bytes);
                byte[] clearBytes = this.cacheEncryptor.decrypt(bytes);
                ByteArrayInputStream instr = new ByteArrayInputStream(clearBytes);
                ObjectInputStream objstr = new ObjectInputStream(instr);
                element.cachedObject = cachedObject = (Serializable)objstr.readObject();
                return cachedObject;
            }
            catch (IOException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("BlockCache.getfailed", e);
                }
                throw new CacheException("BlockCache.getfailed", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("clear", e);
                }
                throw new CacheException("BlockCache.getfailed", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Serializable remove(Object key) {
        BlockCacheElement element = (BlockCacheElement)this.cacheMap.remove(key);
        if (element != null) {
            byte[] bytes = new byte[element.size];
            try {
                Serializable obj = element.cachedObject;
                if (obj == null) {
                    this.blockManager.read(element.blockHandle, bytes);
                    byte[] clearBytes = this.cacheEncryptor.decrypt(bytes);
                    ByteArrayInputStream instr = new ByteArrayInputStream(clearBytes);
                    ObjectInputStream objstr = new ObjectInputStream(instr);
                    obj = (Serializable)objstr.readObject();
                }
                if (element.blockHandle != null) {
                    this.blockManager.free(element.blockHandle);
                }
                return obj;
            }
            catch (IOException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("BlockCache.removefailed", e);
                }
                throw new CacheException("BlockCache.removefailed", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("BlockCache.removefailed", e);
                }
                throw new CacheException("BlockCache.removefailed", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Object put(String key, Serializable value) {
        BlockCacheElement element = (BlockCacheElement)this.cacheMap.get(key);
        if (element == null) {
            element = new BlockCacheElement();
            this.cacheMap.put(key, element);
        } else {
            element.touch();
            if (element.blockHandle != null) {
                try {
                    this.blockManager.free(element.blockHandle);
                    element.blockHandle = null;
                }
                catch (IOException e) {
                    if (CogAdminLogger.getInstance().isErrorEnabled()) {
                        CogAdminLogger.getInstance().error("BlockCache.putfailed", e);
                    }
                    throw new CacheException("BlockCache.putfailed", (Throwable)e);
                }
            }
        }
        element.cachedObject = value;
        return value;
    }

    private void cacheObjectToDisk(BlockCacheElement element, String key) {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        try {
            if (element.blockHandle != null) {
                this.blockManager.free(element.blockHandle);
            }
            ObjectOutputStream objstr = new ObjectOutputStream(outstr);
            objstr.writeObject(element.cachedObject);
            objstr.close();
            byte[] bytes = outstr.toByteArray();
            byte[] cipherBytes = this.cacheEncryptor.encrypt(bytes);
            element.size = cipherBytes.length;
            element.blockHandle = this.blockManager.write(cipherBytes);
            element.cachedObject = null;
        }
        catch (IOException e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("BlockCache.cacheObjectToDiskfailed", e);
            }
            throw new CacheException("BlockCache.cacheObjectToDiskfailed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireOldContent(int expiresAfter, int maxIdle) {
        long now = System.currentTimeMillis();
        Map map = this.cacheMap;
        synchronized (map) {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                BlockCacheElement element = (BlockCacheElement)this.cacheMap.get(key);
                if (element.cachedObject == null || now < element.creationTime() + (long)expiresAfter && now < element.lastAccessTime() + (long)maxIdle) continue;
                this.cacheObjectToDisk(element, key);
            }
        }
    }

    protected class BlockCacheEntry
    implements Map.Entry<Object, Serializable> {
        private Object key;

        BlockCacheEntry(Object key) {
            this.key = key;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Serializable getValue() {
            return (Serializable)BlockCache.this.get(this.key);
        }

        @Override
        public Serializable setValue(Serializable value) {
            return BlockCache.this.put(this.key, value);
        }
    }

    protected class BlockCacheElement
    extends AdminCache.CacheElement {
        int size;
        BlockHandle blockHandle;
        Serializable cachedObject;

        protected BlockCacheElement() {
        }
    }
}

