/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.common.logging;

import com.cognos.admin.common.logging.Version;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.logging.LogAuditAccessMessage;
import com.cognos.logging.LogAuditMessage;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CogAdminLogger {
    protected LogTypedLogger m_traceLogger = LogTypedLogger.getInstance((String)"Trace.COGADMIN", LogTraceIndication.class);
    protected LogTypedLogger m_auditLogger = LogTypedLogger.getInstance((String)"Audit.COGADMIN", LogAuditIndication.class);
    protected LogTypedLogger m_perfLogger = LogTypedLogger.getInstance((String)"Perf.COGADMIN", LogPerfIndication.class);
    protected static final String COMPONENT = "COGADMIN";
    protected static final int BUILDNUM = Version.getMajorVersion();
    private static final String TRACE_HEADER = "<trace>";
    private static final String TRACE_FOOTER = "</trace>";
    public static final int LEVEL1 = 0;
    public static final int LEVEL2 = 1;
    public static final int LEVEL3 = 2;
    public static final int LEVEL4 = 3;
    public static final int LEVEL5 = 4;
    public static final int LEVEL_DEBUG = 3;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARN = 1;
    public static final int LEVEL_ERROR = 0;
    public static final int OP_AUDIT_REQUEST = 0;
    public static final int OP_AUDIT_RESPONSE = 1;
    public static final int OP_AUDIT_STARTSERVICE = 2;
    public static final int OP_AUDIT_STOPSERVICE = 3;
    public static final int OP_AUDIT_QUERY = 4;
    public static final int OP_AUDIT_UPDATE = 5;
    public static final int OP_AUDIT_EDIT = 6;
    public static final int OP_AUDIT_EXECUTE = 7;
    public static final int OP_AUDIT_EDITPARAMETERS = 8;
    public static final int OP_AUDIT_PING = 9;
    public static final int OP_AUDIT_GETMETADATA = 10;
    public static final int OP_AUDIT_VALIDATE = 11;
    public static final int OP_AUDIT_GETPARAMETER = 12;
    private static final CogAdminLogger INSTANCE = new CogAdminLogger();

    public static CogAdminLogger getInstance() {
        return INSTANCE;
    }

    private CogAdminLogger() {
    }

    public void error(String message) {
        this.log("ERROR: " + message, 50000);
    }

    public void error(String message, Throwable cause) {
        StringWriter tmp = new StringWriter();
        PrintWriter pwrt = new PrintWriter(tmp);
        if (cause != null) {
            cause.printStackTrace(pwrt);
        }
        this.log("ERROR: " + message + "\nStacktrace: " + tmp.toString(), 50000);
    }

    public void warn(String message) {
        this.log("WARN: " + message, 40000);
    }

    public void info(String message) {
        this.log("INFO: " + message, 30000);
    }

    public void debug(String message) {
        this.log("DEBUG: " + message, 20000);
    }

    public void enter(String method) {
        this.log("ENTER: " + method, 20000);
    }

    public void enter(String method, Object[] objects) {
        this.log("ENTER: " + method + "(" + objects.toString() + ")", 20000);
    }

    public void exit(String method) {
        this.log("EXIT: " + method, 20000);
    }

    public void exit(String method, Object[] objects) {
        this.log("EXIT: " + method + " returning " + objects.toString(), 20000);
    }

    public boolean isErrorEnabled() {
        return this.m_traceLogger != null && this.m_traceLogger.isEnabled(50000);
    }

    public boolean isWarnEnabled() {
        return this.m_traceLogger != null && this.m_traceLogger.isEnabled(40000);
    }

    public boolean isInfoEnabled() {
        return this.m_traceLogger != null && this.m_traceLogger.isEnabled(30000);
    }

    public boolean isDebugEnabled() {
        return this.m_traceLogger != null && this.m_traceLogger.isEnabled(20000);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void log(String tracemsg, int level) {
        if (this.m_traceLogger == null) {
            return;
        }
        LogTraceIndication indication = new LogTraceIndication(COMPONENT, BUILDNUM);
        String sDetails = COMPONENT;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            String sClassName = element.getClassName();
            if (sClassName.indexOf(this.getClass().getName()) != -1) continue;
            sDetails = sClassName + "." + element.getMethodName() + "() : line " + element.getLineNumber();
            break;
        }
        indication.setObject(sDetails);
        indication.setAction((byte)11);
        indication.setLevel(level);
        indication.setMessage(TRACE_HEADER + tracemsg + TRACE_FOOTER);
        this.m_traceLogger.log((Object)indication);
    }

    public void logTrace(String message, int level, boolean localize) {
        this.log(localize ? MessagesManagerFacade.getInstance().getMessage(MessagesManagerFacade.getServerLocale(), message) : message, this.getIPFLevel(level));
    }

    public boolean isAuditLevelEnabled(int level) {
        return this.m_auditLogger != null && this.m_auditLogger.isEnabled(this.getIPFLevel(level));
    }

    public void logAudit(int level, int operation, String message) {
        if (this.m_auditLogger == null) {
            return;
        }
        int ipfLevel = this.getIPFLevel(level);
        Object indication = ipfLevel == 20000 || ipfLevel == 10000 ? new LogAuditMessage(COMPONENT, BUILDNUM) : new LogAuditAccessMessage(COMPONENT, BUILDNUM);
        indication.setLevel(ipfLevel);
        indication.setOperation(this.getIPFOperation(operation));
        indication.setLogData(message);
        this.m_auditLogger.log(indication);
    }

    public void logAudit(int level, int operation, String message, boolean localize) {
        this.logAudit(level, operation, localize ? MessagesManagerFacade.getInstance().getMessage(MessagesManagerFacade.getServerLocale(), message) : message);
    }

    public boolean isPerfLevelEnabled(int level) {
        return this.m_perfLogger != null && this.m_perfLogger.isEnabled(this.getIPFLevel(level));
    }

    public Object startTimer(int level, String classname, String method, String description) {
        if (this.m_perfLogger == null) {
            return null;
        }
        CCLResourceCounterSet counter = new CCLResourceCounterSet("Execution", null);
        LogPerfIndication indication = new LogPerfIndication(COMPONENT, BUILDNUM, counter);
        indication.setLevel(this.getIPFLevel(level));
        indication.setClassId(classname);
        indication.setMethodId(method);
        indication.setLogData(description);
        indication.setStatus("START");
        indication.setTime(System.currentTimeMillis());
        this.m_perfLogger.log((Object)indication);
        counter.enableResourceCounter();
        return indication;
    }

    public void stopTimer(Object timer) {
        if (this.m_perfLogger != null && timer != null && timer instanceof LogPerfIndication) {
            LogPerfIndication indication = (LogPerfIndication)timer;
            indication.getCCLRCS().disableResourceCounter();
            indication.setStatus("FINISH");
            indication.setTime(System.currentTimeMillis());
            this.m_perfLogger.log((Object)indication);
        }
    }

    private int getIPFLevel(int level) {
        switch (level) {
            case 0: {
                return 50000;
            }
            case 1: {
                return 40000;
            }
            case 2: {
                return 30000;
            }
            case 3: {
                return 20000;
            }
            case 4: {
                return 10000;
            }
        }
        return 10000;
    }

    private String getIPFOperation(int operation) {
        switch (operation) {
            case 0: {
                return "Request";
            }
            case 1: {
                return "Response";
            }
            case 2: {
                return "StartService";
            }
            case 3: {
                return "StopService";
            }
            case 4: {
                return "Query";
            }
            case 5: {
                return "Update";
            }
            case 6: {
                return "Edit";
            }
            case 7: {
                return "Execute";
            }
            case 8: {
                return "EditParameters";
            }
            case 9: {
                return "Ping";
            }
            case 10: {
                return "GetMetadata";
            }
            case 11: {
                return "Validate";
            }
            case 12: {
                return "GetParameter";
            }
        }
        return "Request";
    }
}

