/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.datastores.CMCubeConfigurationHandler;
import com.cognos.admin.resource.datastores.ConfiguredCube;
import com.cognos.admin.resource.datastores.ConfiguredCubeSet;
import com.cognos.admin.resource.datastores.actions.ContextCache;
import com.cognos.admin.service.CogAdminService;
import com.cognos.admin.service.Dispatcher;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.impl.bus.BusCommand;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.ibm.cognos.cogadmin.common.SearchPathUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CubeConfigurationQuery {
    private boolean useCache = true;
    private Query query = new Query();
    private CMCubeConfigurationHandler cmCubeConfigurationHandler = new CMCubeConfigurationHandler();
    public static Class<? extends CubeConfigurationQuery> factoryClass = CubeConfigurationQuery.class;

    public static CubeConfigurationQuery getInstance() {
        try {
            return factoryClass.newInstance();
        }
        catch (Exception e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error(CubeConfigurationQuery.class.getName() + ":getInstance()", e);
            }
            return null;
        }
    }

    protected CubeConfigurationQuery() {
        this.query.addProperty("qsROLAPCubeConfigurations");
        this.query.setResponseBodyHandler((IXMLHandler)this.cmCubeConfigurationHandler);
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public ConfiguredCubeSet getQueryServiceConfiguredCubes(IContext context, String qsStoreId, boolean localize) throws Exception {
        String searchPath = "storeID('" + qsStoreId + "')";
        return this.getConfiguredCubes(context, searchPath, localize);
    }

    public Collection<ConfiguredCube> getDispatcherConfiguredCubes(IContext context, String dispStoreId, boolean localize) throws Exception {
        String searchPath = "storeID('" + dispStoreId + "')/queryService";
        return this.getConfiguredCubes(context, searchPath, localize);
    }

    public Collection<ConfiguredCube> getDispatcherConfiguredCubesForSearchPath(IContext context, String searchPath, boolean localize) throws Exception {
        if (!searchPath.endsWith("/queryService")) {
            searchPath = searchPath + "/queryService";
        }
        return this.getConfiguredCubes(context, searchPath, localize);
    }

    public Collection<ConfiguredCube> getSystemConfiguredCubes(IContext context, boolean localize) throws Exception {
        ConfiguredCubeSet systemConfiguredCubes = new ConfiguredCubeSet();
        for (String serverGroup : CogAdminService.getServerGroups()) {
            systemConfiguredCubes.addAll(this.getServerGroupConfiguredCubes(context, serverGroup, localize));
        }
        return systemConfiguredCubes;
    }

    public Collection<ConfiguredCube> getServerGroupConfiguredCubes(IContext context, String svrGroupName, boolean localize) throws Exception {
        ConfiguredCubeSet sgConfiguredCubes = new ConfiguredCubeSet();
        if (svrGroupName != null) {
            for (Dispatcher disp : CogAdminService.getServerGroupDispatchers(svrGroupName)) {
                Collection<ConfiguredCube> dispConfiguredCubes = this.getDispatcherConfiguredCubesForSearchPath(context, disp.getSearchPath(), localize);
                sgConfiguredCubes.addAll(dispConfiguredCubes);
            }
        }
        return sgConfiguredCubes;
    }

    private ConfiguredCubeSet getConfiguredCubes(IContext context, String searchPath, boolean localize) throws Exception {
        ConfiguredCubeSet configuredCubes = (ConfiguredCubeSet)ContextCache.getProperty(context, searchPath + localize);
        if (configuredCubes == null || !this.useCache) {
            this.query.setSearchPath(searchPath);
            this.makeCMRequest(context, this.query);
            configuredCubes = this.cmCubeConfigurationHandler.getConfiguredCubes();
            if (localize) {
                this.localizeConfiguredCubes(context, configuredCubes);
            }
            ContextCache.setProperty(context, searchPath + localize, configuredCubes);
        }
        return configuredCubes;
    }

    protected void makeCMRequest(IContext context, Query query) throws Exception {
        CMRequestHelper.makeCMRequest(context, (BusCommand)query, false);
    }

    public static final ConfiguredCube getConfiguredCube(Collection<ConfiguredCube> configuredCubes, Object targetCube) {
        if (configuredCubes != null) {
            for (ConfiguredCube cube : configuredCubes) {
                if (!cube.equals(targetCube)) continue;
                return cube;
            }
        }
        return null;
    }

    public void localizeConfiguredCubes(IContext context, Collection<ConfiguredCube> configuredCubes) throws Exception {
        Query localizeQuery = null;
        String dataSourceSearchPath = new StringBuffer("CAMID(\":\")/*[@objectClass='").append("rolapDataSource").append("' or @objectClass='").append("rolapVirtualDataSource").append("']").append("[@shown='true']").toString();
        for (ConfiguredCube configuredCube : configuredCubes) {
            if (localizeQuery == null) {
                localizeQuery = new Query();
            } else {
                localizeQuery.addNewQuery();
            }
            localizeQuery.setSearchPath(dataSourceSearchPath + SearchPathUtils.buildNameCritera(configuredCube.getConfiguredName()));
            localizeQuery.addProperty("defaultName");
            localizeQuery.addProperty("name");
            localizeQuery.addProperty("storeID");
            localizeQuery.addProperty("tenantID");
        }
        if (localizeQuery != null) {
            List<GenericCMObject> localizedDataSources = CMRequestHelper.makeCMRequest(context, localizeQuery, false, false);
            block1: for (ConfiguredCube configuredCube : configuredCubes) {
                for (GenericCMObject cmObject : localizedDataSources) {
                    Map contentLocaleNames = cmObject.getMapParameter("name");
                    if (!contentLocaleNames.containsValue(configuredCube.getConfiguredName())) continue;
                    configuredCube.setDisplayName(cmObject.getParameter("name", null));
                    configuredCube.setStoreID(cmObject.getParameter("storeID", null));
                    configuredCube.setTenantID(cmObject.getParameter("tenantID", null));
                    configuredCube.setNames(cmObject.getMapParameter("name"));
                    configuredCubes.add(configuredCube);
                    continue block1;
                }
            }
        }
    }
}

