/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores;

import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.datastores.ConfiguredCube;
import com.cognos.admin.resource.datastores.CubeConfigurationQuery;
import com.cognos.admin.resource.datastores.actions.AddCubeConfigurationCommand;
import com.cognos.admin.resource.datastores.actions.ConsolidatedRolapConditionalMBeanCubeActionsHandler;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.cogadmin.v1_0.ArgumentType;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceAction;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceActionResponse;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import com.cognos.pogo.bibus.CommandExecutionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;

public class DatasourceDispatcherResource
extends CMResource {
    @Override
    public ExecuteResourceActionResponse executeResourceAction(ExecuteResourceAction sAction, IContext context) throws BaseFaultType {
        if (sAction.getName().equals("SetCubeProperties")) {
            HashMap<String, String> configValues = new HashMap<String, String>();
            String cubeName = null;
            for (int i = 0; i < sAction.getArgumentCount(); ++i) {
                Object nameTokens;
                if (sAction.getArgument(i).getName().equals("selected_cube")) {
                    cubeName = sAction.getArgument(i).getContent();
                }
                if (!(nameTokens = sAction.getArgument(i).getName().split("_", 2))[0].equals("rlp") || ((Object)nameTokens).length <= 1) continue;
                configValues.put((String)nameTokens[1], sAction.getArgument(i).getContent());
            }
            if (cubeName != null) {
                IResourceID qsResId = ResourceIdFactory.getResourceID(context.getProperty("resourceID").toString());
                try {
                    for (ConfiguredCube cube : CubeConfigurationQuery.getInstance().getQueryServiceConfiguredCubes(context, qsResId.getId(), true)) {
                        if (cubeName != null && !cube.equals(cubeName)) continue;
                        AddCubeConfigurationCommand configCommand = new AddCubeConfigurationCommand(context, null, qsResId, cube.getConfiguredName(), cube.isVirtual(), configValues);
                        try {
                            configCommand.execute();
                        }
                        catch (CommandExecutionException e) {
                            if (!CogAdminLogger.getInstance().isErrorEnabled()) continue;
                            CogAdminLogger.getInstance().error("DatasourceDispatcherResource: Cube configuration failed for cube:" + cube.getConfiguredName() + " on queryService Id:" + qsResId, e);
                        }
                    }
                }
                catch (Exception e1) {
                    if (CogAdminLogger.getInstance().isErrorEnabled()) {
                        CogAdminLogger.getInstance().error("DatasourceDispatcherResource: An error occurred establishing list of cube for queryService Id:" + qsResId);
                    }
                    throw new BaseFaultType(e1);
                }
            }
            ExecuteResourceActionResponse response = new ExecuteResourceActionResponse();
            return response;
        }
        String sName = sAction.getName().trim();
        ArrayList<String> al = new ArrayList<String>(1);
        al.add(sName);
        Enumeration e = sAction.enumerateArgument();
        while (e.hasMoreElements()) {
            ArgumentType arg = (ArgumentType)e.nextElement();
            context.setProperty(arg.getName(), (Object)arg.getContent());
        }
        try {
            return this.executeCubeAction(context, sAction, al);
        }
        catch (BaseFaultType e1) {
            throw e1;
        }
        catch (Exception e1) {
            throw new BaseFaultType(e1);
        }
    }

    protected ExecuteResourceActionResponse executeCubeAction(IContext context, ExecuteResourceAction sAction, ArrayList<String> al) throws Exception {
        String storeId = this.getResourceID().getId();
        String cubeName = this.getResourceID().getReferringResourceID().getId();
        return ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeAction(context, storeId, cubeName, sAction, false);
    }
}

