/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.castor.CogadminCastorFieldHandler;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.datastores.CubeConfigurationQuery;
import com.cognos.admin.resource.datastores.RolapCubeConsolidatedOperationalStatusHandler;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsdm.muws2.v1_1.OperationalStatusType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipParticipantType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DatasourceResource
extends CMResource {
    public static final String RESOURCE_TYPE_DATASOURCE_SERVERGROUP = "serverGroup_dataSource";

    @Override
    protected String buildRelationshipRequest(String requestedType, IContext context) throws BaseFaultType {
        try {
            String sSearchPath = "";
            if (!requestedType.equalsIgnoreCase("containedBy")) {
                if (CogAdminLogger.getInstance().isWarnEnabled()) {
                    CogAdminLogger.getInstance().warn("buildCMRequest(" + requestedType + ") Unsupported Type.");
                }
                throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
            }
            sSearchPath = "/configuration//dispatcher[@shown='true']";
            Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
            ArrayList cmProps = ResourcePropertiesRetriever.getInstance(context).getiResourceCMProperties("dispatcher", Constants.QRBT_RESPONSE_PROP_LIST, tLocale);
            PropertyType dispPath = new PropertyType("dispatcherPath", "cm");
            dispPath.setCMObjectName("dispatcherPath");
            cmProps.add(dispPath);
            PropertyType svrGroup = new PropertyType("serverGroup", "cm");
            svrGroup.setCMObjectName("serverGroup");
            cmProps.add(svrGroup);
            if (sSearchPath.length() > 0) {
                String req = CMRequestHelper.buildCMQueryRequest(sSearchPath, (List)cmProps);
                return req;
            }
            if (CogAdminLogger.getInstance().isWarnEnabled()) {
                CogAdminLogger.getInstance().warn("buildCMRequest(" + requestedType + ") Unsupported Type.");
            }
            throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
        }
        catch (Exception e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("buildCMRequest(" + requestedType + ")", e);
            }
            throw new BaseFaultType("error.exception", e);
        }
    }

    @Override
    protected void addQRBTParticipant(RelationshipType relationship, String sType, List<GenericCMObject> cmObjects, ArrayList<String> listOfProperties, IContext context) throws BaseFaultType {
        ArrayList<Object> listOfParticipant = new ArrayList(cmObjects.size());
        HashMap<String, GenericCMObject> serverGroups = new HashMap<String, GenericCMObject>();
        IPropertiesHandler healthHandler = null;
        ArrayList sysQRBTProps = null;
        sysQRBTProps = (ArrayList)Constants.QRBT_RESPONSE_PROP_LIST.clone();
        this.setContext(context);
        sysQRBTProps.addAll(listOfProperties);
        IPropertiesHandler dataSourceHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, this.getResourceType(), sysQRBTProps);
        dataSourceHandler.doIt(context);
        RelationshipParticipantType rootDatasourceParticipant = this.generateQRBTPaticipant(dataSourceHandler, healthHandler, context, true);
        relationship.addParticipant(rootDatasourceParticipant);
        for (int i = 0; i < cmObjects.size(); ++i) {
            GenericCMObject cmObj = cmObjects.get(i);
            String storeID = cmObj.getParameter("storeID", "");
            IResourceID resId = ResourceIdFactory.getResourceID(cmObj.getType(), storeID, context);
            if (storeID == null || storeID.length() == 0) {
                CogAdminLogger.getInstance().warn("addQRBTParticipant: Invalid Object");
                continue;
            }
            String dispPath = "";
            if (resId.getBaseType().equals("dispatcher")) {
                dispPath = cmObj.getParameter("dispatcherPath", "");
            }
            CMResource cmRes = (CMResource)ResourceLookupManager.getInstance().find(resId);
            cmRes.setDispatcherPath(dispPath);
            String svrGroupName = cmObj.getParameter("serverGroup", "");
            if (svrGroupName == null || svrGroupName.length() == 0) {
                svrGroupName = "DefaultServerGroup";
            }
            try {
                CubeConfigurationQuery query = CubeConfigurationQuery.getInstance();
                IResourceID resId2 = (IResourceID)context.getProperty("resourceID");
                if (!query.getServerGroupConfiguredCubes(context, svrGroupName, true).contains(resId2.getReferringResourceID().getId())) continue;
                this.addServerGroup(serverGroups, svrGroupName, cmObj);
                continue;
            }
            catch (Exception e) {
                throw new BaseFaultType(e);
            }
        }
        this.resetContext(context);
        IResourceID parentResId = (IResourceID)context.getProperty("resourceID");
        listOfParticipant = this.buildQRBTContainerParticipants(serverGroups, "serverGroup_" + parentResId.getBaseType(), listOfProperties, context);
        BitSet consolidatedStatusBitSet = new BitSet(3);
        for (int i = 0; i < listOfParticipant.size(); ++i) {
            RelationshipParticipantType p = (RelationshipParticipantType)listOfParticipant.get(i);
            relationship.addParticipant(p);
            Object operationalStatus = CogadminCastorFieldHandler.getCogadminCastorType(p, "OperationalStatus").getValue();
            consolidatedStatusBitSet.set(OperationalStatusType.valueOf(operationalStatus.toString()).getType());
        }
        OperationalStatusType statusType = RolapCubeConsolidatedOperationalStatusHandler.getCubeStatus(consolidatedStatusBitSet);
        CogadminCastorFieldHandler.getCogadminCastorType(rootDatasourceParticipant, "OperationalStatus").setValue(statusType);
    }

    private ArrayList<RelationshipParticipantType> buildQRBTContainerParticipants(HashMap<String, GenericCMObject> containerMap, String resourceType, ArrayList<String> listOfProperties, IContext context) throws BaseFaultType {
        if (containerMap.isEmpty()) {
            return new ArrayList<RelationshipParticipantType>();
        }
        ArrayList<String> props = new ArrayList<String>();
        props.addAll(listOfProperties);
        props.addAll(Constants.QRBT_RESPONSE_PROP_LIST);
        ArrayList<RelationshipParticipantType> listOfparticipants = new ArrayList<RelationshipParticipantType>();
        for (Map.Entry<String, GenericCMObject> pair : containerMap.entrySet()) {
            String defaultName;
            String storeID = pair.getKey();
            GenericCMObject participantCMObj = pair.getValue();
            String string = defaultName = resourceType != null ? storeID : participantCMObj.getParameter("defaultName", "");
            if (defaultName == null || defaultName.length() == 0) {
                defaultName = "DefaultServerGroup";
            }
            IResourceID resourceId = ResourceIdFactory.getResourceID(resourceType != null ? resourceType : participantCMObj.getType(), storeID, this.getResourceID().getReferringResourceID(), context);
            Resource serverGroupChildRes = (Resource)ResourceLookupManager.getInstance().find(resourceId);
            if (storeID != null && storeID.equals("DefaultServerGroup")) {
                Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
                storeID = MessagesManagerFacade.getInstance().getMessage(tLocale, "ui.defaultservergroup");
            }
            GenericCMObject cmObj = new GenericCMObject(resourceId.getType());
            cmObj.setParameter("defaultName", defaultName);
            context.setProperty("cmObject", (Object)cmObj);
            context.setProperty("resourceMbeanPattern", (Object)serverGroupChildRes.getMBeanNamePattern(context));
            IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, serverGroupChildRes.getResourceType(), props);
            context.setProperty("resourceID", (Object)resourceId);
            context.setProperty("IResource", (Object)serverGroupChildRes);
            handler.doIt(context);
            RelationshipParticipantType p = serverGroupChildRes.generateQRBTPaticipant(handler, null, context);
            listOfparticipants.add(p);
            this.resetContext(context);
        }
        return listOfparticipants;
    }

    private void addServerGroup(HashMap<String, GenericCMObject> containerMap, String storeID, GenericCMObject cmObj) {
        if (containerMap.get(storeID) == null) {
            containerMap.put(storeID, cmObj);
        }
    }
}

