/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores;

import com.cognos.cps.services.IContext;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class DatasourceServerGroupQuery {
    private List<String> serverGroups = new ArrayList<String>();

    public DatasourceServerGroupQuery(IContext context) throws Exception {
        List<CMClass> dispatchers = this.execute(context);
        for (CMClass dispatcher : dispatchers) {
            String dispServerGroup = "DefaultServerGroup";
            Node nDispServerGroup = dispatcher.getPropertyAsElement("serverGroup").selectSingleNode("value");
            if (nDispServerGroup != null) {
                dispServerGroup = nDispServerGroup.getText();
            }
            this.serverGroups.add(dispServerGroup);
        }
    }

    protected List<CMClass> execute(IContext context) throws Exception {
        ContentManagerQueryCommand dispQueryCmd = new ContentManagerQueryCommand("//queryService/parent::dispatcher");
        dispQueryCmd.setBIBusHeader(this.getBusHeader(context.getProperty("BUS_HEADER").toString()));
        dispQueryCmd.addQueryPropertyName("serverGroup");
        dispQueryCmd.addQueryPropertyName("storeID");
        dispQueryCmd.execute();
        List dispatchers = dispQueryCmd.getResultList();
        return dispatchers;
    }

    public List<String> getServerGroups() {
        return this.serverGroups;
    }

    protected Element getBusHeader(String busHeader) throws DocumentException {
        return DocumentHelper.parseText((String)busHeader).getRootElement();
    }
}

