/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.castor.CogadminCastorFieldHandler;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.datastores.CacheableQuery;
import com.cognos.admin.resource.datastores.ConfiguredCube;
import com.cognos.admin.resource.datastores.CubeConfigurationQuery;
import com.cognos.admin.resource.datastores.RolapCubeConsolidatedOperationalStatusHandler;
import com.cognos.admin.resource.datastores.actions.ConsolidatedRolapConditionalMBeanCubeActionsHandler;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.CMResourceID;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.ServerContainerResource;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.service.CogAdminService;
import com.cognos.admin.service.Dispatcher;
import com.cognos.admin.ws.cogadmin.v1_0.Details;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceAction;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceActionResponse;
import com.cognos.admin.ws.wsdm.muws2.v1_1.OperationalStatusType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipParticipantType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DatasourceServerGroupResource
extends ServerContainerResource {
    protected transient Collection<ConfiguredCube> configuredCubes = null;

    @Override
    protected String buildRelationshipRequest(String requestedType, IContext context) throws BaseFaultType {
        try {
            String sSearchPath = "";
            if (requestedType.equalsIgnoreCase("containedBy")) {
                IResourceID resourceId = (IResourceID)context.getProperty("resourceID");
                String serverGroup = resourceId.getId();
                for (Dispatcher disp : CogAdminService.getServerGroupDispatchers(serverGroup)) {
                    String dispSearchPath = disp.getSearchPath();
                    if (sSearchPath.length() > 0) {
                        sSearchPath = sSearchPath + "|";
                    }
                    dispSearchPath = dispSearchPath + "/queryService";
                    sSearchPath = sSearchPath + dispSearchPath;
                }
            } else {
                if (CogAdminLogger.getInstance().isWarnEnabled()) {
                    CogAdminLogger.getInstance().warn("buildCMRequest(" + requestedType + ") Unsupported Type.");
                }
                throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
            }
            Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
            ArrayList cmProps = ResourcePropertiesRetriever.getInstance(context).getiResourceCMProperties("queryService", Constants.QRBT_RESPONSE_PROP_LIST, tLocale);
            PropertyType storeIdProp = new PropertyType("storeID", "cm");
            storeIdProp.setCMObjectName("storeID");
            cmProps.add(storeIdProp);
            PropertyType defaultNameProp = new PropertyType("defaultName", "cm");
            defaultNameProp.setCMObjectName("defaultName");
            cmProps.add(defaultNameProp);
            if (sSearchPath.length() > 0) {
                String req = CMRequestHelper.buildCMQueryRequest(sSearchPath, (List)cmProps);
                return req;
            }
            if (CogAdminLogger.getInstance().isWarnEnabled()) {
                CogAdminLogger.getInstance().warn("buildCMRequest(" + requestedType + ") Unsupported Type.");
            }
            throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
        }
        catch (Exception e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("buildCMRequest(" + requestedType + ")", e);
            }
            throw new BaseFaultType("error.exception", e);
        }
    }

    @Override
    protected void addQRBTParticipant(RelationshipType relationship, String sType, List cmObjects, ArrayList listOfProperties, IContext context) throws BaseFaultType {
        CubeConfigurationQuery cubeConfigurationQuery = CubeConfigurationQuery.getInstance();
        IResourceID serverGroupResourceId = (IResourceID)context.getProperty("resourceID");
        try {
            this.configuredCubes = cubeConfigurationQuery.getServerGroupConfiguredCubes(context, serverGroupResourceId.getId(), false);
        }
        catch (Exception e1) {
            throw new BaseFaultType(e1);
        }
        ArrayList<Object> listOfParticipant = new ArrayList(cmObjects.size());
        HashMap<String, GenericCMObject> serverGroups = new HashMap<String, GenericCMObject>();
        IPropertiesHandler healthHandler = null;
        ArrayList sysQRBTProps = null;
        sysQRBTProps = (ArrayList)Constants.QRBT_RESPONSE_PROP_LIST.clone();
        this.setContext(context);
        sysQRBTProps.addAll(listOfProperties);
        IPropertiesHandler dataSourceHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, this.getResourceType(), sysQRBTProps);
        dataSourceHandler.doIt(context);
        RelationshipParticipantType rootParticipant = this.generateQRBTPaticipant(dataSourceHandler, healthHandler, context, true);
        relationship.addParticipant(rootParticipant);
        for (int i = 0; i < cmObjects.size(); ++i) {
            GenericCMObject cmObj = (GenericCMObject)cmObjects.get(i);
            String storeID = cmObj.getParameter("storeID", "");
            IResourceID resId = ResourceIdFactory.getResourceID(cmObj.getType(), storeID, context);
            if (storeID == null || storeID.length() == 0) {
                CogAdminLogger.getInstance().warn("addQRBTParticipant: Invalid Object");
                continue;
            }
            String dispPath = "";
            if (resId.getBaseType().equals("dispatcher")) {
                dispPath = cmObj.getParameter("dispatcherPath", "");
            }
            CMResource cmRes = (CMResource)ResourceLookupManager.getInstance().find(resId);
            cmRes.setDispatcherPath(dispPath);
            String svrGroupName = cmObj.getParameter("serverGroup", "");
            if (svrGroupName == null || svrGroupName.length() == 0) {
                svrGroupName = "DefaultServerGroup";
            }
            try {
                CubeConfigurationQuery query = CubeConfigurationQuery.getInstance();
                IResourceID rootServerGroupResourceId = (IResourceID)context.getProperty("resourceID");
                if (rootServerGroupResourceId.getReferringResourceID() != null) {
                    if (!query.getQueryServiceConfiguredCubes(context, storeID, true).contains(rootServerGroupResourceId.getReferringResourceID().getId())) continue;
                    this.addDispatcher(serverGroups, storeID, cmObj);
                    continue;
                }
                if (query.getQueryServiceConfiguredCubes(context, storeID, false).size() <= 0) continue;
                this.addDispatcher(serverGroups, storeID, cmObj);
                continue;
            }
            catch (Exception e) {
                throw new BaseFaultType(e);
            }
        }
        this.resetContext(context);
        listOfParticipant = this.buildQRBTContainerParticipants(serverGroups, this.getChildParticipantType(), listOfProperties, context);
        BitSet consolidatedStatusBitSet = new BitSet(3);
        for (int i = 0; i < listOfParticipant.size(); ++i) {
            RelationshipParticipantType p = (RelationshipParticipantType)listOfParticipant.get(i);
            relationship.addParticipant(p);
            Object operationalStatus = CogadminCastorFieldHandler.getCogadminCastorType(p, "OperationalStatus").getValue();
            consolidatedStatusBitSet.set(OperationalStatusType.valueOf(operationalStatus.toString()).getType());
        }
        OperationalStatusType statusType = RolapCubeConsolidatedOperationalStatusHandler.getCubeStatus(consolidatedStatusBitSet);
        CogadminCastorFieldHandler.getCogadminCastorType(rootParticipant, "OperationalStatus").setValue(statusType);
    }

    protected String getChildParticipantType() {
        return "queryService_" + this.getResourceID().getType().split("_")[1];
    }

    private ArrayList<RelationshipParticipantType> buildQRBTContainerParticipants(HashMap<String, GenericCMObject> containerMap, String resourceType, ArrayList<String> listOfProperties, IContext context) throws BaseFaultType {
        if (containerMap.isEmpty()) {
            return new ArrayList<RelationshipParticipantType>();
        }
        ArrayList<String> props = new ArrayList<String>();
        props.addAll(listOfProperties);
        props.addAll(Constants.QRBT_RESPONSE_PROP_LIST);
        ArrayList<RelationshipParticipantType> listOfparticipants = new ArrayList<RelationshipParticipantType>();
        for (Map.Entry<String, GenericCMObject> pair : containerMap.entrySet()) {
            String storeID = pair.getKey();
            GenericCMObject participantCMObj = pair.getValue();
            String defaultName = participantCMObj.getParameter("defaultName", "");
            IResourceID resourceId = ResourceIdFactory.getResourceID(resourceType != null ? resourceType : participantCMObj.getType(), storeID, this.getResourceID().getReferringResourceID(), context);
            Resource childRes = (Resource)ResourceLookupManager.getInstance().find(resourceId);
            context.setProperty("cmObject", (Object)participantCMObj);
            context.setProperty("resourceMbeanPattern", (Object)childRes.getMBeanNamePattern(context));
            IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, childRes.getResourceType(), props);
            context.setProperty("resourceID", (Object)resourceId);
            context.setProperty("IResource", (Object)childRes);
            handler.doIt(context);
            RelationshipParticipantType p = childRes.generateQRBTPaticipant(handler, null, context);
            listOfparticipants.add(p);
            this.resetContext(context);
        }
        return listOfparticipants;
    }

    private void addDispatcher(HashMap<String, GenericCMObject> containerMap, String storeID, GenericCMObject cmObj) {
        if (containerMap.get(storeID) == null) {
            containerMap.put(storeID, cmObj);
        }
    }

    @Override
    protected CMResourceID getParticipantResourceId(String type, String storeId, IContext context) throws BaseFaultType {
        CMResourceID resourceID = (CMResourceID)ResourceIdFactory.getResourceID(type + "_" + "dataSource", storeId, context);
        resourceID.setReferringResourceID(this.getResourceID().getReferringResourceID());
        String cubeName = this.getResourceID().getReferringResourceID().getId();
        return CubeConfigurationQuery.getConfiguredCube(this.configuredCubes, cubeName) != null ? resourceID : null;
    }

    @Override
    public ExecuteResourceActionResponse executeResourceAction(ExecuteResourceAction sAction, IContext context) throws BaseFaultType {
        if (sAction.getName().equals("RemoveDataStoreFromServerGroup")) {
            return super.executeResourceAction(sAction, context);
        }
        String sName = sAction.getName().trim();
        ArrayList<String> al = new ArrayList<String>(1);
        al.add(sName);
        ExecuteResourceActionResponse response = new ExecuteResourceActionResponse();
        response.setName(sName);
        Details details = new Details();
        response.setDetails(details);
        try {
            String serverGroupName = this.getResourceID().getId();
            ArrayList<String> qsStoreIds = new ArrayList<String>();
            CacheableQuery qsQuery = new CacheableQuery();
            qsQuery.setSearchPath("/configuration//queryService");
            qsQuery.addProperty("storeID");
            qsQuery.addProperty("parent");
            qsQuery.addRefPropProperty("parent", "serverGroup");
            List<GenericCMObject> responseList = qsQuery.execute(context);
            for (GenericCMObject obj : responseList) {
                GenericCMObject dispObj = obj.getChildObject("parent");
                String serverGroup = dispObj.getParameter("serverGroup", "DefaultServerGroup");
                if (serverGroup.length() == 0) {
                    serverGroup = "DefaultServerGroup";
                }
                if (!serverGroup.equals(serverGroupName)) continue;
                qsStoreIds.add(obj.getParameter("storeID", null));
            }
            for (String qsStoreId : qsStoreIds) {
                this.executeCubeAction(context, qsStoreId, sAction, al);
            }
        }
        catch (Exception e1) {
            throw new BaseFaultType(e1);
        }
        return response;
    }

    protected void executeCubeAction(IContext context, String qsStoreId, ExecuteResourceAction sAction, ArrayList<String> al) throws Exception {
        ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeAction(context, qsStoreId, this.getResourceID().getReferringResourceID().getId(), sAction, false);
    }
}

