/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.castor.CogadminCastorType;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.datastores.ConfiguredCube;
import com.cognos.admin.resource.datastores.CubeConfigurationQuery;
import com.cognos.admin.resource.datastores.actions.ConsolidatedRolapConditionalMBeanCubeActionsHandler;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.CMResourceID;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.SystemResource;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceAction;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipParticipantType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class DatasourceSystemResource
extends SystemResource {
    private transient Collection<ConfiguredCube> systemConfiguredCubes = null;

    @Override
    protected String buildRelationshipRequest(String requestedType, IContext context) throws BaseFaultType {
        try {
            StringBuffer sSearchPath = new StringBuffer();
            ArrayList cmProps = new ArrayList();
            StringBuffer sDispSearchPath = new StringBuffer();
            ArrayList dispProps = new ArrayList();
            Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
            if (requestedType.equalsIgnoreCase("servergroups")) {
                sSearchPath.append("/configuration//dispatcher[@shown='true']");
                cmProps = ResourcePropertiesRetriever.getInstance(context).getiResourceCMProperties("dispatcher", Constants.QRBT_RESPONSE_PROP_LIST, tLocale);
                PropertyType dispPath = new PropertyType("dispatcherPath", "cm");
                dispPath.setCMObjectName("dispatcherPath");
                cmProps.add(dispPath);
                PropertyType svrGroup = new PropertyType("serverGroup", "cm");
                svrGroup.setCMObjectName("serverGroup");
                cmProps.add(svrGroup);
            } else if ("datasources".equals(requestedType)) {
                sSearchPath.append("CAMID(\":\")/*[@objectClass='rolapDataSource' or @objectClass='rolapVirtualDataSource']");
                cmProps = this.getCMProps(context, requestedType, tLocale);
            } else if ("datasources_base".equals(requestedType)) {
                sSearchPath.append("CAMID(\":\")/*[@objectClass='rolapDataSource']");
                requestedType = "datasources";
                cmProps = this.getCMProps(context, requestedType, tLocale);
            } else if ("datasources_virtual".equals(requestedType)) {
                sSearchPath.append("CAMID(\":\")/*[@objectClass='rolapVirtualDataSource']");
                requestedType = "datasources";
                cmProps = this.getCMProps(context, requestedType, tLocale);
            } else {
                CogAdminLogger.getInstance().warn("buildCMRequest: Unsupported Type");
                throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
            }
            String sysSearchPath = "/configuration[@shown='true']";
            PropertyType sysStoreId = new PropertyType("storeID", "cm");
            sysStoreId.setCMObjectName("storeID");
            PropertyType sysObjectClass = new PropertyType("objectClass", "cm");
            sysObjectClass.setCMObjectName("objectClass");
            ArrayList<PropertyType> sysProps = new ArrayList<PropertyType>();
            sysProps.add(sysStoreId);
            sysProps.add(sysObjectClass);
            if (sSearchPath.length() > 0 && cmProps.size() > 0) {
                StringBuffer req = CMRequestHelper.startCMQueryRequest();
                CMRequestHelper.appendQueryRequest(req, sysSearchPath, sysProps);
                if (sDispSearchPath.length() > 0 && dispProps.size() > 0) {
                    CMRequestHelper.appendQueryRequest(req, sDispSearchPath.append("[permission('read') and @shown='true']").toString(), dispProps);
                }
                CMRequestHelper.appendQueryRequest(req, sSearchPath.append("[permission('read') and @shown='true']").toString(), cmProps);
                CMRequestHelper.endCMQueryRequest(req);
                return req.toString();
            }
            CogAdminLogger.getInstance().warn("buildCMRequest: Unsupported Type");
            throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("buildCMRequest", e);
            throw new BaseFaultType("error.exception", e);
        }
    }

    @Override
    protected ArrayList getCMProps(IContext context, String relationshipType, Locale locale) {
        if ("datasources".equals(relationshipType)) {
            return ResourcePropertiesRetriever.getInstance(context).getiResourceCMProperties("dataSource", Constants.QRBT_RESPONSE_PROP_LIST, locale);
        }
        return null;
    }

    @Override
    protected void addQRBTParticipant(RelationshipType relationship, String relationshipType, List<GenericCMObject> cmObjects, ArrayList<String> listOfProperties, IContext context) throws BaseFaultType {
        CubeConfigurationQuery query = CubeConfigurationQuery.getInstance();
        try {
            this.systemConfiguredCubes = query.getSystemConfiguredCubes(context, true);
        }
        catch (Exception e) {
            throw new BaseFaultType(e);
        }
        super.addQRBTParticipant(relationship, relationshipType, cmObjects, listOfProperties, context);
    }

    @Override
    protected void addServerContainer(IContext context, HashMap containerMap, String storeID, GenericCMObject cmObj) throws BaseFaultType {
        if (containerMap.get(storeID) == null) {
            CubeConfigurationQuery query = CubeConfigurationQuery.getInstance();
            try {
                Collection<ConfiguredCube> serverGroupConfiguredCubes = query.getServerGroupConfiguredCubes(context, storeID, false);
                if (serverGroupConfiguredCubes.size() > 0) {
                    containerMap.put(storeID, cmObj);
                }
            }
            catch (Exception e) {
                throw new BaseFaultType(e);
            }
        }
    }

    @Override
    protected void addQRBTChildParticipant(IContext context, String relationshipType, ArrayList listOfProperties, ArrayList listOfParticipant, IPropertiesHandler healthHandler, GenericCMObject cmObj, CMResource cmRes) throws BaseFaultType {
        if (relationshipType.startsWith("datasources")) {
            IResourceID currentResourceId = (IResourceID)context.getProperty("resourceID");
            context.setProperty("cmObject", (Object)cmObj);
            context.setProperty("resourceMbeanPattern", (Object)cmRes.getMBeanNamePattern(context));
            context.setProperty("resourceID", (Object)cmRes.getResourceID());
            ArrayList<String> props = new ArrayList<String>();
            props.addAll(listOfProperties);
            props.addAll(Constants.QRBT_RESPONSE_PROP_WITHOUT_HEALTH_LIST);
            props.add("OperationalStatus");
            IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, cmRes.getResourceType(), props);
            handler.doIt(context);
            this.resetContext(context);
            RelationshipParticipantType p = cmRes.generateQRBTPaticipant(handler, healthHandler, context);
            listOfParticipant.add(p);
            if (this.systemConfiguredCubes != null) {
                boolean hasChildren = false;
                CogadminCastorType hasChildrenType = null;
                for (Object castorType : p.getAnyObject()) {
                    CogadminCastorType type = (CogadminCastorType)castorType;
                    if ("HasChildren".equals(type.getName())) {
                        hasChildrenType = type;
                    }
                    if (!"Caption".equals(type.getName())) continue;
                    String cubeType = p.getRole().equals("rolapVirtualDataSource") ? "rolapVirtualCube" : "rolapCube";
                    CMResourceID resourceId = (CMResourceID)ResourceIdFactory.getResourceID(p.getResourceId());
                    ConfiguredCube targetCube = CubeConfigurationQuery.getConfiguredCube(this.systemConfiguredCubes, type.getValue());
                    if (targetCube != null) {
                        resourceId.setReferringResourceID(ResourceIdFactory.getResourceID("cm", cubeType, targetCube.getConfiguredName(), null));
                        hasChildren = true;
                    } else {
                        resourceId.setReferringResourceID(ResourceIdFactory.getResourceID("cm", cubeType, type.getValue().toString(), null));
                    }
                    p.setResourceId(resourceId.toString());
                }
                if (hasChildrenType != null) {
                    hasChildrenType.setValue(hasChildren);
                }
            }
            context.setProperty("resourceID", (Object)currentResourceId);
        }
    }

    protected void executeCubeAction(IContext context, String qsStoreId, ExecuteResourceAction sAction, ArrayList<String> al) throws Exception {
        ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeAction(context, qsStoreId, this.getResourceID().getReferringResourceID().getId(), sAction, false);
    }
}

