/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores;

import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.resource.datastores.ConfiguredCube;
import com.cognos.admin.resource.datastores.CubeConfigurationQuery;
import com.cognos.admin.resource.datastores.DatasourceServerGroupResource;
import com.cognos.admin.resource.datastores.actions.ConsolidatedRolapConditionalMBeanCubeActionsHandler;
import com.cognos.admin.resource.v1_0.CMResourceID;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceAction;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.admin.xts.XTSDetailsInstructionException;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;

public class DatasourcesServerGroupResource
extends DatasourceServerGroupResource {
    public static final String RESOURCE_TYPE_DATASOURCES_SERVERGROUP = "serverGroup_rolapDataSource";

    @Override
    protected CMResourceID getParticipantResourceId(String type, String storeId, IContext context) throws BaseFaultType {
        if (this.configuredCubes.size() > 0) {
            CMResourceID resourceID = (CMResourceID)ResourceIdFactory.getResourceID(type, storeId, context);
            resourceID.setReferringResourceID(this.getResourceID().getReferringResourceID());
            return resourceID;
        }
        return null;
    }

    @Override
    protected void executeCubeAction(IContext context, String qsStoreId, ExecuteResourceAction sAction, ArrayList<String> userConfirmedImpactedCubes) throws Exception {
        CubeConfigurationQuery query = CubeConfigurationQuery.getInstance();
        for (ConfiguredCube configuredCube : query.getServerGroupConfiguredCubes(context, this.getResourceID().getId(), false)) {
            try {
                ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeAction(context, qsStoreId, configuredCube.getConfiguredName(), sAction, true);
            }
            catch (BaseFaultType e) {
                if (e.getRootCause() instanceof XTSDetailsInstructionException) {
                    ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeActionsOnConfirmedCubesInDetailsException(context, (XTSDetailsInstructionException)((Object)e.getRootCause()), userConfirmedImpactedCubes, qsStoreId, sAction, true);
                    continue;
                }
                throw e;
            }
        }
    }

    @Override
    protected String getChildParticipantType() {
        return "queryService";
    }
}

