/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores;

import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.PropertiesHandler;
import com.cognos.admin.resource.v1_0.PropertiesHandlerPropertyType;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.ws.cogadmin.v1_0.ActionContext;
import com.cognos.admin.ws.cogadmin.v1_0.ActionContexts;
import com.cognos.admin.ws.cogadmin.v1_0.CaptionType;
import com.cognos.admin.ws.cogadmin.v1_0.RelationshipType;
import com.cognos.admin.ws.cogadmin.v1_0.SupportedRelationships;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Locale;

@PropertiesHandlerPropertyType(clazz=PropertyType.class)
public class DatastoresSupportedRelationshipsPropertiesHandler
extends PropertiesHandler {
    private static final String ACTION_CONTEXT_SYSTEM = "system";
    private static final String ACTION_CONTEXT_SYSTEM_GROUPACTION = "system_g";
    private static final String ACTION_CONTEXT_SYSTEM_GROUPACTION_VIRTUAL = "system_g_v";
    private static final String ACTION_CONTEXT_SYSTEM_GROUPACTION_SYSTEM_CENTRIC = "system_g_sg";

    public DatastoresSupportedRelationshipsPropertiesHandler(ArrayList propertyList) {
        super(propertyList);
    }

    public DatastoresSupportedRelationshipsPropertiesHandler() {
    }

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        if (this.m_propertyList == null || this.m_propertyList.size() == 0) {
            return;
        }
        PropertyType property = (PropertyType)this.m_propertyList.get(0);
        property.setComplexValue(true);
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        SupportedRelationships sr = new SupportedRelationships();
        sr.addRelationship(this.createRelationship("servergroups", ACTION_CONTEXT_SYSTEM_GROUPACTION_SYSTEM_CENTRIC, false, tLocale));
        RelationshipType rDataSources = this.createRelationship("datastores", ACTION_CONTEXT_SYSTEM_GROUPACTION_SYSTEM_CENTRIC, false, tLocale);
        rDataSources.setContainer(true);
        rDataSources.addRelationship(this.createRelationship("datasources", ACTION_CONTEXT_SYSTEM_GROUPACTION, true, tLocale));
        rDataSources.addRelationship(this.createRelationship("datasources_base", ACTION_CONTEXT_SYSTEM_GROUPACTION, false, tLocale));
        rDataSources.addRelationship(this.createRelationship("datasources_virtual", ACTION_CONTEXT_SYSTEM_GROUPACTION_VIRTUAL, false, tLocale));
        sr.addRelationship(rDataSources);
        property.setValue(sr);
    }

    protected RelationshipType createRelationship(String name, String groupActionContext, boolean isDefault, Locale tLocale) {
        RelationshipType relationship = new RelationshipType();
        relationship.setName(name);
        relationship.setDefault(isDefault);
        CaptionType caption = new CaptionType();
        caption.setLang(tLocale.toString());
        caption.setContent(MessagesManagerFacade.getInstance().getMessage(tLocale, "relationship." + name + ".caption"));
        relationship.addCaption(caption);
        this.setActionContexts(relationship, ACTION_CONTEXT_SYSTEM, groupActionContext);
        return relationship;
    }

    private void setActionContexts(RelationshipType rt, String actionContextId, String groupActionContextId) {
        ActionContexts actionContexts = new ActionContexts();
        ActionContext actionContext = new ActionContext();
        actionContext.setId(actionContextId);
        actionContext.setType("Action");
        actionContexts.addContext(actionContext);
        ActionContext groupActionContext = new ActionContext();
        groupActionContext.setId(groupActionContextId);
        groupActionContext.setType("GroupAction");
        actionContexts.addContext(groupActionContext);
        rt.setActionContexts(actionContexts);
    }
}

