/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores;

import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.castor.CogadminCastorFieldHandler;
import com.cognos.admin.resource.datastores.CacheableQuery;
import com.cognos.admin.resource.datastores.ConfiguredCube;
import com.cognos.admin.resource.datastores.ConfiguredCubeSet;
import com.cognos.admin.resource.datastores.CubeConfigurationQuery;
import com.cognos.admin.resource.datastores.actions.ContextCache;
import com.cognos.admin.resource.v1_0.CMResourceID;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.RolapCubeOperationalStatusHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.wsdm.muws2.v1_1.OperationalStatusType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.QueryRelationshipsByType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.QueryRelationshipsByTypeResponse;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.helpers.ContextImpl;
import java.util.BitSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;

public class RolapCubeConsolidatedOperationalStatusHandler
extends RolapCubeOperationalStatusHandler {
    /*
     * Unable to fully structure code
     */
    @Override
    public void doIt(IContext rootContext) throws BaseFaultType {
        context = this.copyContext(rootContext);
        resourceId = (IResourceID)context.getProperty("resourceID");
        property = (IResourceProperty)this.m_propertyList.get(0);
        searchPath = "/configuration//queryService";
        if ("system".equals(resourceId.getType())) {
            property.setValue(this.getChildCubeStatus((IContext)context, resourceId, searchPath));
        } else if ("rolapDataSource".equals(resourceId.getType()) || "rolapVirtualDataSource".equals(resourceId.getType())) {
            try {
                cube = this.queryConfiguredCube(context, resourceId);
                if (cube == null) ** GOTO lbl34
                type = cube.isVirtual() != false ? "rolapVirtualCube" : "rolapCube";
                ((CMResourceID)resourceId).setReferringResourceID(ResourceIdFactory.getResourceID("cm", type, cube.getConfiguredName(), null));
                property.setValue(this.getChildCubeStatus((IContext)context, resourceId, searchPath));
            }
            catch (Exception e) {
                throw new BaseFaultType(e);
            }
        } else if ("serverGroup".equals(resourceId.getType())) {
            property.setValue(this.getChildCubeStatus((IContext)context, resourceId, searchPath));
        } else if ("serverGroup".equals(resourceId.getBaseType())) {
            property.setValue(this.getChildCubeStatus((IContext)context, resourceId, searchPath));
        } else if ("dispatcher".equals(resourceId.getType())) {
            property.setValue(this.getChildCubeStatus((IContext)context, resourceId, searchPath));
        } else if ("queryService".equals(resourceId.getType())) {
            property.setValue(this.getChildCubeStatus((IContext)context, resourceId, searchPath));
        } else if ("queryService".equals(resourceId.getBaseType())) {
            property.setValue(this.getChildCubeStatus((IContext)context, resourceId, searchPath));
        } else {
            throw new BaseFaultType("RolapCubeConsolidatedOperationalStatusHandler. Unsupported resourceType: " + resourceId.getType());
        }
lbl34:
        // 8 sources

        ContextCache.copy((IContext)context, rootContext);
    }

    protected ConfiguredCube queryConfiguredCube(ContextImpl context, IResourceID resourceId) throws Exception {
        Collection<ConfiguredCube> configuredCubes = (Collection<ConfiguredCube>)ContextCache.getProperty((IContext)context, "systemConfiguredCubes");
        if (configuredCubes == null) {
            configuredCubes = CubeConfigurationQuery.getInstance().getSystemConfiguredCubes((IContext)context, true);
            ContextCache.setProperty((IContext)context, "systemConfiguredCubes", configuredCubes);
        }
        ConfiguredCube cube = CubeConfigurationQuery.getConfiguredCube(configuredCubes, resourceId.getId());
        return cube;
    }

    private ContextImpl copyContext(IContext rootContext) {
        ContextImpl context = new ContextImpl();
        for (Object propName : rootContext.getPropertyNames()) {
            context.setProperty(propName.toString(), rootContext.getProperty(propName.toString()));
        }
        return context;
    }

    protected String getChildCubeStatus(IContext context, IResourceID resourceId, String queryServiceSearchPath) throws BaseFaultType {
        String cubeName = null;
        if (resourceId.getReferringResourceID() != null) {
            cubeName = resourceId.getReferringResourceID().getId();
        }
        List<GenericCMObject> qsList = this.queryCMForQueryServices(context, queryServiceSearchPath);
        BitSet statusBitSet = new BitSet(OperationalStatusType.UNKNOWN.getType());
        for (GenericCMObject qsObject : qsList) {
            String qsStoreId = qsObject.getParameter("storeID", null);
            String dispServerGroup = qsObject.getChildObject("parent").getParameter("serverGroup", "DefaultServerGroup");
            if ("".equals(dispServerGroup)) {
                dispServerGroup = "DefaultServerGroup";
            }
            if (resourceId.getBaseType().equals("queryService") ? !resourceId.getId().equals(qsStoreId) : resourceId.getBaseType().equals("serverGroup") && !resourceId.getId().equals(dispServerGroup)) continue;
            ConfiguredCubeSet configuredCubes = this.queryCMForQSConfiguredCubes(context, qsStoreId);
            if (cubeName != null && !configuredCubes.contains(cubeName)) continue;
            IResourceID qsResourceId = ResourceIdFactory.getResourceID("cm", "queryService", qsStoreId, null);
            context.setProperty("resourceID", (Object)qsResourceId);
            Resource qsResource = (Resource)ResourceLookupManager.getInstance().find(qsResourceId);
            QueryRelationshipsByTypeResponse qrbtResponse = this.getQRBTResponseForQSConfiguredCubes(context, qsResourceId, qsResource);
            if (qrbtResponse.getRelationship(0).getParticipantCount() == 1) {
                try {
                    if (!this.queryServiceHasConfiguredCubes(context, qsResourceId)) continue;
                    statusBitSet.set(OperationalStatusType.UNKNOWN.getType());
                    continue;
                }
                catch (Exception e) {
                    throw new BaseFaultType(e);
                }
            }
            for (int i = 1; i < qrbtResponse.getRelationship(0).getParticipantCount(); ++i) {
                String cubeResourceId = qrbtResponse.getRelationship(0).getParticipant(i).getResourceId();
                String childCubeName = ResourceIdFactory.getResourceID(cubeResourceId).getId();
                if (cubeName != null && !childCubeName.equals(cubeName)) continue;
                String status = CogadminCastorFieldHandler.getCogadminCastorType(qrbtResponse.getRelationship(0).getParticipant(i), "OperationalStatus").getValue().toString();
                statusBitSet.set(OperationalStatusType.valueOf(status).getType());
            }
        }
        return RolapCubeConsolidatedOperationalStatusHandler.getCubeStatus(statusBitSet).toString();
    }

    protected QueryRelationshipsByTypeResponse getQRBTResponseForQSConfiguredCubes(IContext context, IResourceID qsResourceId, Resource qsResource) throws BaseFaultType {
        QueryRelationshipsByTypeResponse qrbtResponse = (QueryRelationshipsByTypeResponse)ContextCache.getProperty(context, qsResourceId.toString());
        if (qrbtResponse == null) {
            QueryRelationshipsByType qrbt = new QueryRelationshipsByType();
            qrbt.setRequestedType("containedBy");
            qrbtResponse = qsResource.queryRelationshipsByType(qrbt, context);
            ContextCache.setProperty(context, qsResourceId.toString(), qrbtResponse);
        }
        return qrbtResponse;
    }

    protected ConfiguredCubeSet queryCMForQSConfiguredCubes(IContext context, String qsStoreId) throws BaseFaultType {
        CubeConfigurationQuery qsQuery = CubeConfigurationQuery.getInstance();
        try {
            return qsQuery.getQueryServiceConfiguredCubes(context, qsStoreId, false);
        }
        catch (Exception e1) {
            throw new BaseFaultType(e1);
        }
    }

    protected boolean queryServiceHasConfiguredCubes(IContext context, IResourceID qsResourceId) throws Exception {
        CubeConfigurationQuery query = CubeConfigurationQuery.getInstance();
        return query.getQueryServiceConfiguredCubes(context, qsResourceId.getId(), false).size() > 0;
    }

    protected List<GenericCMObject> queryCMForQueryServices(IContext context, String queryServiceSearchPath) throws BaseFaultType {
        List<GenericCMObject> qsList = (List<GenericCMObject>)ContextCache.getProperty(context, queryServiceSearchPath);
        if (qsList == null) {
            CacheableQuery query = new CacheableQuery();
            query.setSearchPath(queryServiceSearchPath);
            query.addProperty("storeID");
            query.addProperty("parent");
            query.addRefPropProperty("parent", "serverGroup");
            query.addRefPropProperty("parent", "storeID");
            try {
                qsList = query.execute(context);
            }
            catch (Exception e) {
                throw new BaseFaultType(e);
            }
        }
        return qsList;
    }

    public static OperationalStatusType getCubeStatus(BitSet statusBitSet) {
        int best = 3;
        if (statusBitSet.cardinality() == 1) {
            best = statusBitSet.nextSetBit(0);
        } else if (statusBitSet.cardinality() > 1) {
            best = statusBitSet.get(0) || statusBitSet.get(1) ? 1 : statusBitSet.nextSetBit(0);
        }
        Enumeration enumn = OperationalStatusType.enumerate();
        while (enumn.hasMoreElements()) {
            OperationalStatusType opType = (OperationalStatusType)enumn.nextElement();
            if (opType.getType() != best) continue;
            return opType;
        }
        return OperationalStatusType.UNKNOWN;
    }
}

