/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores.actions;

import com.cognos.admin.common.InstalledComponents;
import com.cognos.admin.resource.datastores.CacheableQuery;
import com.cognos.admin.resource.datastores.actions.CubeConfigurationCommand;
import com.cognos.admin.resource.v1_0.ActionsHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.service.CogAdminService;
import com.cognos.admin.service.Dispatcher;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.util.Collection;
import java.util.List;

public abstract class AbstractCubeConfigurationActionsHandler
extends ActionsHandler {
    @Override
    public void doIt(IContext context) throws BaseFaultType {
        String datasourceName = null;
        String serverGroup = null;
        IResourceID resourceId = (IResourceID)context.getProperty("resourceID");
        IResourceID targetResourceId = null;
        IResourceID refResId = resourceId.getReferringResourceID();
        if (refResId != null && "serverGroup".equals(refResId.getBaseType())) {
            List<GenericCMObject> result;
            CacheableQuery query = new CacheableQuery();
            query.setSearchPath("storeID('" + resourceId.getId() + "')");
            query.addProperty("defaultName");
            try {
                result = query.execute(context);
            }
            catch (Exception e) {
                throw new BaseFaultType(e);
            }
            datasourceName = result.get(0).getParameter("defaultName", null);
            serverGroup = refResId.getId();
        } else if ("rolapCube".equals(resourceId.getBaseType()) || "rolapVirtualCube".equals(resourceId.getBaseType())) {
            datasourceName = resourceId.getId();
            serverGroup = resourceId.getReferringResourceID().getReferringResourceID().getId();
        } else if ("rolapDataSource".equals(resourceId.getBaseType()) || "rolapVirtualDataSource".equals(resourceId.getBaseType()) || "serverGroup".equals(resourceId.getBaseType())) {
            if (refResId != null) {
                datasourceName = refResId.getId();
                IResourceID serverGroupResourceId = refResId.getReferringResourceID();
                if (serverGroupResourceId != null) {
                    serverGroup = serverGroupResourceId.getId();
                }
            } else {
                targetResourceId = resourceId;
            }
        } else {
            throw new BaseFaultType(this.getClass().getName() + ":doIt(). Unsupported resource type: " + resourceId.getType());
        }
        this.configureCubeForServerGroup(context, datasourceName, serverGroup, resourceId, targetResourceId);
    }

    protected void configureCubeForServerGroup(IContext context, String datasourceName, String serverGroup, IResourceID resourceId, IResourceID targetResourceId) throws BaseFaultType {
        if (serverGroup != null && !"All".equals(serverGroup)) {
            Collection<Dispatcher> disps = null;
            disps = CogAdminService.getServerGroupDispatchers(serverGroup);
            this.configureCubeForQueryServiceDispatchersInServerGroup(context, disps, datasourceName, resourceId, targetResourceId);
        } else {
            for (String serverGrp : CogAdminService.getServerGroups()) {
                this.configureCubeForQueryServiceDispatchersInServerGroup(context, CogAdminService.getServerGroupDispatchers(serverGrp), datasourceName, resourceId, targetResourceId);
            }
        }
    }

    protected void configureCubeForQueryServiceDispatchersInServerGroup(IContext context, Collection<Dispatcher> disps, String datasourceName, IResourceID resourceId, IResourceID targetResourceId) throws BaseFaultType {
        for (Dispatcher disp : disps) {
            try {
                if (!InstalledComponents.isInstalled("queryService", disp.getName())) continue;
                this.getConfigurationCommand(context, disp.getSearchPath(), targetResourceId, datasourceName, "rolapVirtualDataSource".equals(resourceId.getBaseType())).execute();
            }
            catch (Exception e) {
                throw new BaseFaultType(e);
            }
        }
    }

    protected abstract CubeConfigurationCommand getConfigurationCommand(IContext var1, String var2, IResourceID var3, String var4, boolean var5);
}

