/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores.actions;

import com.cognos.admin.resource.datastores.actions.CubeConfigurationCommand;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.cps.services.IContext;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xts.configuration.IXTSConfiguration;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltResult;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AddCubeConfigurationCommand
extends CubeConfigurationCommand {
    public static final String BASE_CUBE_CONFIGURATION_TYPE = "rolapCubeConfiguration";
    public static final String VIRTUAL_CUBE_CONFIGURATION_TYPE = "rolapVirtualCubeConfiguration";
    private static final String DATASOURCE_NAME_CONFIG_PARM = "dataSourceName";
    private static final String XML_PROLOGUE = "<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>";
    private static Element configurationMetadataCache = null;
    private HashMap<String, String> values = null;

    public AddCubeConfigurationCommand(IContext context, String resourceName, IResourceID resourceId, String datasourceName, boolean isVirtual) {
        super(context, resourceName, resourceId, datasourceName, isVirtual);
    }

    public AddCubeConfigurationCommand(IContext context, String resourceName, IResourceID resourceId, String datasourceName, boolean isVirtual, HashMap<String, String> values) {
        super(context, resourceName, resourceId, datasourceName, isVirtual);
        this.values = values;
    }

    @Override
    protected void executeImpl(Element requestElement) throws CommandExecutionException {
        try {
            super.executeImpl(requestElement);
        }
        catch (Exception e) {
            throw new CommandExecutionException((Throwable)e);
        }
    }

    @Override
    protected Element configureServerGroupConfigurationFolder(Element requestElement) throws Exception {
        Element eValue = super.configureServerGroupConfigurationFolder(requestElement);
        if (eValue != null) {
            this.addItem(eValue, this.datasourceName, this.isVirtual);
        }
        return eValue;
    }

    private void addItem(Element eValue, String cubeName, boolean isVirtual) throws Exception {
        String type = isVirtual ? VIRTUAL_CUBE_CONFIGURATION_TYPE : BASE_CUBE_CONFIGURATION_TYPE;
        Element eItem = eValue.addElement(BUS_ITEM);
        eItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":" + type);
        this.addConfiguration(cubeName, type, eItem);
    }

    private List selectNodes(Element e, String xPath) {
        return e.selectNodes(xPath);
    }

    private void addConfiguration(String cubeName, String type, Element parent) throws Exception {
        if (configurationMetadataCache == null) {
            configurationMetadataCache = this.getDefaultConfigurationViaMetadataTransform();
        }
        List configElements = this.selectNodes(configurationMetadataCache, "//*[local-name()='" + type + "']/*");
        for (Element configElement : configElements) {
            Element clone = configElement.createCopy();
            if (clone.getName().equals(DATASOURCE_NAME_CONFIG_PARM)) {
                clone.setText(cubeName);
            } else if (this.values != null && this.values.containsKey(clone.getName())) {
                clone.setText(this.values.get(clone.getName()));
            }
            parent.add(clone);
        }
    }

    private Element getDefaultConfigurationViaMetadataTransform() throws Exception {
        String configMetadata = this.transform("/transforms/portal/rolapCubeConfigurations/propertiesMetadata.xslt", "<root/>");
        configMetadata = "<root><wholeEntries><rolapCubeConfiguration></rolapCubeConfiguration><rolapVirtualCubeConfiguration></rolapVirtualCubeConfiguration></wholeEntries><paramsMetadata>" + configMetadata + "</paramsMetadata></root>";
        configMetadata = this.transform("/transforms/portal/rolapCubeConfigurations/transformToCMFormatedEntries.xslt", configMetadata);
        return DocumentHelper.parseText((String)("<root>" + configMetadata + "</root>")).getRootElement();
    }

    private String transform(String xsltPath, String inputDoc) throws Exception {
        InputStream fis = this.getCubeConfigurationDefaultsMetadataFile(xsltPath);
        Stylesheet stylesheet = new Stylesheet();
        stylesheet.setup(new XmlSource("", fis, true));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XsltResult result = new XsltResult("", (OutputStream)baos, false);
        ByteArrayInputStream is = new ByteArrayInputStream(inputDoc.getBytes());
        XmlSource xmlSource = new XmlSource("", (InputStream)is, true);
        stylesheet.transform(xmlSource, result);
        return baos.toString().replaceAll(XML_PROLOGUE, "");
    }

    protected InputStream getCubeConfigurationDefaultsMetadataFile(String xsltPath) throws XTSConfigurationException, IOException {
        String templateRoot = PathUtils.normalizeToPath((String)PropertiesManager.getInstance().getProperty("template.root"));
        IXTSConfiguration config = XTSConfigManager.getInstance().getConfiguration();
        String sFile = config.getPhysicalPath(PathUtils.buildPath((String)templateRoot, (String)xsltPath));
        return new FileInputStream(new File(sFile));
    }

    public static void clearCache() {
        configurationMetadataCache = null;
    }
}

