/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores.actions;

import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.datastores.CacheableQuery;
import com.cognos.admin.resource.datastores.CubeConfigurationQuery;
import com.cognos.admin.resource.datastores.actions.ContextCache;
import com.cognos.admin.resource.datastores.actions.XTSPartialInstructionException;
import com.cognos.admin.resource.v1_0.MBeanActionType;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.RolapConditionalMBeanCubeActionsHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceAction;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceActionResponse;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.admin.xts.XTSDetailsInstructionException;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;

public class ConsolidatedRolapConditionalMBeanCubeActionsHandler
extends RolapConditionalMBeanCubeActionsHandler {
    private static final int MAX_RETRY_COUNT = 5;

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        IResourceID currentResourceId = (IResourceID)context.getProperty("resourceID");
        MBeanActionType actionType = (MBeanActionType)this.getActionList().get(0);
        ExecuteResourceAction executeAction = new ExecuteResourceAction();
        executeAction.setName(actionType.getID().toString());
        if ("rolapCube".equals(currentResourceId.getType()) || "rolapVirtualCube".equals(currentResourceId.getType())) {
            try {
                super.doIt(context);
            }
            catch (BaseFaultType e2) {
                int retryCount = 0;
                Object oRetryCount = ContextCache.getProperty(context, "retryCount" + currentResourceId);
                if (oRetryCount != null) {
                    retryCount = Integer.parseInt(oRetryCount.toString());
                }
                boolean force = false;
                String dispStoreId = currentResourceId.getReferringResourceID().getId();
                String cubeName = currentResourceId.getId();
                if (e2.getRootCause() instanceof XTSDetailsInstructionException) {
                    ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeActionOnDependentCubes(context, dispStoreId, cubeName, executeAction, force, retryCount, e2);
                }
                throw e2;
            }
        } else {
            String cubeName = currentResourceId.getReferringResourceID().getId();
            try {
                CubeConfigurationQuery cubeConfigQuery = CubeConfigurationQuery.getInstance();
                CacheableQuery qsQuery = new CacheableQuery();
                qsQuery.setSearchPath("/configuration//queryService");
                qsQuery.addProperty("storeID");
                List<GenericCMObject> responseList = qsQuery.execute(context);
                boolean success = false;
                ArrayList<BaseFaultType> fail = new ArrayList<BaseFaultType>();
                for (GenericCMObject cmQsObj : responseList) {
                    String qsStoreId = cmQsObj.getParameter("storeID", null);
                    if (!cubeConfigQuery.getQueryServiceConfiguredCubes(context, qsStoreId, false).contains(cubeName)) continue;
                    try {
                        ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeAction(context, qsStoreId, cubeName, executeAction, false);
                        success = true;
                    }
                    catch (BaseFaultType e) {
                        if (e.getRootCause() instanceof XTSDetailsInstructionException) {
                            throw e;
                        }
                        fail.add(e);
                    }
                }
                if (success && fail.size() > 0) {
                    throw new XTSPartialInstructionException("Errors occurred executing consolidated action:" + actionType.getOperation() + " on cube:" + cubeName, fail.toArray(new Exception[fail.size()]));
                }
                if (!success && fail.size() == 0) {
                    throw new XTSInstructionException("Unable to execute action:" + actionType.getOperation() + " on cube:" + cubeName + ". The the cube is not configured.");
                }
                context.setProperty("resourceID", (Object)currentResourceId);
            }
            catch (BaseFaultType e) {
                throw e;
            }
            catch (Exception e) {
                throw new BaseFaultType(e);
            }
        }
    }

    public static ExecuteResourceActionResponse executeCubeAction(IContext context, String qsStoreId, String cubeName, ExecuteResourceAction sAction, boolean force) throws BaseFaultType {
        return ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeAction(context, qsStoreId, cubeName, sAction, force, 0);
    }

    private static ExecuteResourceActionResponse executeCubeAction(IContext context, String qsStoreId, String cubeName, ExecuteResourceAction sAction, boolean force, int retryCount) throws BaseFaultType {
        try {
            IResourceID qsResourceID = ResourceIdFactory.getResourceID("cm", "queryService", qsStoreId, null);
            IResourceID cubeResourceID = ResourceIdFactory.getResourceID("cm", "rolapCube", cubeName, qsResourceID);
            context.setProperty("resourceID", (Object)cubeResourceID);
            Resource cubeResource = (Resource)ResourceLookupManager.getInstance().find(cubeResourceID);
            context.setProperty("IResource", (Object)cubeResource);
            ContextCache.setProperty(context, "retryCount" + cubeResourceID, retryCount);
            return cubeResource.executeResourceAction(sAction, context);
        }
        catch (BaseFaultType e2) {
            if (e2.getRootCause() instanceof XTSDetailsInstructionException) {
                return ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeActionOnDependentCubes(context, qsStoreId, cubeName, sAction, force, retryCount, e2);
            }
            throw e2;
        }
    }

    protected static ExecuteResourceActionResponse executeCubeActionOnDependentCubes(IContext context, String qsStoreId, String cubeName, ExecuteResourceAction sAction, boolean force, int retryCount, BaseFaultType e2) throws BaseFaultType {
        ArrayList<String> userConfirmedImpactedCubes = new ArrayList<String>();
        int i = 1;
        String errorDetail = null;
        do {
            if ((errorDetail = (String)context.getProperty(CONTEXT_ERROR_DETAIL_PREFIX + i++)) == null) continue;
            errorDetail = RolapConditionalMBeanCubeActionsHandler.extractCubeNameFromErrorDetail(errorDetail);
            if (CogAdminLogger.getInstance().isDebugEnabled()) {
                CogAdminLogger.getInstance().debug("RolapConditionalMBeanCubeActionsHandler::checkConditions(): adding errorDetail: " + errorDetail);
            }
            userConfirmedImpactedCubes.add(errorDetail);
        } while (errorDetail != null);
        try {
            ContextCache.clear(context);
            ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeActionsOnConfirmedCubesInDetailsException(context, (XTSDetailsInstructionException)((Object)e2.getRootCause()), userConfirmedImpactedCubes, qsStoreId, sAction, force);
        }
        catch (XTSDetailsInstructionException e) {
            throw new BaseFaultType((Throwable)((Object)e));
        }
        if (retryCount++ < 5) {
            return ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeAction(context, qsStoreId, cubeName, sAction, force, retryCount);
        }
        String msg = "executeCubeAction " + sAction.getName() + " on cube:" + cubeName + " qsStoreId:" + qsStoreId + " failed after maximum " + 5 + " unsuccessful attempts.";
        if (CogAdminLogger.getInstance().isWarnEnabled()) {
            CogAdminLogger.getInstance().warn(msg);
        }
        throw new BaseFaultType(msg);
    }

    private static List selectNodes(Element e, String xPath) {
        return e.selectNodes(xPath);
    }

    public static void executeActionsOnConfirmedCubesInDetailsException(IContext context, XTSDetailsInstructionException e, List<String> userConfirmedImpactedCubes, String qsStoreId, ExecuteResourceAction sAction, boolean force) throws XTSDetailsInstructionException, BaseFaultType {
        Element currentFaultElement = e.getFaultXML(new Locale((String)context.getProperty("CONTENT_LOCALE")), false);
        List exceptionDetails = ConsolidatedRolapConditionalMBeanCubeActionsHandler.selectNodes(currentFaultElement, "*//*[local-name()='exceptionDetail']");
        ContextCache.disableCaching(context);
        for (Element myDetail : exceptionDetails) {
            String dependentCubeName = myDetail.getText();
            if (force || userConfirmedImpactedCubes.contains(dependentCubeName)) {
                ConsolidatedRolapConditionalMBeanCubeActionsHandler.executeCubeAction(context, qsStoreId, dependentCubeName, sAction, force);
                continue;
            }
            ContextCache.enableCaching(context);
            throw e;
        }
        ContextCache.enableCaching(context);
    }
}

