/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores.actions;

import com.cognos.cps.services.IContext;

public class ContextCache {
    private static final String CACHEKEY_PREFIX = "CACHE_";
    private static final String CACHE_ENABLED = "CACHE_ENABLED";
    private static final Object CACHE_DELETED = "DELETED";

    public static void disableCaching(IContext context) {
        context.setProperty(CACHE_ENABLED, (Object)false);
    }

    public static void enableCaching(IContext context) {
        context.setProperty(CACHE_ENABLED, (Object)true);
    }

    public static void copy(IContext from, IContext to) {
        for (Object key : from.getPropertyNames()) {
            String name = key.toString();
            if (!name.startsWith(CACHEKEY_PREFIX)) continue;
            to.setProperty(name, from.getProperty(name));
        }
    }

    public static void setProperty(IContext context, String key, Object value) {
        if (context.getProperty(CACHE_ENABLED) != Boolean.FALSE) {
            ContextCache.enableCaching(context);
            context.setProperty(CACHEKEY_PREFIX + key, value);
        }
    }

    public static Object getProperty(IContext context, String key) {
        Object value = context.getProperty(CACHEKEY_PREFIX + key);
        return CACHE_DELETED.equals(value) ? null : value;
    }

    public static void clear(IContext context) {
        for (Object key : context.getPropertyNames()) {
            String sKey = key.toString();
            if (!sKey.startsWith(CACHEKEY_PREFIX)) continue;
            context.setProperty(sKey, CACHE_DELETED);
        }
    }
}

