/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores.actions;

import com.cognos.admin.resource.datastores.ConfiguredCube;
import com.cognos.admin.resource.datastores.CubeConfigurationQuery;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.cps.services.IContext;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.Collection;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class CubeConfigurationCommand
extends ContentManagerCommand {
    protected static final QName BUS_OBJECTS = new QName("objects", BUS_NAMESPACE);
    protected static final QName BUS_ITEM = new QName("item", BUS_NAMESPACE);
    protected static final QName BUS_VALUE = new QName("value", BUS_NAMESPACE);
    protected static final QName BUS_SEARCHPATH = new QName("searchPath", BUS_NAMESPACE);
    private static final QName BUS_UPDATE = new QName("update", BUS_NAMESPACE);
    protected IContext context = null;
    protected boolean isVirtual = false;
    protected String resourceName = null;
    protected IResourceID resourceId = null;
    protected String datasourceName = null;

    public CubeConfigurationCommand(IContext context, String resourceName, IResourceID resourceId, String datasourceName, boolean isVirtual) {
        this.context = context;
        this.resourceName = resourceName;
        this.resourceId = resourceId;
        this.datasourceName = datasourceName;
        this.isVirtual = isVirtual;
    }

    protected void executeImpl(Element requestElement) throws CommandExecutionException {
        try {
            this.setBIBusHeader(this.getBusHeader());
            this.configureServerGroupConfigurationFolder(requestElement);
        }
        catch (CommandExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandExecutionException((Throwable)e);
        }
    }

    protected void handleResponseImpl(Element requestElement) throws CommandExecutionException {
    }

    protected Element configureServerGroupConfigurationFolder(Element requestElement) throws Exception {
        CubeConfigurationQuery cubeConfigQuery = CubeConfigurationQuery.getInstance();
        String searchPath = this.resourceName + "/" + "queryService";
        if (this.resourceId != null) {
            searchPath = "storeID('" + this.resourceId.getId() + "')";
        }
        String objectType = "queryService";
        Element eUpdate = requestElement.addElement(BUS_UPDATE);
        Element eObjects = eUpdate.addElement(BUS_OBJECTS);
        eObjects.addAttribute(SOAPEnvelope.XSI_TYPE, "SOAP-ENC:Array");
        eObjects.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClass[1]");
        Element eItem = eObjects.addElement(BUS_ITEM);
        eItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":" + objectType);
        Element eSearch = eItem.addElement(BUS_SEARCHPATH);
        eSearch.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        eSearch.addElement(BUS_VALUE).addText(searchPath);
        Element eCubeConfigurations = eItem.addElement("qsROLAPCubeConfigurations");
        eCubeConfigurations.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":" + "baseROLAPCubeConfigurationArrayProp");
        Element eValue = eCubeConfigurations.addElement(BUS_VALUE);
        eValue.addAttribute(SOAPEnvelope.XSI_TYPE, "SOAP-ENC:Array");
        eValue.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseROLAPCubeConfiguration[]");
        Collection<ConfiguredCube> configuredCubes = null;
        configuredCubes = this.resourceId != null ? (this.resourceId.getBaseType().equals("queryService") ? cubeConfigQuery.getQueryServiceConfiguredCubes(this.context, this.resourceId.getId(), true) : (this.resourceId.getBaseType().equals("serverGroup") ? cubeConfigQuery.getServerGroupConfiguredCubes(this.context, this.resourceId.getId(), true) : cubeConfigQuery.getSystemConfiguredCubes(this.context, true))) : (this.resourceName != null ? cubeConfigQuery.getDispatcherConfiguredCubesForSearchPath(this.context, searchPath, true) : cubeConfigQuery.getSystemConfiguredCubes(this.context, true));
        for (ConfiguredCube cube : configuredCubes) {
            if (cube.equals(this.datasourceName)) continue;
            eValue.add(cube.getElement());
        }
        return eValue;
    }

    protected Element getBusHeader() throws DocumentException {
        return DocumentHelper.parseText((String)this.context.getProperty("BUS_HEADER").toString()).getRootElement();
    }
}

