/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores.actions;

import com.cognos.admin.resource.datastores.actions.CubeConfigurationCommand;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.cps.services.IContext;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerDeleteCommand;
import org.dom4j.Element;

public class DeleteDatasourceCommand
extends CubeConfigurationCommand {
    public DeleteDatasourceCommand(IContext context, String resourceName, IResourceID resourceId, String datasourceName, boolean isVirtual) {
        super(context, resourceName, resourceId, datasourceName, isVirtual);
    }

    @Override
    protected void executeImpl(Element requestElement) throws CommandExecutionException {
        if (this.resourceId != null) {
            try {
                this.setBIBusHeader(this.getBusHeader());
            }
            catch (Exception e) {
                throw new CommandExecutionException((Throwable)e);
            }
        } else {
            super.executeImpl(requestElement);
        }
        this.deleteDatasource();
    }

    private void deleteDatasource() throws CommandExecutionException {
        ContentManagerDeleteCommand datasourcedeleteCmd = new ContentManagerDeleteCommand();
        try {
            datasourcedeleteCmd.setBIBusHeader(this.getBusHeader());
        }
        catch (Exception e) {
            throw new CommandExecutionException((Throwable)e);
        }
        datasourcedeleteCmd.setForce(true);
        datasourcedeleteCmd.setRecursive(true);
        String datasourceType = this.isVirtual ? "rolapVirtualDataSource" : "rolapDataSource";
        datasourcedeleteCmd.addObject(datasourceType);
        String searchPath = null;
        searchPath = this.resourceId != null ? "storeID('" + this.resourceId.getId() + "')" : "CAMID(\":\")/" + datasourceType + "[@name='" + this.datasourceName + "']";
        datasourcedeleteCmd.setSearchPath(searchPath);
        datasourcedeleteCmd.execute();
    }
}

