/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.datastores.actions;

import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.intf.IConditionalActionAccessHandler;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsdm.muws2.v1_1.OperationalStatusType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;

public class RolapConditionalActionAccessHandler
implements IConditionalActionAccessHandler {
    public static final String START_CUBE_ACTION = "StartCube";
    public static final String DECONFIGURE_CUBE_ACTION = "RemoveDataStoreFromServerGroup";
    public static final String CLEAR_CUBE_AGGREGATE_LOG = "ClearCubeAggregateLog";
    public String status = null;

    @Override
    public void init(IContext context) throws BaseFaultType {
        IResourceID resId = (IResourceID)context.getProperty("resourceID");
        IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getSinglePropertyHandler(context, resId.getType(), "OperationalStatus");
        handler.doIt(context);
        PropertyType prop = (PropertyType)handler.getPropertyList().get(0);
        this.status = prop.getValue() != null ? prop.getValue().toString() : null;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean isAccessible(String actionName) throws BaseFaultType {
        if (this.cubeIsNotConfigured()) {
            return false;
        }
        if (OperationalStatusType.PARTIALLYAVAILABLE.toString().equals(this.status)) {
            return true;
        }
        if (OperationalStatusType.UNKNOWN.toString().equals(this.status)) {
            return DECONFIGURE_CUBE_ACTION.equals(actionName);
        }
        if (OperationalStatusType.UNAVAILABLE.toString().equals(this.status)) {
            return DECONFIGURE_CUBE_ACTION.equals(actionName) || START_CUBE_ACTION.equals(actionName) || CLEAR_CUBE_AGGREGATE_LOG.equals(actionName);
        }
        if (START_CUBE_ACTION.equals(actionName) && OperationalStatusType.AVAILABLE.toString().equals(this.status)) {
            return false;
        }
        return OperationalStatusType.AVAILABLE.toString().equals(this.status);
    }

    private boolean cubeIsNotConfigured() {
        return this.status == null;
    }
}

