/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.BusRequestHelper;
import com.cognos.admin.common.COGAdminUtils;
import com.cognos.admin.resource.v1_0.ActionsHandler;
import com.cognos.admin.resource.v1_0.BusActionType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import org.dom4j.Element;

public class BusActionsHandler
extends ActionsHandler {
    private static final String METAVAR_SEARCHPATH = "%SEARCHPATH%";
    private static final String METAVAR_TIMESTAMP = "%TIMESTAMP%";

    public BusActionsHandler(ArrayList actionList) {
        super(actionList);
    }

    public BusActionsHandler() {
    }

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        if (this.m_actionList == null || this.m_actionList.size() == 0) {
            return;
        }
        String searchPath = (String)context.getProperty("cmSearchPath");
        if (searchPath == null) {
            return;
        }
        if (searchPath != null && searchPath.length() > 0) {
            for (BusActionType action : this.m_actionList) {
                Element eRequestTemplate = action.getRequestTemplate();
                if (eRequestTemplate == null) {
                    throw new BaseFaultType("No request template for action '" + action.getID().toString() + "'");
                }
                String sSoapAction = action.getSoapAction();
                String sRequestTarget = action.getRequestTarget();
                String sRequestStr = eRequestTemplate.asXML();
                sRequestStr = sRequestStr.replaceAll(METAVAR_SEARCHPATH, searchPath);
                sRequestStr = sRequestStr.replaceAll(METAVAR_TIMESTAMP, COGAdminUtils.XMLSchemaDateFormat.getTimeStamp());
                BusRequestHelper.makeBusRequest(context, sRequestStr, sRequestTarget, sSoapAction);
            }
        }
    }
}

