/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.InstalledComponents;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IActionsHandler;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceAction;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceAction;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceActionResponse;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipParticipantType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class CMResource
extends Resource {
    private String m_sDispatcherPath = "";

    public String getStoreID() {
        return this.m_id != null ? this.m_id.getId() : null;
    }

    public String getDispatcherPath(IContext context) {
        if (this.m_sDispatcherPath == null || this.m_sDispatcherPath.length() == 0) {
            String sSearchPath = "dispatcher".equals(this.getResourceID().getBaseType()) ? "storeID(\"" + this.getStoreID() + "\")" : "storeID(\"" + this.getStoreID() + "\")/..";
            PropertyType dispPath = new PropertyType("dispatcherPath", "cm");
            dispPath.setCMObjectName("dispatcherPath");
            ArrayList<PropertyType> cmProps = new ArrayList<PropertyType>(1);
            cmProps.add(dispPath);
            GenericCMObject cmObj = CMRequestHelper.queryCMSingleRequest(sSearchPath, cmProps, context);
            if (cmObj != null) {
                this.m_sDispatcherPath = cmObj.getParameter("dispatcherPath", "");
            }
        }
        return this.m_sDispatcherPath;
    }

    public void setDispatcherPath(String path) {
        this.m_sDispatcherPath = path;
    }

    protected String getConsolidatedMBeanNamePattern(IContext context) {
        return new StringBuffer("dispatcher=\"").append(this.getDispatcherPath(context)).append("\"").toString();
    }

    @Override
    public String getMBeanNamePattern(IContext context) {
        boolean isDispatcher = this.getResourceID().getBaseType().equals("dispatcher");
        StringBuffer pattern = new StringBuffer();
        if (this.isTemplate()) {
            if (isDispatcher) {
                pattern.append("template=dispatcher");
            } else {
                pattern.append("template=service,service=").append(this.getResourceType());
            }
        } else if (isDispatcher) {
            pattern.append(this.getConsolidatedMBeanNamePattern(context));
        } else {
            pattern.append("dispatcher=\"").append(this.getDispatcherPath(context)).append("\",service=").append(this.getResourceType());
        }
        return pattern.toString();
    }

    @Override
    protected void setContext(IContext context) {
        this.setContext(context, this);
    }

    protected void setContext(IContext context, CMResource cmRes) {
        if (context != null && cmRes != null) {
            context.setProperty("storeID", (Object)cmRes.getStoreID());
            context.setProperty("cmSearchPath", (Object)new StringBuffer("storeID").append("(\"").append(cmRes.getStoreID()).append("\")").toString());
            context.setProperty("cmResourceType", (Object)cmRes.getResourceType());
            context.setProperty("resourceMbeanPattern", (Object)cmRes.getMBeanNamePattern(context));
            context.setProperty("resourceID", (Object)cmRes.getResourceID());
            context.setProperty("dispPath", (Object)cmRes.getDispatcherPath(context));
            context.setProperty("IResource", (Object)cmRes);
        }
    }

    @Override
    protected String buildRelationshipRequest(String requestedType, IContext context) throws BaseFaultType {
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        ArrayList childProps = new ArrayList();
        ArrayList cmProps = new ArrayList();
        String sChildrenSearchPath = "";
        if (requestedType.equalsIgnoreCase("containedBy") && this.getResourceID().getBaseType().equals("dispatcher")) {
            String seviceFilter = CMResource.genSearchPathServiceFilter(context);
            if (seviceFilter.length() == 0) {
                sChildrenSearchPath = "";
            } else {
                sChildrenSearchPath = new StringBuffer("storeID").append("(\"").append(this.getStoreID()).append("\")/*").append(seviceFilter).toString();
                childProps = this.getServiceProperties(context, Constants.QRBT_RESPONSE_PROP_LIST, "dispatcher", tLocale);
                cmProps = ResourcePropertiesRetriever.getInstance(context).getiResourceCMProperties(this.getResourceType(), Constants.QRBT_RESPONSE_PROP_LIST, tLocale);
                PropertyType dispPath = new PropertyType("dispatcherPath", "cm");
                dispPath.setCMObjectName("dispatcherPath");
                cmProps.add(dispPath);
            }
        }
        if (sChildrenSearchPath.length() > 0) {
            StringBuffer req = CMRequestHelper.startCMQueryRequest();
            CMRequestHelper.appendQueryRequest(req, new StringBuffer("storeID").append("(\"").append(this.getStoreID()).append("\")").toString(), cmProps);
            CMRequestHelper.appendQueryRequest(req, sChildrenSearchPath, childProps);
            CMRequestHelper.endCMQueryRequest(req);
            return req.toString();
        }
        throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
    }

    @Override
    protected void addQRBTParticipant(RelationshipType relationship, String sType, List<GenericCMObject> cmObjects, ArrayList<String> listOfProperties, IContext context) throws BaseFaultType {
        IPropertiesHandler healthHandler = null;
        if (this.getResourceID().getBaseType().equals("dispatcher")) {
            context.setProperty("resourceMbeanType", (Object)"consolidated");
            context.setProperty("resourceMbeanPattern", (Object)this.getConsolidatedMBeanNamePattern(context));
            context.setProperty("cmResourceType", (Object)this.getResourceType());
            healthHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, this.getResourceType(), Constants.QRBT_RESPONSE_PROP_HEALTH_LIST);
            healthHandler.doIt(context);
            this.resetContext(context);
        }
        listOfProperties.addAll(Constants.QRBT_RESPONSE_PROP_WITHOUT_HEALTH_LIST);
        for (int i = 0; i < cmObjects.size(); ++i) {
            CMResource cmRes;
            GenericCMObject cmObj = cmObjects.get(i);
            String storeID = cmObj.getParameter("storeID", "");
            if (storeID == null || storeID.length() == 0) continue;
            String type = cmObj.getType();
            int idx = type.indexOf(":");
            if (idx != -1) {
                type = type.substring(idx + 1);
            }
            if (storeID.equals(this.getStoreID())) {
                cmRes = this;
            } else {
                IResourceID id = ResourceIdFactory.getResourceID(type, storeID, context);
                cmRes = (CMResource)ResourceLookupManager.getInstance().find(id);
            }
            if (cmRes == null) continue;
            String dispPath = "";
            if (type.equals("dispatcher")) {
                dispPath = cmObj.getParameter("dispatcherPath", "");
            }
            cmRes.setDispatcherPath(dispPath);
            context.setProperty("cmObject", (Object)cmObj);
            context.setProperty("resourceMbeanPattern", (Object)cmRes.getMBeanNamePattern(context));
            IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, cmRes.getResourceType(), listOfProperties);
            handler.doIt(context);
            RelationshipParticipantType p = cmRes.generateQRBTPaticipant(handler, healthHandler, context, type.equals("dispatcher"));
            relationship.addParticipant(p);
        }
    }

    @Override
    public ExecuteResourceActionResponse executeResourceAction(ExecuteResourceAction sAction, IContext context) throws BaseFaultType {
        IActionsHandler handler = ResourcePropertiesRetriever.getInstance(context).getActionsHandler(context, this.getResourceType(), null, null);
        String dispPath = this.getDispatcherPath(context);
        try {
            List<String> installedComponents = InstalledComponents.getInstalledComponents(dispPath);
            Iterator handlerIter = handler.iterator();
            while (handlerIter.hasNext()) {
                IResourceAction actionType = (IResourceAction)handlerIter.next();
                if (!actionType.getID().equals(sAction.getName())) continue;
                boolean bActionSupported = InstalledComponents.isInstalled(actionType.getRequiredComponents(), installedComponents);
                if (bActionSupported) break;
                throw new BaseFaultType("error.action.missingrequiredcomponents");
            }
        }
        catch (Exception e) {
            throw new BaseFaultType(e);
        }
        return super.executeResourceAction(sAction, context);
    }
}

