/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.AdminMetadataRetriever;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import java.io.Serializable;

public class CMResourceID
implements IResourceID,
Serializable {
    private static final String REF_RESOURCE_ID_DELIMITER = "/";
    public static final String CM_RESOURCE_PREFIX = "cm";
    private static final String CM_RESOURCE_ID_PREFIX = "id";
    public static final String TYPE_NAME_DELIMITER = "_";
    private static final int IDX_SYSTEM = 0;
    private static final int IDX_TYPE = 1;
    private static final int IDX_ID_PREFIX = 2;
    private static final int IDX_STOREID = 3;
    private String type = null;
    private String baseType = null;
    private String storeId = null;
    private IResourceID refResourceID = null;

    public CMResourceID() {
    }

    public CMResourceID(String resourceId) throws BaseFaultType {
        this.init(resourceId);
    }

    public CMResourceID(String type, String id) throws BaseFaultType {
        this.init(type, id, null);
    }

    @Override
    public void init(String type, String id, IResourceID referringResourceId) throws BaseFaultType {
        this.setType(type);
        this.setStoreId(id);
        this.setReferringResourceID(referringResourceId);
    }

    @Override
    public void init(String resourceId) throws BaseFaultType {
        if (resourceId != null) {
            String[] tokens = resourceId.split(":", 4);
            String _system = tokens[0];
            if (tokens.length < 2 || !_system.equals(this.getSystem())) {
                Object[] args = new String[]{resourceId};
                throw new BaseFaultType("error.invalidresourceid", args, null);
            }
            String _type = tokens[1];
            if (!AdminMetadataRetriever.getInstance(this.getSystem()).getResourceTypeIds().contains(_type)) {
                Object[] args = new String[]{resourceId};
                throw new BaseFaultType("error.invalidresourceid", args, null);
            }
            this.setType("configuration".equals(_type) ? "system" : _type);
            if (tokens.length < 3) {
                if (!this.getType().equals("system")) {
                    Object[] args = new String[]{resourceId};
                    throw new BaseFaultType("error.invalidresourceid", args, null);
                }
            } else {
                String _idKey = tokens[2];
                if (!_idKey.equals(CM_RESOURCE_ID_PREFIX)) {
                    Object[] args = new String[]{resourceId};
                    throw new BaseFaultType("error.invalidresourceid", args, null);
                }
                String _storeId = tokens[3];
                this.setStoreId(_storeId);
            }
        } else {
            Object[] args = new String[]{resourceId};
            throw new BaseFaultType("error.invalidresourceid", args, null);
        }
    }

    private void setType(String type) {
        this.type = this.normalizeType(type);
        this.setBaseType(this.type.split(TYPE_NAME_DELIMITER, 2)[0]);
    }

    private String normalizeType(String rawType) {
        String[] tokens = rawType.split(":");
        return tokens[tokens.length - 1];
    }

    private void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public String getBaseType() {
        return this.baseType;
    }

    public void setStoreId(String storeId) throws BaseFaultType {
        if (storeId != null && !"serverGroup".equals(this.getType())) {
            String[] tokens = storeId.split(REF_RESOURCE_ID_DELIMITER, 2);
            if (tokens.length == 2) {
                this.storeId = tokens[0];
                this.setReferringResourceID(ResourceIdFactory.getResourceID(tokens[1]));
            } else {
                this.storeId = storeId;
            }
        } else {
            this.setReferringResourceID(null);
            this.storeId = storeId;
        }
    }

    @Override
    public String getSystem() {
        return CM_RESOURCE_PREFIX;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.storeId;
    }

    public String toString() {
        StringBuffer resourceId = new StringBuffer(this.getSystem()).append(":").append(this.getType());
        if (this.getId() != null) {
            resourceId.append(":id:").append(this.getId());
            if (this.getReferringResourceID() != null) {
                resourceId.append(REF_RESOURCE_ID_DELIMITER).append(this.getReferringResourceID());
            }
        }
        return resourceId.toString();
    }

    public void setReferringResourceID(IResourceID refResourceID) {
        this.refResourceID = refResourceID;
    }

    @Override
    public IResourceID getReferringResourceID() {
        return this.refResourceID;
    }

    public boolean equals(Object obj) {
        return obj != null && this.toString().equals(obj.toString());
    }
}

