/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.COGAdminUtils;
import com.cognos.admin.common.CacheManagerSingleton;
import com.cognos.admin.common.ReflectionUtils;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.cache.AdminCache;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.resource.v1_0.intf.IResourceLookup;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CMResourceLookup
extends Constants
implements IResourceLookup,
Serializable {
    private static final String CLASSNAME = "CMResourceLookup";
    private Map<String, Class<IResource>> resourceTypes = Collections.synchronizedMap(new HashMap());
    private AdminCache resources = null;

    @Override
    public void initialize() throws BaseFaultType {
        this.resources = CacheManagerSingleton.getInstance().createCache(this.getClass().getName());
        String sResourceTypes = COGAdminUtils.getProperty(new StringBuffer(this.getName() + ".types").toString());
        if (sResourceTypes != null) {
            StringTokenizer token = new StringTokenizer(sResourceTypes, ",");
            while (token.hasMoreTokens()) {
                String resourceType = token.nextToken().trim();
                String resClassName = COGAdminUtils.getProperty(new StringBuffer(this.getName() + ".className" + ".").append(resourceType).toString());
                try {
                    Class cmResClass = ReflectionUtils.classForName(resClassName, IResource.class);
                    if (cmResClass == null) continue;
                    this.resourceTypes.put(resourceType, cmResClass);
                }
                catch (Exception e) {
                    throw new BaseFaultType("error.exception", e);
                }
            }
        }
    }

    @Override
    public IResource find(IResourceID resourceId) throws BaseFaultType {
        String sResourceId = resourceId.toString();
        IResource resource = (IResource)this.resources.get(sResourceId);
        if (resource == null) {
            Class<IResource> cmResClass = this.resourceTypes.get(resourceId.getType());
            if (cmResClass != null) {
                try {
                    resource = (IResource)ReflectionUtils.newInstance(cmResClass);
                }
                catch (Exception e) {
                    throw new BaseFaultType("error.exception", e);
                }
            } else {
                resource = new CMResource();
            }
            if (resource != null) {
                resource.initialize();
                resource.setResourceID(resourceId);
                this.resources.put(resourceId.toString(), resource);
            }
        }
        if (resource == null) {
            Object[] args = new String[]{sResourceId};
            throw new BaseFaultType("error.resourcelookup.notfound", args, null);
        }
        return resource;
    }

    @Override
    public void terminate() throws BaseFaultType {
        this.resourceTypes.clear();
        this.resources.clear();
    }

    protected String getName() {
        return CLASSNAME;
    }

    @Override
    public IResourceID getRoot() {
        try {
            return ResourceIdFactory.getResourceID("cm:system");
        }
        catch (BaseFaultType e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("CMResourceLookup:getRoot", e);
            }
            throw new RuntimeException(e);
        }
    }
}

