/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.MBeanType;
import javax.xml.datatype.DatatypeFactory;

public class DurationMBeanType
extends MBeanType {
    private static final long serialVersionUID = 1L;
    private static final String SECONDS = "seconds";
    private static final int DEFAULT_UNITS_MULTIPLIER = 1;
    private int unitsMultiplier = 1;

    @Override
    public void setValue(Object value) {
        super.setValue(value != null && (value instanceof Long || value instanceof Float) ? this.format(value) : value);
    }

    @Override
    public void setUnits(String units) {
        this.unitsMultiplier = units.equalsIgnoreCase(SECONDS) ? 1000 : 1;
    }

    private String format(Object value) {
        String str = "";
        try {
            long durationInMilliSeconds = 0L;
            if (value instanceof Long) {
                durationInMilliSeconds = (Long)value * (long)this.unitsMultiplier;
            } else if (value instanceof Float) {
                durationInMilliSeconds = (long)(((Float)value).floatValue() * (float)this.unitsMultiplier);
            }
            str = DatatypeFactory.newInstance().newDuration(durationInMilliSeconds).toString();
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("format", e);
            str = "";
        }
        return str;
    }

    @Override
    public Object clone() {
        DurationMBeanType resObj = new DurationMBeanType();
        resObj.unitsMultiplier = this.unitsMultiplier;
        this.copy(resObj);
        return resObj;
    }
}

