/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.AdminConfigProperties;
import com.cognos.admin.resource.v1_0.Action;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class MBeanActionType
extends Action {
    private static final long serialVersionUID = 1L;
    protected String m_sObjectName;
    protected String m_sOperation;
    protected ArrayList m_argumentNames = new ArrayList();
    protected HashMap m_arguments = new HashMap();
    private HashMap<String, String> m_argumentTypes = new HashMap();

    public MBeanActionType() {
    }

    public MBeanActionType(Element element) {
        super(element);
        Element requestElem = element.element(AdminConfigProperties.COG_ACTION_REQUEST.getLocalPart());
        if (requestElem != null) {
            Element objectName = requestElem.element(AdminConfigProperties.COG_ACTION_OBJECTNAME.getLocalPart());
            this.setObjectName(objectName != null ? objectName.getText() : null);
            Element operation = requestElem.element(AdminConfigProperties.COG_ACTION_OPERATION.getLocalPart());
            this.setOperation(operation != null ? operation.getText() : null);
            Element argumentsElem = requestElem.element(AdminConfigProperties.COG_ACTION_ARGUMENTS.getLocalPart());
            if (argumentsElem != null) {
                List args = argumentsElem.elements(AdminConfigProperties.COG_ACTION_ARGUMENT.getLocalPart());
                for (Element argument : args) {
                    Element argNameElem = argument.element(AdminConfigProperties.COG_ACTION_NAME_REF.getLocalPart());
                    Element validValuesElem = argument.element(AdminConfigProperties.COG_ACTION_VALIDVALUES.getLocalPart());
                    if (argNameElem == null || validValuesElem == null) continue;
                    HashMap<String, String> valuesMap = new HashMap<String, String>();
                    List valueMaps = validValuesElem.elements(AdminConfigProperties.COG_ACTION_VALUEMAP.getLocalPart());
                    for (Element vm : valueMaps) {
                        Element fromElem = vm.element(AdminConfigProperties.COG_ACTION_FROM.getLocalPart());
                        if (fromElem == null) continue;
                        String sFrom = fromElem.getTextTrim();
                        Element toElem = vm.element(AdminConfigProperties.COG_ACTION_TO.getLocalPart());
                        if (toElem == null) continue;
                        String sTo = toElem.getTextTrim();
                        valuesMap.put(sFrom, sTo);
                    }
                    String sArgName = argNameElem.getTextTrim();
                    this.m_argumentNames.add(sArgName);
                    this.m_arguments.put(sArgName, valuesMap);
                    Element argTypeElem = argument.element(AdminConfigProperties.COG_ACTION_ARG_TYPE.getLocalPart());
                    if (argTypeElem == null) continue;
                    String sArgType = argTypeElem.getTextTrim();
                    this.m_argumentTypes.put(sArgName, sArgType);
                }
            }
        }
    }

    public HashMap<String, String> getArgumentTypes() {
        return this.m_argumentTypes;
    }

    public void setArgumentTypes(HashMap<String, String> mArgumentTypes) {
        this.m_argumentTypes = mArgumentTypes;
    }

    @Override
    public void initialize() {
    }

    public String getObjectName() {
        return this.m_sObjectName;
    }

    public void setObjectName(String sObjName) {
        this.m_sObjectName = sObjName;
    }

    public String getOperation() {
        return this.m_sOperation;
    }

    public void setOperation(String sOperation) {
        this.m_sOperation = sOperation;
    }

    public HashMap getArguments() {
        return new HashMap(this.m_arguments);
    }

    public void setArguments(HashMap arguments) {
        this.m_arguments = arguments;
    }

    public ArrayList getArgumentNames() {
        return new ArrayList(this.m_argumentNames);
    }

    public void setArgumentNames(ArrayList arguments) {
        this.m_argumentNames = arguments;
    }

    @Override
    public Object clone() {
        MBeanActionType resObj = new MBeanActionType();
        this.copy(resObj);
        return resObj;
    }

    @Override
    protected Object copy(Object aObj) {
        super.copy(aObj);
        if (aObj instanceof MBeanActionType) {
            MBeanActionType mBeanActionType = (MBeanActionType)aObj;
            mBeanActionType.setObjectName(this.getObjectName());
            mBeanActionType.setOperation(this.getOperation());
            mBeanActionType.setArguments(this.getArguments());
            mBeanActionType.setArgumentNames(this.getArgumentNames());
            mBeanActionType.setArgumentTypes(this.getArgumentTypes());
        }
        return aObj;
    }
}

