/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.COGAdminUtils;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.ActionsHandler;
import com.cognos.admin.resource.v1_0.MBeanActionType;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.cogadmin.v1_0.Detail;
import com.cognos.admin.ws.cogadmin.v1_0.Details;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class MBeanActionsHandler
extends ActionsHandler {
    private static final String CONTEXT_KEY = "context:";

    public MBeanActionsHandler(ArrayList actionList) {
        super(actionList);
    }

    public MBeanActionsHandler() {
    }

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        if (this.m_actionList == null || this.m_actionList.size() != 1) {
            return;
        }
        MBeanActionType mat = (MBeanActionType)this.m_actionList.get(0);
        if (mat.getObjectName() != null && mat.getOperation() != null) {
            String mbeanName = this.resolveMBeanObjectName(context, mat);
            try {
                this.checkConditions(context, mat);
            }
            catch (XTSInstructionException e) {
                CogAdminLogger.getInstance().error("Could not invoke " + mbeanName + "::" + mat.getOperation() + " .checkConditions() failure", e);
                throw new BaseFaultType("error.exception", e);
            }
            catch (BaseFaultType e2) {
                throw e2;
            }
            Set<ObjectName> names = null;
            MBeanServer server = this.getMBeanServer();
            try {
                ObjectName scope = new ObjectName(mbeanName);
                names = server.queryNames(scope, null);
            }
            catch (MalformedObjectNameException e) {
                CogAdminLogger.getInstance().error("Could not find mbean " + mbeanName, e);
                throw new BaseFaultType("error.exception", e);
            }
            catch (Exception e) {
                CogAdminLogger.getInstance().error("Could not find mbean " + mbeanName, e);
                throw new BaseFaultType("error.exception", e);
            }
            if (names.size() > 0) {
                ObjectName objectName = names.iterator().next();
                try {
                    String sOnSuccessCaption;
                    ArrayList argNames = mat.getArgumentNames();
                    String[] signature = new String[argNames.size()];
                    Object[] mBeanArgs = new Object[argNames.size()];
                    int count = 0;
                    for (String sArgName : argNames) {
                        HashMap valuesMap = (HashMap)mat.getArguments().get(sArgName);
                        String sArgType = mat.getArgumentTypes().get(sArgName);
                        String sArgumentFrom = (String)context.getProperty(sArgName);
                        String sArgumentTo = null;
                        if (sArgumentFrom != null) {
                            int idx;
                            sArgumentTo = (String)valuesMap.get(sArgumentFrom);
                            while (sArgumentTo == null && (idx = sArgumentFrom.lastIndexOf("/")) >= 0) {
                                sArgumentFrom = sArgumentFrom.substring(0, idx);
                                sArgumentTo = (String)valuesMap.get(sArgumentFrom);
                            }
                            if (sArgumentTo != null) {
                                mBeanArgs[count] = sArgumentTo;
                                signature[count] = sArgumentTo.getClass().getName();
                            }
                        } else {
                            int end;
                            int start;
                            sArgumentTo = (String)valuesMap.get(sArgName);
                            if (sArgumentTo != null && (start = sArgumentTo.indexOf("#")) != -1 && (end = sArgumentTo.indexOf("#", start + 1)) != -1) {
                                String sPropertyName = sArgumentTo.substring(start + 1, end);
                                if ((start = sPropertyName.indexOf(CONTEXT_KEY)) != -1) {
                                    sArgumentTo = (String)context.getProperty(sPropertyName.substring(CONTEXT_KEY.length()));
                                } else {
                                    IResourceProperty prop;
                                    Object value;
                                    Object element;
                                    IResource res = (IResource)context.getProperty("IResource");
                                    IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getSinglePropertyHandler(context, res.getResourceID().getType(), sPropertyName);
                                    handler.doIt(context);
                                    Iterator propIter = handler.iterator();
                                    if (propIter.hasNext() && IResourceProperty.class.isAssignableFrom((element = propIter.next()).getClass()) && String.class.isAssignableFrom((value = (prop = (IResourceProperty)element).getValue()).getClass())) {
                                        sArgumentTo = (String)value;
                                    }
                                }
                            }
                            if (sArgumentTo != null) {
                                mBeanArgs[count] = sArgType.equals("[Ljava.lang.String;") ? new String[]{sArgumentTo} : sArgumentTo;
                            }
                            signature[count] = sArgType;
                        }
                        ++count;
                    }
                    if (CogAdminLogger.getInstance().isDebugEnabled()) {
                        StringBuffer args = new StringBuffer();
                        for (int i = 0; i < mBeanArgs.length; ++i) {
                            if (i > 0) {
                                args.append(",");
                            }
                            args.append(mBeanArgs[i].toString());
                        }
                        CogAdminLogger.getInstance().debug("MBeanActionsHandler::doIt() - Invoking the the mbean operation '" + mat.getOperation() + "' on object '" + objectName + "' with the following args: '" + args.toString() + "'");
                    }
                    Object obj = server.invoke(objectName, mat.getOperation(), mBeanArgs, signature);
                    if (CogAdminLogger.getInstance().isDebugEnabled()) {
                        CogAdminLogger.getInstance().debug("MBeanActionsHandler::doIt() - Return value is " + (obj == null ? "null" : obj.toString()));
                    }
                    if ((sOnSuccessCaption = mat.getOnSuccessCaptionId()) != null) {
                        Details details = new Details();
                        Detail detail = new Detail();
                        Locale locale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
                        detail.addMessage(MessagesManagerFacade.getInstance().getMessage(locale, sOnSuccessCaption));
                        details.addDetail(detail);
                        mat.setValue(details);
                    }
                }
                catch (InstanceNotFoundException e) {
                    CogAdminLogger.getInstance().error("Could not invoke " + mbeanName + "::" + mat.getOperation(), e);
                    throw new BaseFaultType("error.exception", e);
                }
                catch (ReflectionException e) {
                    CogAdminLogger.getInstance().error("Could not invoke " + mbeanName + "::" + mat.getOperation(), e);
                    throw new BaseFaultType("error.exception", e);
                }
                catch (RuntimeMBeanException e) {
                    CogAdminLogger.getInstance().error("Error while invoking " + mbeanName + "::" + mat.getOperation(), e);
                    RuntimeException targetException = e.getTargetException();
                    while (targetException instanceof RuntimeMBeanException) {
                        targetException = ((RuntimeMBeanException)targetException).getTargetException();
                    }
                    throw new BaseFaultType("error.exception", targetException);
                }
                catch (Exception e) {
                    CogAdminLogger.getInstance().error("Could not invoke " + mbeanName + "::" + mat.getOperation(), e);
                    throw new BaseFaultType("error.exception", e);
                }
            }
        }
    }

    protected MBeanServer getMBeanServer() throws BaseFaultType {
        try {
            if (CogAdminLogger.getInstance().isDebugEnabled()) {
                CogAdminLogger.getInstance().debug("MBeanPropertiesHandler::getMBeanServer - get proxy mbean server.");
            }
            MBeanServer server = PogoMBeanServer.getInstance().getProxyMBeanServer();
            return server;
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("Could not get proxy mbean server.", e);
            throw new BaseFaultType("error.exception", e);
        }
    }

    protected String resolveMBeanObjectName(IContext context, MBeanActionType mtype) {
        String sObjName = mtype.getObjectName();
        String mbeanNamePattern = (String)context.getProperty("resourceMbeanPattern");
        if (sObjName != null && mbeanNamePattern != null) {
            return sObjName.replaceAll("#MBeanNamePattern#", COGAdminUtils.RegexEncode(mbeanNamePattern));
        }
        return "";
    }

    protected void checkConditions(IContext context, MBeanActionType mat) throws XTSInstructionException, BaseFaultType {
    }
}

