/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.MBeanActionType;
import com.cognos.admin.resource.v1_0.MBeanActionsHandler;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;

public class MBeanByRefActionsHandler
extends MBeanActionsHandler {
    @Override
    protected String resolveMBeanObjectName(IContext context, MBeanActionType mtype) {
        String sObjName = mtype.getObjectName();
        IResourceID resourceID = (IResourceID)context.getProperty("resourceID");
        try {
            IResourceID refResourceID = resourceID.getReferringResourceID();
            IResource resourceObj = ResourceLookupManager.getInstance().find(refResourceID);
            if (Resource.class.isAssignableFrom(resourceObj.getClass())) {
                Resource resource = (Resource)resourceObj;
                String mbeanNamePattern = resource.getMBeanNamePattern(context);
                return sObjName.replaceAll("#MBeanNamePattern#", mbeanNamePattern);
            }
        }
        catch (BaseFaultType e) {
            CogAdminLogger.getInstance().error("Looking up referring resource failed, letting it fall through, e is " + e.getMessage());
        }
        return null;
    }
}

