/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.COGAdminUtils;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.datastores.actions.ContextCache;
import com.cognos.admin.resource.v1_0.MBeanType;
import com.cognos.admin.resource.v1_0.PropertiesHandler;
import com.cognos.admin.ws.cogadmin.v1_0.ActivityType;
import com.cognos.admin.ws.cogadmin.v1_0.CancelInteractiveActivities;
import com.cognos.admin.ws.cogadmin.v1_0.FilterType;
import com.cognos.admin.ws.cogadmin.v1_0.FiltersType;
import com.cognos.admin.ws.cogadmin.v1_0.GetInteractiveActivities;
import com.cognos.admin.ws.cogadmin.v1_0.PageType;
import com.cognos.admin.ws.cogadmin.v1_0.PropertyType;
import com.cognos.admin.ws.cogadmin.v1_0.SortType;
import com.cognos.admin.ws.cogadmin.v1_0.ThresholdBoundaryType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManagerMBean;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.TabularData;

public class MBeanPropertiesHandler
extends PropertiesHandler {
    private static final String TYPE_METRICHEALTH = "type=MetricHealth";
    private static final String REGEX_TYPEMETRICS = "type=\\w*";

    public MBeanPropertiesHandler(ArrayList propertyList) {
        super(propertyList);
    }

    public MBeanPropertiesHandler() {
    }

    private MBeanServer getMBeanServer() {
        try {
            MBeanServer server = PogoMBeanServer.getInstance().getProxyMBeanServer();
            return server;
        }
        catch (Exception e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("Could not get proxy mbean server.", e);
            }
            return null;
        }
    }

    private ThresholdManagerMBean getThresholdManager(MBeanServerConnection server) throws BaseFaultType {
        try {
            ObjectName objname = ObjectName.getInstance("com.cognos:type=ThresholdManager");
            if (server != null) {
                ThresholdManagerMBean manager = MBeanServerInvocationHandler.newProxyInstance(server, objname, ThresholdManagerMBean.class, false);
                return manager;
            }
        }
        catch (MalformedObjectNameException e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("MBeanPropertiesHandler::getThresholdManager - unable to get threshold manager", e);
            }
            throw new BaseFaultType(e);
        }
        return null;
    }

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        String healthMbeanName;
        if (this.m_propertyList == null || this.m_propertyList.size() == 0) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("No mbean properties are defined.");
            }
            return;
        }
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("Could not find mbean server.");
            }
            return;
        }
        String sThresholdsCmd = (String)context.getProperty("thresholdAction");
        if (sThresholdsCmd != null && sThresholdsCmd.length() > 0) {
            this.doThresholdActions(server, context, sThresholdsCmd);
            return;
        }
        String mbeanType = (String)context.getProperty("resourceMbeanType");
        if (mbeanType != null && mbeanType.equals("consolidated")) {
            this.queryConsolidatedMBean(server, context);
            return;
        }
        Object sContext = context.getProperty("getInteractiveActivitiesRequest");
        if (sContext != null && GetInteractiveActivities.class == sContext.getClass()) {
            GetInteractiveActivities request = (GetInteractiveActivities)sContext;
            this.getInteractiveActivities(request, server, context);
            return;
        }
        sContext = context.getProperty("cancelInteractiveActivitiesRequest");
        if (sContext != null && CancelInteractiveActivities.class == sContext.getClass()) {
            CancelInteractiveActivities request = (CancelInteractiveActivities)sContext;
            this.cancelInteractiveActivities(request, server, context);
            return;
        }
        int PROPS_PER_GRP = 20;
        int NUM_OF_GROUPS = this.m_propertyList.size() / 20;
        HashMap mbeanAttrsMap = new HashMap(NUM_OF_GROUPS);
        HashMap<String, ArrayList> mbeanHealthAttrsMap = new HashMap<String, ArrayList>(NUM_OF_GROUPS);
        for (int i = 0; i < this.m_propertyList.size(); ++i) {
            ArrayList mbeanAttrList;
            MBeanType mtype = (MBeanType)this.m_propertyList.get(i);
            String mbeanName = this.resolveMBeanObjectName(context, mtype);
            if (mbeanName == null || mbeanName.length() == 0) continue;
            if (mbeanAttrsMap.get(mbeanName) == null) {
                mbeanAttrList = new ArrayList(20);
                mbeanAttrsMap.put(mbeanName, mbeanAttrList);
            } else {
                mbeanAttrList = (ArrayList)mbeanAttrsMap.get(mbeanName);
            }
            String mbeanValueAttrName = this.getMBeanValueAttrName(mtype);
            if (!mbeanAttrList.contains(mbeanValueAttrName)) {
                mbeanAttrList.add(mbeanValueAttrName);
            }
            HashMap attrsMap = mtype.getAttributeMap();
            Set attr_keys = attrsMap.keySet();
            for (String key : attr_keys) {
                if (key.equals("Health")) {
                    ArrayList metricAttrHealthList;
                    healthMbeanName = this.resolveHealthMBeanObjectName(context, mtype);
                    if (mbeanHealthAttrsMap.get(healthMbeanName) == null) {
                        metricAttrHealthList = new ArrayList(20);
                        mbeanHealthAttrsMap.put(healthMbeanName, metricAttrHealthList);
                    } else {
                        metricAttrHealthList = (ArrayList)mbeanHealthAttrsMap.get(healthMbeanName);
                    }
                    if (metricAttrHealthList.contains(mbeanValueAttrName)) continue;
                    metricAttrHealthList.add(mbeanValueAttrName);
                    continue;
                }
                if (mbeanAttrList.contains(key)) continue;
                mbeanAttrList.add(key);
            }
        }
        String contextKey = mbeanAttrsMap.toString();
        HashMap cachedMetricValues = (HashMap)ContextCache.getProperty(context, contextKey);
        if (cachedMetricValues == null) {
            this.getMetricsValue(mbeanAttrsMap, server);
            ContextCache.setProperty(context, contextKey, mbeanAttrsMap);
        } else {
            mbeanAttrsMap = cachedMetricValues;
        }
        this.getMetricsValue(mbeanHealthAttrsMap, server);
        block2: for (int i = 0; i < this.m_propertyList.size(); ++i) {
            String name;
            Attribute attr;
            AttributeList metricValues;
            MBeanType mtype = (MBeanType)this.m_propertyList.get(i);
            HashMap attrsMap = mtype.getAttributeMap();
            Set attr_keys = attrsMap.keySet();
            int attrNum = attr_keys.size() + 1;
            int count = 0;
            String mbeanName = this.resolveMBeanObjectName(context, mtype);
            if (mbeanName == null || mbeanName.length() == 0 || (metricValues = (AttributeList)mbeanAttrsMap.get(mbeanName)) == null) continue;
            healthMbeanName = this.resolveHealthMBeanObjectName(context, mtype);
            AttributeList metricHealthValues = (AttributeList)mbeanHealthAttrsMap.get(healthMbeanName);
            mtype.clearAttributeValueMap();
            String wsdmHealthName = (String)attrsMap.get("Health");
            if (wsdmHealthName != null && wsdmHealthName.length() > 0 && metricHealthValues != null) {
                for (int m = 0; m < metricHealthValues.size(); ++m) {
                    attr = (Attribute)metricHealthValues.get(m);
                    name = attr.getName();
                    if (name == null || name.length() <= 0 || !name.equals(this.getMBeanValueAttrName(mtype))) continue;
                    mtype.setAttributeValueMap(wsdmHealthName, attr.getValue());
                    break;
                }
                ++count;
            }
            for (int ii = 0; ii < metricValues.size(); ++ii) {
                attr = (Attribute)metricValues.get(ii);
                name = attr.getName();
                if (name != null && name.length() > 0) {
                    String wsdmName;
                    String mbeanValueAttrName = this.getMBeanValueAttrName(mtype);
                    if (name.equals(mbeanValueAttrName)) {
                        mtype.setValue(this.getAttributeValue(context, attr, mtype));
                        ++count;
                    } else if (!name.equals("Health") && (wsdmName = (String)attrsMap.get(name)) != null && wsdmName.length() > 0 && mtype.getAttributes().get(wsdmName) == null) {
                        mtype.setAttributeValueMap(wsdmName, attr.getValue());
                        ++count;
                    }
                }
                if (count == attrNum) continue block2;
            }
        }
    }

    private Object getAttributeValue(IContext context, Attribute attr, MBeanType mtype) throws CacheException {
        Object value;
        block7: {
            value = null;
            Object obj = attr.getValue();
            if (obj != null && CompositeData.class.isAssignableFrom(obj.getClass())) {
                CompositeData composite = (CompositeData)obj;
                String compositeKey = this.getMBeanValueCompositeKey(mtype);
                try {
                    value = composite.get(compositeKey);
                    if (value == null || !TabularData.class.isAssignableFrom(value.getClass())) break block7;
                    TabularData table = (TabularData)value;
                    String sTableKey = this.getMBeanValueTabularKey(context, mtype);
                    Object[] tableKey = new String[]{sTableKey};
                    String columnId = null;
                    try {
                        CompositeData row = table.get(tableKey);
                        columnId = this.getMBeanValueCompositeKey2(mtype);
                        value = row.get(columnId);
                        break block7;
                    }
                    catch (Exception e) {
                        if (CogAdminLogger.getInstance().isDebugEnabled()) {
                            CogAdminLogger.getInstance().debug("Unable to get composite value for mbean '" + mtype.getMBeanObjectName() + "', attrribute '" + mtype.getMBeanValueAttrName() + "', composite key '" + columnId + "'. Exception is " + e.getMessage());
                        }
                        break block7;
                    }
                }
                catch (Exception e) {
                    if (CogAdminLogger.getInstance().isDebugEnabled()) {
                        CogAdminLogger.getInstance().debug("Unable to get composite value for mbean '" + mtype.getMBeanObjectName() + "', attrribute '" + mtype.getMBeanValueAttrName() + "', composite key '" + compositeKey + "'. Exception is " + e.getMessage());
                    }
                    break block7;
                }
            }
            value = obj;
        }
        return value;
    }

    private void getInteractiveActivities(GetInteractiveActivities request, MBeanServer server, IContext context) throws BaseFaultType {
        String contentLocale = (String)context.getProperty("CONTENT_LOCALE");
        String[] signature = new String[]{"[Ljava.lang.String;", "[Ljava.lang.String;", "java.lang.String", "int", "int", "java.lang.String"};
        for (int i = 0; i < this.m_propertyList.size(); ++i) {
            MBeanType mtype = (MBeanType)this.m_propertyList.get(i);
            if (!mtype.getID().equals("InteractiveActivities")) continue;
            String mbeanObjName = this.getMBeanObjectName(mtype);
            String mbeanAttrName = (String)mtype.getMBeanValueAttrName();
            try {
                ObjectName objectName = ObjectName.getInstance(mbeanObjName);
                Object attribute = server.getAttribute(objectName, mbeanAttrName);
                if (attribute != null && CompositeData[].class.isAssignableFrom(attribute.getClass())) {
                    CompositeData[] activityList = (CompositeData[])attribute;
                    if (CogAdminLogger.getInstance().isDebugEnabled()) {
                        CogAdminLogger.getInstance().debug("Get value on mbean '" + mbeanObjName + "', attribute '" + mbeanAttrName + "': ");
                        StringBuffer tempStr = new StringBuffer();
                        for (int j = 0; j < activityList.length; ++j) {
                            CompositeData data = activityList[j];
                            tempStr.append(data.toString());
                        }
                        CogAdminLogger.getInstance().debug(tempStr.toString());
                    }
                    Object[] resultArray = this.preprocessInteractiveActivities(activityList, request, context);
                    CompositeData[] resultActivityList = (CompositeData[])resultArray[1];
                    Object[] pageInfoArray = (Object[])resultArray[0];
                    if (resultActivityList == null || resultActivityList.length == 0) {
                        resultArray[0] = this.genResultPageInfo(Integer.parseInt(pageInfoArray[0].toString()), Integer.parseInt(pageInfoArray[1].toString()), Long.parseLong(pageInfoArray[2].toString()));
                        mtype.setValue(resultArray);
                        return;
                    }
                    String[] reportIdList = new String[resultActivityList.length];
                    String[] dispatcherList = new String[resultActivityList.length];
                    for (int j = 0; j < resultActivityList.length; ++j) {
                        CompositeData data = resultActivityList[j];
                        reportIdList[j] = (String)data.get("RequestID");
                        dispatcherList[j] = (String)data.get("DispatcherName");
                    }
                    if (reportIdList != null && reportIdList.length > 0 && dispatcherList != null && dispatcherList.length > 0) {
                        Object[] params = new Object[]{reportIdList, dispatcherList, contentLocale, pageInfoArray[0], pageInfoArray[1], (String)context.getProperty("PASSPORT")};
                        try {
                            CompositeData[] repDetails = (CompositeData[])server.invoke(objectName, "getDetails", params, signature);
                            if (CogAdminLogger.getInstance().isDebugEnabled()) {
                                CogAdminLogger.getInstance().debug("Invoke getDetails on mbean '" + mbeanObjName + "', with param '" + params.toString() + ", result:");
                                StringBuffer tempStr = new StringBuffer();
                                for (int j = 0; j < repDetails.length; ++j) {
                                    CompositeData data = repDetails[j];
                                    tempStr.append(data.toString());
                                }
                                CogAdminLogger.getInstance().debug(tempStr.toString());
                            }
                            this.postprocessInteractiveActivities(resultArray, repDetails);
                            mtype.setValue(resultArray);
                        }
                        catch (Exception e) {
                            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                                CogAdminLogger.getInstance().error("failed to invoke method 'getDetails' on mbean '" + mbeanObjName + "'", e);
                            }
                            throw new BaseFaultType("error.interactiveactivities.general", e);
                        }
                    }
                    return;
                }
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("The value on mbean '" + mbeanObjName + "', attribute '" + mbeanAttrName + "' is NULL or in invalid format.");
                }
                throw new BaseFaultType("error.interactiveactivities.general");
            }
            catch (Exception e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("Could not get value on mbean '" + mbeanObjName + "', attribute '" + mbeanAttrName + "'", e);
                }
                throw new BaseFaultType("error.interactiveactivities.general", e);
            }
        }
        if (CogAdminLogger.getInstance().isErrorEnabled()) {
            CogAdminLogger.getInstance().error("The mbean property 'InteractiveActivities' is not specified for 'system' resource in metadata file.");
        }
        throw new BaseFaultType("error.interactiveactivities.general");
    }

    private CompositeData[] applyFiltersOnInteractiveActivities(CompositeData[] activityList, FilterType[] filterArray, ArrayList leftFilters, boolean excludeStatusFilter) {
        ArrayList<CompositeData> resultList = new ArrayList<CompositeData>(filterArray.length * activityList.length);
        for (int f = 0; f < filterArray.length; ++f) {
            FilterType ft = filterArray[f];
            String filterName = ft.getName();
            String filterValue = ft.getContent();
            if (filterName == null || filterName.length() <= 0 || filterValue == null) continue;
            if (excludeStatusFilter && filterName.equals("Status")) {
                leftFilters.add(ft);
                continue;
            }
            if (filterValue.equalsIgnoreCase("any")) continue;
            boolean filterIsApplied = false;
            for (int j = 0; j < activityList.length; ++j) {
                CompositeData data = activityList[j];
                try {
                    String propValue;
                    Object itemValue = data.get(filterName);
                    String string = propValue = itemValue != null ? itemValue.toString() : null;
                    if (propValue != null && propValue.equalsIgnoreCase(filterValue)) {
                        resultList.add(data);
                    }
                    filterIsApplied = true;
                    continue;
                }
                catch (InvalidKeyException e) {
                    filterIsApplied = false;
                    break;
                }
            }
            if (filterIsApplied) {
                if (resultList.size() == 0) {
                    return null;
                }
                activityList = new CompositeData[resultList.size()];
                resultList.toArray(activityList);
            }
            resultList.clear();
        }
        return activityList;
    }

    private void applySortingOnInteractiveActivities(CompositeData[] activityList, GetInteractiveActivities request, IContext context) {
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("CONTENT_LOCALE"));
        SortType sort = request.getSort();
        String sortProp = sort.getContent();
        String sortOrder = sort.getOrder();
        if (sortProp != null && sortProp.length() > 0) {
            boolean isSorted = false;
            Collator collator = Collator.getInstance(tLocale);
            TreeMap<CollationKey, CompositeData> sortedMap = new TreeMap<CollationKey, CompositeData>();
            for (int i = 0; i < activityList.length; ++i) {
                CompositeData data = activityList[i];
                try {
                    Object item = data.get(sortProp);
                    String sortedName = item.toString();
                    CollationKey key = collator.getCollationKey(sortedName);
                    sortedMap.put(key, data);
                    isSorted = true;
                    continue;
                }
                catch (InvalidKeyException e) {
                    isSorted = false;
                    break;
                }
            }
            if (isSorted) {
                int idx;
                Iterator it = sortedMap.values().iterator();
                boolean isAscending = sortOrder == null || !sortOrder.equalsIgnoreCase("descending");
                int n = idx = isAscending ? 0 : activityList.length - 1;
                while (it.hasNext()) {
                    CompositeData sortedData;
                    activityList[idx] = sortedData = (CompositeData)it.next();
                    if (isAscending) {
                        ++idx;
                        continue;
                    }
                    --idx;
                }
            }
        }
    }

    private Object[] preprocessInteractiveActivities(CompositeData[] activityList, GetInteractiveActivities request, IContext context) {
        FilterType[] filterArray;
        FiltersType filters;
        HashMap<String, String> statusSummaryMap;
        Object[] pageInfoArray;
        Object[] resultArray = new Object[3];
        resultArray[0] = pageInfoArray = new Object[3];
        resultArray[2] = statusSummaryMap = new HashMap<String, String>();
        ArrayList leftFilters = new ArrayList();
        if (activityList != null && activityList.length > 0 && (filters = request.getFilters()) != null && (filterArray = filters.getFilter()) != null) {
            int lenBeforeStatusFilter;
            int n = lenBeforeStatusFilter = (activityList = this.applyFiltersOnInteractiveActivities(activityList, filterArray, leftFilters, true)) != null ? activityList.length : 0;
            if (lenBeforeStatusFilter > 0) {
                this.calculateStatusSummary(activityList, statusSummaryMap);
                if (leftFilters != null && leftFilters.size() > 0) {
                    FilterType[] statusFilterArray = new FilterType[leftFilters.size()];
                    leftFilters.toArray(statusFilterArray);
                    activityList = this.applyFiltersOnInteractiveActivities(activityList, statusFilterArray, new ArrayList(), false);
                    if (activityList != null && activityList.length > 0 && activityList.length < lenBeforeStatusFilter) {
                        statusSummaryMap.put("filterOn", statusFilterArray[0].getContent());
                    }
                }
            }
        }
        if (activityList == null || activityList.length == 0) {
            pageInfoArray[0] = new Integer(0);
            pageInfoArray[1] = new Integer(0);
            pageInfoArray[2] = new Long(0L);
            resultArray[1] = null;
            return resultArray;
        }
        this.applySortingOnInteractiveActivities(activityList, request, context);
        int maxObjects = activityList.length;
        int skipObjects = 0;
        PageType pinfo = request.getPageInfo();
        PropertyType[] pageProps = pinfo.getPageProperty();
        for (int pi = 0; pi < pageProps.length; ++pi) {
            PropertyType pageProp = pageProps[pi];
            String propName = pageProp.getName();
            String propValue = pageProp.getContent();
            if (propName != null && propName.equalsIgnoreCase("maxObjects")) {
                try {
                    maxObjects = Integer.parseInt(propValue);
                    if (maxObjects >= 0) continue;
                    maxObjects = activityList.length;
                }
                catch (NumberFormatException e) {
                    maxObjects = activityList.length;
                }
                continue;
            }
            if (propName == null || !propName.equalsIgnoreCase("skipObjects")) continue;
            try {
                skipObjects = Integer.parseInt(propValue);
                if (skipObjects >= 0 || (skipObjects = activityList.length + skipObjects) >= 0) continue;
                skipObjects = 0;
                continue;
            }
            catch (NumberFormatException e) {
                skipObjects = 0;
            }
        }
        pageInfoArray[0] = new Integer(skipObjects);
        pageInfoArray[1] = new Integer(maxObjects);
        pageInfoArray[2] = new Long(activityList.length);
        resultArray[1] = skipObjects >= activityList.length ? null : activityList;
        return resultArray;
    }

    private PageType genResultPageInfo(int skipObjects, int maxObjects, long totalItems) {
        PageType resultPageInfo = new PageType();
        if (totalItems <= 0L) {
            this.addPageProperty(resultPageInfo, "start", "0");
            this.addPageProperty(resultPageInfo, "end", "0");
            this.addPageProperty(resultPageInfo, "maxObjects", "0");
            this.addPageProperty(resultPageInfo, "more", "false");
        } else {
            this.addPageProperty(resultPageInfo, "start", Integer.toString(skipObjects + 1));
            if ((long)skipObjects >= totalItems) {
                this.addPageProperty(resultPageInfo, "end", Integer.toString(skipObjects + maxObjects));
                this.addPageProperty(resultPageInfo, "maxObjects", "0");
                this.addPageProperty(resultPageInfo, "more", "false");
            } else if (skipObjects == 0 && (long)maxObjects >= totalItems) {
                this.addPageProperty(resultPageInfo, "end", Long.toString(totalItems));
                this.addPageProperty(resultPageInfo, "maxObjects", Long.toString(totalItems));
                this.addPageProperty(resultPageInfo, "more", "false");
            } else {
                this.addPageProperty(resultPageInfo, "end", Integer.toString(skipObjects + maxObjects));
                this.addPageProperty(resultPageInfo, "maxObjects", Integer.toString(maxObjects));
                this.addPageProperty(resultPageInfo, "more", (long)(skipObjects + maxObjects) < totalItems ? "true" : "false");
            }
        }
        return resultPageInfo;
    }

    private void calculateStatusSummary(CompositeData[] activityList, HashMap statusSummaryMap) {
        if (activityList == null) {
            return;
        }
        for (int j = 0; j < activityList.length; ++j) {
            CompositeData data = activityList[j];
            String statusValue = null;
            try {
                statusValue = (String)data.get("Status");
                if (statusValue == null || statusValue.length() == 0) {
                    statusValue = "unknown";
                }
            }
            catch (InvalidKeyException e) {
                statusValue = "unknown";
            }
            long[] count = (long[])statusSummaryMap.get(statusValue);
            if (count != null) {
                count[0] = count[0] + 1L;
                continue;
            }
            count = new long[]{1L};
            statusSummaryMap.put(statusValue, count);
        }
        long[] total = new long[]{activityList.length};
        statusSummaryMap.put("total", total);
    }

    private CompositeData[] filterInteractiveActivities(CompositeData[] activityDetails) {
        boolean isFilteringEnabled;
        try {
            String isEnabledStr = CCLConfigurationFactory.getInstance().getValue("COGADMIN.filterInteractiveActivitiesOfUnknownUsers", true);
            isFilteringEnabled = isEnabledStr == null || "".equals(isEnabledStr) ? false : Boolean.parseBoolean(isEnabledStr);
        }
        catch (CCLConfigurationException e) {
            CogAdminLogger.getInstance().error("Unable to read the advanced property 'COGADMIN.filterInteractiveActivitiesOfUnknownUsers' from the configuration.", e);
            return activityDetails;
        }
        if (!isFilteringEnabled || activityDetails == null || activityDetails.length == 0) {
            return activityDetails;
        }
        ArrayList<CompositeData> filteredActivities = new ArrayList<CompositeData>();
        CompositeData summary = activityDetails[0];
        filteredActivities.add(summary);
        for (int i = 1; i < activityDetails.length; ++i) {
            CompositeData activityDetail = activityDetails[i];
            if ("".equals(activityDetail.get("UserName"))) continue;
            filteredActivities.add(activityDetail);
        }
        return filteredActivities.toArray(new CompositeData[filteredActivities.size()]);
    }

    private void postprocessInteractiveActivities(Object[] resultArray, CompositeData[] activityDetails) {
        activityDetails = this.filterInteractiveActivities(activityDetails);
        HashMap firstStatusSummaryMap = (HashMap)resultArray[2];
        CompositeData secondStatusSummaryMap = null;
        if (activityDetails == null || activityDetails.length == 0) {
            resultArray[1] = null;
        } else {
            secondStatusSummaryMap = activityDetails[0];
            activityDetails[0] = null;
            resultArray[1] = activityDetails;
        }
        if (firstStatusSummaryMap != null && firstStatusSummaryMap.get("filterOn") != null) {
            long diff;
            String filterStatus = (String)firstStatusSummaryMap.get("filterOn");
            long[] statusSum1 = (long[])firstStatusSummaryMap.get(filterStatus);
            long statusSum2 = 0L;
            if (secondStatusSummaryMap != null && secondStatusSummaryMap.get(filterStatus) != null) {
                Long fValue = (Long)secondStatusSummaryMap.get(filterStatus);
                statusSum2 = fValue.intValue();
            }
            if ((diff = statusSum1[0] - statusSum2) > 0L) {
                statusSum1[0] = statusSum2;
                long[] totalNum = (long[])firstStatusSummaryMap.get("total");
                totalNum[0] = totalNum[0] - diff;
            }
            firstStatusSummaryMap.remove("filterOn");
            resultArray[2] = firstStatusSummaryMap;
        } else {
            resultArray[2] = secondStatusSummaryMap;
        }
        Object[] pageInfoArray = (Object[])resultArray[0];
        long finalTotalItems = 0L;
        if (secondStatusSummaryMap != null && secondStatusSummaryMap.get("total") != null) {
            finalTotalItems = (Long)secondStatusSummaryMap.get("total");
        }
        int finalCurPageLen = activityDetails != null && activityDetails.length > 1 ? activityDetails.length - 1 : 0;
        PageType resultPageInfo = this.genResultPageInfo((Integer)pageInfoArray[0], finalCurPageLen, finalTotalItems);
        resultArray[0] = resultPageInfo;
    }

    private void addPageProperty(PageType pageInfo, String propName, String propValue) {
        PropertyType resultPageProperty = new PropertyType();
        resultPageProperty.setName(propName);
        resultPageProperty.setContent(propValue);
        pageInfo.addPageProperty(resultPageProperty);
    }

    private void cancelInteractiveActivities(CancelInteractiveActivities request, MBeanServer server, IContext context) throws BaseFaultType {
        ActivityType[] activities = request.getActivity();
        ArrayList<String> dispatcherList = new ArrayList<String>(activities.length);
        ArrayList<String> reportIdList = new ArrayList<String>(activities.length);
        if (activities != null && activities.length > 0) {
            for (int a = 0; a < activities.length; ++a) {
                PropertyType[] properties;
                ActivityType act = activities[a];
                if (act == null || (properties = act.getProperty()) == null || properties.length < 2) continue;
                String reportId = null;
                String dispPath = null;
                for (int p = 0; p < properties.length; ++p) {
                    PropertyType prop = properties[p];
                    String name = prop.getName();
                    String value = prop.getContent();
                    if (name == null || name.length() <= 0) continue;
                    if (name.equalsIgnoreCase("RequestID")) {
                        reportId = value;
                        continue;
                    }
                    if (!name.equalsIgnoreCase("DispatcherName")) continue;
                    dispPath = value;
                }
                if (reportId == null || dispPath == null) continue;
                reportIdList.add(reportId);
                dispatcherList.add(dispPath);
            }
        }
        if (reportIdList.size() > 0 && dispatcherList.size() > 0) {
            String[] reportIds = new String[reportIdList.size()];
            reportIdList.toArray(reportIds);
            String[] dispatchers = new String[dispatcherList.size()];
            dispatcherList.toArray(dispatchers);
            String contentLocale = (String)context.getProperty("CONTENT_LOCALE");
            String[] signature = new String[]{"[Ljava.lang.String;", "[Ljava.lang.String;", "java.lang.String", "java.lang.String"};
            for (int i = 0; i < this.m_propertyList.size(); ++i) {
                MBeanType mtype = (MBeanType)this.m_propertyList.get(i);
                if (!mtype.getID().equals("InteractiveActivities")) continue;
                String mbeanObjName = this.getMBeanObjectName(mtype);
                try {
                    ObjectName objectName = ObjectName.getInstance(mbeanObjName);
                    Object[] params = new Object[4];
                    params[0] = reportIds;
                    params[1] = dispatchers;
                    Cookie[] cookies = (Cookie[])context.getProperty("COOKIES");
                    String userCapabilitiesValue = "";
                    for (int j = 0; j < cookies.length; ++j) {
                        Cookie cookie = cookies[j];
                        if (!cookie.getName().equals("userCapabilities")) continue;
                        userCapabilitiesValue = cookie.getContent();
                        break;
                    }
                    params[2] = (String)context.getProperty("PASSPORT") + "#" + userCapabilitiesValue;
                    params[3] = contentLocale;
                    String[] results = (String[])server.invoke(objectName, "cancelReports", params, signature);
                    Object[] responses = new Object[]{reportIds, dispatchers, results};
                    mtype.setValue(responses);
                    return;
                }
                catch (Exception e) {
                    if (CogAdminLogger.getInstance().isErrorEnabled()) {
                        CogAdminLogger.getInstance().error("failed to invoke method 'cancelReports' on mbean '" + mbeanObjName + "'", e);
                    }
                    throw new BaseFaultType("error.interactiveactivities.cancel.general", e);
                }
            }
        }
        if (CogAdminLogger.getInstance().isErrorEnabled()) {
            CogAdminLogger.getInstance().error("No valid interactive activities are specified in the request, or no interactiveActivities property is found for system");
        }
        throw new BaseFaultType("error.interactiveactivities.cancel.general");
    }

    protected String getMBeanValueAttrName(MBeanType mtype) {
        return (String)mtype.getMBeanValueAttrName();
    }

    protected String getMBeanValueCompositeKey(MBeanType mtype) {
        return null;
    }

    protected String getMBeanValueCompositeKey2(MBeanType mtype) {
        return null;
    }

    protected String getMBeanValueTabularKey(IContext context, MBeanType mtype) {
        return null;
    }

    protected String resolveMBeanObjectName(IContext context, MBeanType mtype) {
        String sObjName = this.getMBeanObjectName(mtype);
        String mbeanNamePattern = (String)context.getProperty("resourceMbeanPattern");
        return sObjName.replaceAll("#MBeanNamePattern#", COGAdminUtils.RegexEncode(mbeanNamePattern));
    }

    protected String resolveHealthMBeanObjectName(IContext context, MBeanType mtype) {
        String mbeanName = this.resolveMBeanObjectName(context, mtype);
        return mbeanName.replaceAll(REGEX_TYPEMETRICS, TYPE_METRICHEALTH);
    }

    protected String getMBeanObjectName(MBeanType mtype) {
        return mtype.getMBeanObjectName();
    }

    private void getMetricsValue(HashMap mbeanMap, MBeanServer server) {
        for (Map.Entry entry : mbeanMap.entrySet()) {
            String key = (String)entry.getKey();
            ArrayList mbeanAttrList = (ArrayList)entry.getValue();
            if (mbeanAttrList != null && mbeanAttrList.size() > 0) {
                AttributeList metricValues = MBeanPropertiesHandler.queryMBean(server, key, mbeanAttrList);
                mbeanMap.put(key, metricValues);
                continue;
            }
            mbeanMap.put(key, null);
        }
    }

    private void doThresholdActions(MBeanServer server, IContext context, String sThresholdsCmd) throws BaseFaultType {
        block15: {
            try {
                ThresholdManagerMBean thMgr = this.getThresholdManager(server);
                if (thMgr != null) {
                    for (int m = 0; m < this.m_propertyList.size(); ++m) {
                        MBeanType mtype = (MBeanType)this.m_propertyList.get(m);
                        String mbeanName = this.resolveMBeanObjectName(context, mtype);
                        String sAttrName = this.getMBeanValueAttrName(mtype);
                        if (mbeanName != null && mbeanName.length() > 0 && sAttrName != null && sAttrName.length() > 0) {
                            if (sThresholdsCmd.equals("write")) {
                                ThresholdBoundaryType upper_poor = (ThresholdBoundaryType)context.getProperty("thresholdUpperPoor");
                                ThresholdBoundaryType upper_avr = (ThresholdBoundaryType)context.getProperty("thresholdUpperAverage");
                                ThresholdBoundaryType lower_poor = (ThresholdBoundaryType)context.getProperty("thresholdLowerPoor");
                                ThresholdBoundaryType lower_avr = (ThresholdBoundaryType)context.getProperty("thresholdLowerAverage");
                                if (upper_poor == null || upper_avr == null || lower_poor == null || lower_avr == null) {
                                    if (CogAdminLogger.getInstance().isErrorEnabled()) {
                                        CogAdminLogger.getInstance().error("The thresholds passed in from writeThreshold request are not valid, either null or empty value.");
                                    }
                                    throw new BaseFaultType("error.threshold.write.invalidrequest");
                                }
                                if (CogAdminLogger.getInstance().isDebugEnabled()) {
                                    CogAdminLogger.getInstance().debug("Calling com.cognos.pogo.monitoring.jmx.threshold.ThresholdManagerMBean::writeThreshold(" + mbeanName + ", " + sAttrName + ", " + upper_poor.getContent() + ", " + upper_poor.getExclusive() + ", " + upper_avr.getContent() + ", " + upper_avr.getExclusive() + ", " + lower_avr.getContent() + ", " + lower_avr.getExclusive() + ", " + lower_poor.getContent() + ", " + lower_poor.getExclusive() + ")");
                                }
                                thMgr.writeThreshold(mbeanName, sAttrName, upper_poor.getContent(), upper_poor.getExclusive(), upper_avr.getContent(), upper_avr.getExclusive(), lower_avr.getContent(), lower_avr.getExclusive(), lower_poor.getContent(), lower_poor.getExclusive());
                                continue;
                            }
                            if (sThresholdsCmd.equals("read")) {
                                if (CogAdminLogger.getInstance().isDebugEnabled()) {
                                    CogAdminLogger.getInstance().debug("Calling com.cognos.pogo.monitoring.jmx.threshold.ThresholdManagerMBean::readThreshold(" + mbeanName + ", " + sAttrName + ")");
                                }
                                CompositeData thresholds = thMgr.readThreshold(mbeanName, sAttrName);
                                if (CogAdminLogger.getInstance().isDebugEnabled()) {
                                    CogAdminLogger.getInstance().debug("Return value is: " + (thresholds == null ? "null" : thresholds.toString()));
                                }
                                mtype.setValue(thresholds);
                                continue;
                            }
                            if (!sThresholdsCmd.equals("clear")) continue;
                            if (CogAdminLogger.getInstance().isDebugEnabled()) {
                                CogAdminLogger.getInstance().debug("Calling com.cognos.pogo.monitoring.jmx.threshold.ThresholdManagerMBean::clearThreshold(" + mbeanName + ", " + sAttrName + ")");
                            }
                            thMgr.clearThreshold(mbeanName, sAttrName);
                            continue;
                        }
                        if (CogAdminLogger.getInstance().isErrorEnabled()) {
                            CogAdminLogger.getInstance().error("Invalid mbean name or attribute name. Either null or empty value.");
                        }
                        throw new BaseFaultType("error.threshold." + sThresholdsCmd + ".general");
                    }
                    break block15;
                }
                throw new BaseFaultType("error.threshold." + sThresholdsCmd + ".general");
            }
            catch (Exception e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("Error performing threshold command: " + sThresholdsCmd + ". e is " + e.getMessage());
                }
                throw new BaseFaultType("error.threshold." + sThresholdsCmd + ".general", e);
            }
        }
    }

    private void queryConsolidatedMBean(MBeanServer server, IContext context) {
        String mbeanNamePattern = COGAdminUtils.RegexEncode((String)context.getProperty("resourceMbeanPattern"));
        String healthMBeanName = "";
        String statusMBeanName = "";
        String resourceType = (String)context.getProperty("cmResourceType");
        if (resourceType != null && resourceType.equals("dispatcher")) {
            healthMBeanName = "com.cognos:type=ServiceHealth,#MBeanNamePattern#".replaceAll("#MBeanNamePattern#", mbeanNamePattern);
            statusMBeanName = "com.cognos:type=ServiceOperationalStatus,#MBeanNamePattern#".replaceAll("#MBeanNamePattern#", mbeanNamePattern);
        } else {
            healthMBeanName = "com.cognos:type=ConsolidatedServerHealth,#MBeanNamePattern#".replaceAll("#MBeanNamePattern#", mbeanNamePattern);
            statusMBeanName = "com.cognos:type=ConsolidatedOperationalStatus,#MBeanNamePattern#".replaceAll("#MBeanNamePattern#", mbeanNamePattern);
        }
        ArrayList<String> mbeanAttrList = new ArrayList<String>();
        mbeanAttrList.add("*");
        for (int i = 0; i < this.m_propertyList.size(); ++i) {
            AttributeList metricValues;
            MBeanType mtype = (MBeanType)this.m_propertyList.get(i);
            String mbeanValueAttrName = this.getMBeanValueAttrName(mtype);
            if (mbeanValueAttrName.equals("Health")) {
                metricValues = MBeanPropertiesHandler.queryMBean(server, healthMBeanName, mbeanAttrList);
                mtype.setValue(metricValues);
                continue;
            }
            if (!mbeanValueAttrName.equals("OperationalStatus")) continue;
            metricValues = MBeanPropertiesHandler.queryMBean(server, statusMBeanName, mbeanAttrList);
            mtype.setValue(metricValues);
        }
    }

    public static AttributeList queryMBean(MBeanServer server, String mbeanName, ArrayList mbeanAttrList) {
        if (CogAdminLogger.getInstance().isDebugEnabled()) {
            CogAdminLogger.getInstance().debug("Entered method queryMBean(server = '" + server + "', mbeanName = '" + mbeanName + "', mbeanAttrList = '" + mbeanAttrList + "')");
        }
        if (server == null || mbeanName == null || mbeanName.length() == 0 || mbeanAttrList == null || mbeanAttrList.size() == 0) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("queryMBean() - invalid input argument(s), returning now.");
            }
            return null;
        }
        AttributeList values = null;
        Set<ObjectName> names = null;
        ObjectName objectName = null;
        String[] mbeanAttrs = new String[mbeanAttrList.size()];
        mbeanAttrList.toArray(mbeanAttrs);
        try {
            ObjectName scope = new ObjectName(mbeanName);
            names = server.queryNames(scope, null);
        }
        catch (MalformedObjectNameException e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("Could not find mbean '" + mbeanName + "'", e);
            }
            return null;
        }
        catch (Exception e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("Could not find mbean '" + mbeanName + "'", e);
            }
            return null;
        }
        if (names != null && names.size() > 0) {
            objectName = names.iterator().next();
            try {
                values = server.getAttributes(objectName, mbeanAttrs);
            }
            catch (InstanceNotFoundException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("server.getAttributes(objectName = '" + objectName + "' , mbeanAttrs = '" + mbeanAttrList + "') threw an exception.", e);
                }
                return null;
            }
            catch (ReflectionException e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("server.getAttributes(objectName = '" + objectName + "' , mbeanAttrs = '" + mbeanAttrList + "') threw an exception.", e);
                }
                return null;
            }
            catch (Exception e) {
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("server.getAttributes(objectName = '" + objectName + "' , mbeanAttrs = '" + mbeanAttrList + "') threw an exception.", e);
                }
                return null;
            }
        }
        if (values == null && CogAdminLogger.getInstance().isWarnEnabled()) {
            if (names.size() == 0) {
                CogAdminLogger.getInstance().warn("server.queryNames(mbeanName = '" + mbeanName + "') returned an empty set, i.e. server was unable to locate the mbean.");
            } else {
                CogAdminLogger.getInstance().warn("server.getAttributes(objectName = '" + objectName + "' , mbeanAttrList = '" + mbeanAttrList + "') returned null, i.e. the attributes could not be found for this mbean.");
            }
        }
        return values;
    }
}

