/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.MBeanPropertiesHandler;
import com.cognos.admin.resource.v1_0.MBeanType;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;

public class MBeanTabularByRefPropertiesHandler
extends MBeanPropertiesHandler {
    @Override
    protected String resolveMBeanObjectName(IContext context, MBeanType mtype) {
        String sObjName = this.getMBeanObjectName(mtype);
        IResourceID resourceID = (IResourceID)context.getProperty("resourceID");
        IResource resourceObj = null;
        try {
            IResourceID refResourceID = resourceID.getReferringResourceID();
            resourceObj = ResourceLookupManager.getInstance().find(refResourceID);
            if (Resource.class.isAssignableFrom(resourceObj.getClass())) {
                Resource resource = (Resource)resourceObj;
                String mbeanNamePattern = resource.getMBeanNamePattern(context);
                return sObjName.replaceAll("#MBeanNamePattern#", mbeanNamePattern);
            }
        }
        catch (BaseFaultType e) {
            CogAdminLogger.getInstance().error("Looking up referring resource failed, letting it fall through, e is " + e.getMessage());
        }
        return null;
    }

    @Override
    protected String getMBeanValueAttrName(MBeanType mtype) {
        String mbeanValueAttrName = (String)mtype.getMBeanValueAttrName();
        String[] parts = mbeanValueAttrName.split("::", 4);
        return parts[0];
    }

    @Override
    protected String getMBeanValueCompositeKey(MBeanType mtype) {
        String mbeanValueAttrName = (String)mtype.getMBeanValueAttrName();
        String[] parts = mbeanValueAttrName.split("::", 4);
        return parts[1];
    }

    @Override
    protected String getMBeanValueTabularKey(IContext context, MBeanType mtype) {
        String mbeanValueAttrName = (String)mtype.getMBeanValueAttrName();
        String[] parts = mbeanValueAttrName.split("::", 4);
        return (String)context.getProperty(parts[2]);
    }

    @Override
    protected String getMBeanValueCompositeKey2(MBeanType mtype) {
        String mbeanValueAttrName = (String)mtype.getMBeanValueAttrName();
        String[] parts = mbeanValueAttrName.split("::", 4);
        return parts[3];
    }
}

