/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.dom4j.Element;

public class MBeanType
extends Constants
implements Serializable,
IResourceProperty {
    private static final long serialVersionUID = 1L;
    private static SimpleDateFormat m_formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected String m_sName;
    private String m_sHandlerName;
    private String m_sMBeanObjectName;
    private String m_sMBeanValueAttrName;
    private HashMap m_lAttributeMap = new HashMap();
    private HashMap m_lAttributeValueMap = new HashMap();
    private boolean m_bIsComplexValue = false;
    private Object m_value = null;

    public MBeanType() {
        this(null);
    }

    public MBeanType(String name) {
        this.initialize();
        m_formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.m_sName = name;
    }

    @Override
    public void initialize() {
    }

    @Override
    public Object getID() {
        return this.m_sName;
    }

    @Override
    public void setID(Object id) {
        this.m_sName = id instanceof Element ? ResourcePropertiesRetriever.getName((Element)id) : (String)id;
    }

    public String getMBeanObjectName() {
        return this.m_sMBeanObjectName;
    }

    public void setMBeanObjectName(String objName) {
        this.m_sMBeanObjectName = objName;
    }

    public Object getMBeanValueAttrName() {
        return this.m_sMBeanValueAttrName;
    }

    public void setMBeanValueAttrName(String objName) {
        this.m_sMBeanValueAttrName = objName;
    }

    public HashMap getAttributeMap() {
        return this.m_lAttributeMap;
    }

    @Override
    public HashMap getAttributes() {
        return this.m_lAttributeValueMap;
    }

    public void setAttributeMap(String dispName, String jmxName) {
        if (dispName != null && jmxName != null && dispName.length() > 0 && jmxName.length() > 0) {
            this.m_lAttributeMap.put(jmxName, dispName);
        }
    }

    public void setAttributeValueMap(String name, Object value) {
        if (name != null && name.length() > 0) {
            if (Date.class == value.getClass()) {
                String sDate = this.formatDateTime((Date)value);
                this.m_lAttributeValueMap.put(name, sDate);
            } else {
                this.m_lAttributeValueMap.put(name, value);
            }
        }
    }

    public void clearAttributeValueMap() {
        this.m_lAttributeValueMap.clear();
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(Object value) {
        this.m_value = value;
    }

    @Override
    public String getHandlerName() {
        return this.m_sHandlerName;
    }

    @Override
    public void setHandlerName(String handlerName) {
        this.m_sHandlerName = handlerName;
    }

    @Override
    public boolean isComplexValue() {
        return this.m_bIsComplexValue;
    }

    @Override
    public void setComplexValue(boolean b) {
        this.m_bIsComplexValue = b;
    }

    protected String formatDateTime(Date value) {
        try {
            return m_formatter.format(value);
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("MBeanType::formatDateTime - name: " + this.getID(), e);
            return "";
        }
    }

    public void setUnits(String units) {
    }

    @Override
    public Object clone() {
        MBeanType resObj = new MBeanType(this.m_sName);
        this.copy(resObj);
        return resObj;
    }

    protected Object copy(Object aObj) {
        if (aObj instanceof MBeanType) {
            MBeanType mBeanType = (MBeanType)aObj;
            mBeanType.setID(this.m_sName);
            mBeanType.setMBeanObjectName(this.m_sMBeanObjectName);
            mBeanType.setComplexValue(this.m_bIsComplexValue);
            mBeanType.setHandlerName(this.m_sHandlerName);
            Set entrySet = this.m_lAttributeMap.entrySet();
            for (Map.Entry entry : entrySet) {
                mBeanType.setAttributeMap(entry.getKey().toString(), entry.getValue().toString());
            }
            mBeanType.setMBeanValueAttrName(this.m_sMBeanValueAttrName);
        }
        return aObj;
    }
}

