/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.AdminConfigProperties;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.datastores.actions.ContextCache;
import com.cognos.admin.resource.v1_0.PropertiesHandler;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularData;
import org.dom4j.Element;

public class PPSChildrenStoreIDsHandler
extends PropertiesHandler {
    public List getChildren(IContext context, Element element, int max) {
        ArrayList<String> childrenIDs = null;
        try {
            Element handlerElem;
            if (element != null && (handlerElem = element.element(AdminConfigProperties.COG_PROPERTY_HANDLER.getLocalPart())) != null) {
                Element objectNameElem = handlerElem.element(AdminConfigProperties.COG_PROPERTY_HANDLER_OBJ_NAME.getLocalPart());
                Element valueElem = handlerElem.element(AdminConfigProperties.COG_VALUE.getLocalPart());
                if (objectNameElem != null && valueElem != null) {
                    String mbeanNamePattern;
                    String sObjectName = objectNameElem.getText();
                    String sMbeanName = sObjectName.replaceAll("#MBeanNamePattern#", mbeanNamePattern = (String)context.getProperty("resourceMbeanPattern"));
                    childrenIDs = (ArrayList<String>)ContextCache.getProperty(context, sMbeanName);
                    if (childrenIDs != null) {
                        return childrenIDs;
                    }
                    childrenIDs = new ArrayList<String>();
                    ContextCache.setProperty(context, sMbeanName, childrenIDs);
                    MBeanServer server = PogoMBeanServer.getInstance().getProxyMBeanServer();
                    Set<ObjectName> mBeanNames = server.queryNames(new ObjectName(sMbeanName), null);
                    if (mBeanNames.size() > 0) {
                        CompositeDataSupport wrapper;
                        Object results;
                        ObjectName obj = mBeanNames.iterator().next();
                        String sValue = valueElem.getText();
                        String[] parts = sValue.split("::", 3);
                        String sCompositeAttribute = parts[0];
                        String sWrapperCompositeKey = parts[1];
                        String sTabularKey = parts[2];
                        Object sStats = server.getAttribute(obj, sCompositeAttribute);
                        if (CompositeDataSupport.class.isAssignableFrom(sStats.getClass()) && TabularData.class.isAssignableFrom((results = (wrapper = (CompositeDataSupport)sStats).get(sWrapperCompositeKey)).getClass())) {
                            TabularData activePackages = (TabularData)results;
                            Iterator<?> iter = activePackages.values().iterator();
                            while (iter.hasNext() && max > 0) {
                                CompositeData activePackage;
                                String childStoreID;
                                Object nextObj = iter.next();
                                if (!CompositeData.class.isAssignableFrom(nextObj.getClass()) || (childStoreID = (String)(activePackage = (CompositeData)nextObj).get(sTabularKey)).indexOf(":") != -1) continue;
                                childrenIDs.add(childStoreID);
                                --max;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("Looking up referring resource failed, letting it fall through, e is " + e.getMessage());
        }
        return childrenIDs;
    }

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        if (this.m_propertyList == null || this.m_propertyList.size() < 1) {
            CogAdminLogger.getInstance().error("No mbean properties are defined.");
            return;
        }
        PropertyType property = (PropertyType)this.m_propertyList.get(0);
        property.setValue(this.getChildren(context, property.element, Integer.MAX_VALUE));
    }
}

