/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.CMResourceID;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipParticipantType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class PPSResource
extends CMResource {
    private static String PROPERTY_CHILDREN = "ChildIDs";

    @Override
    protected String buildRelationshipRequest(String requestedType, IContext context) throws BaseFaultType {
        if (!requestedType.equalsIgnoreCase("containedBy")) {
            throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
        }
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        StringBuffer request = CMRequestHelper.startCMQueryRequest();
        ArrayList currentProps = ResourcePropertiesRetriever.getInstance(context).getiResourceCMProperties(this.getResourceType(), Constants.QRBT_RESPONSE_PROP_LIST, tLocale);
        CMRequestHelper.appendQueryRequest(request, new StringBuffer("storeID(\"").append(this.getStoreID()).append("\")").toString(), currentProps);
        ArrayList childProps = this.getServiceProperties(context, Constants.QRBT_RESPONSE_PROP_LIST, "dispatcher", tLocale);
        List children = this.getChildren(context);
        for (String storeID : children) {
            CMRequestHelper.appendQueryRequest(request, new StringBuffer("storeID").append("(\"").append(storeID).append("\")").toString(), childProps);
        }
        CMRequestHelper.endCMQueryRequest(request);
        return request.toString();
    }

    private List getChildren(IContext context) throws CacheException, BaseFaultType {
        this.setContext(context);
        IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getSinglePropertyHandler(context, this.getResourceType(), PROPERTY_CHILDREN);
        handler.doIt(context);
        Iterator iter = handler.iterator();
        while (iter.hasNext()) {
            IResourceProperty prop;
            Object value;
            Object element = iter.next();
            if (!IResourceProperty.class.isAssignableFrom(element.getClass()) || !List.class.isAssignableFrom((value = (prop = (IResourceProperty)element).getValue()).getClass())) continue;
            return (List)value;
        }
        return new ArrayList();
    }

    @Override
    protected void addQRBTParticipant(RelationshipType relationship, String sType, List<GenericCMObject> cmObjects, ArrayList<String> listOfProperties, IContext context) throws BaseFaultType {
        listOfProperties.addAll(Constants.QRBT_RESPONSE_PROP_WITHOUT_HEALTH_LIST);
        for (int i = 0; i < cmObjects.size(); ++i) {
            IPropertiesHandler handler;
            CMResource cmRes;
            GenericCMObject cmObj = cmObjects.get(i);
            String storeID = cmObj.getParameter("storeID", "");
            if (storeID == null || storeID.length() == 0) continue;
            String type = cmObj.getType();
            int idx = type.indexOf(":");
            if (idx != -1) {
                type = type.substring(idx + 1);
            }
            RelationshipParticipantType p = null;
            if (storeID.equals(this.getStoreID())) {
                context.setProperty("resourceMbeanType", (Object)"consolidated");
                context.setProperty("resourceMbeanPattern", (Object)this.getConsolidatedMBeanNamePattern(context));
                context.setProperty("cmResourceType", (Object)"dispatcher");
                IPropertiesHandler healthHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, "dispatcher", Constants.QRBT_RESPONSE_PROP_HEALTH_LIST);
                healthHandler.doIt(context);
                this.resetContext(context);
                cmRes = this;
                context.setProperty("cmObject", (Object)cmObj);
                context.setProperty("resourceMbeanPattern", (Object)cmRes.getMBeanNamePattern(context));
                handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, cmRes.getResourceType(), listOfProperties);
                handler.doIt(context);
                p = cmRes.generateQRBTPaticipant(handler, healthHandler, context, type.equals("dispatcher"));
            } else {
                CMResourceID resId = new CMResourceID(type, storeID);
                resId.setReferringResourceID(new CMResourceID(this.getResourceType(), this.getStoreID()));
                cmRes = (CMResource)ResourceLookupManager.getInstance().find(resId);
                this.setContext(context, cmRes);
                context.setProperty("cmObject", (Object)cmObj);
                handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, cmRes.getResourceType(), listOfProperties);
                handler.doIt(context);
                IPropertiesHandler healthHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, cmRes.getResourceType(), Constants.QRBT_RESPONSE_PROP_HEALTH_LIST);
                healthHandler.doIt(context);
                this.resetContext(context);
                p = cmRes.generateQRBTPaticipant(handler, healthHandler, context, type.equals("dispatcher"));
            }
            relationship.addParticipant(p);
        }
    }
}

