/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.CMResourceID;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.RolapCubeResource;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipParticipantType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.services.IContext;
import com.cognos.xts.ext.XTSExt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class QSResource
extends CMResource {
    public static String PROPERTY_CHILDREN = "ChildIDs";
    private List<String> xqeCubeNames = null;

    @Override
    protected String buildRelationshipRequest(String requestedType, IContext context) throws BaseFaultType {
        if (!requestedType.equalsIgnoreCase("containedBy")) {
            throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
        }
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        ArrayList childProps = this.getServiceProperties(context, Constants.QRBT_RESPONSE_PROP_LIST, "dispatcher", tLocale);
        ArrayList<String> sSearchPaths = new ArrayList<String>();
        this.xqeCubeNames = this.getChildren(context);
        sSearchPaths.add(new StringBuffer("storeID(\"").append(this.getStoreID()).append("\")").toString());
        for (String childDefaultName : this.xqeCubeNames) {
            String sSearchPath = RolapCubeResource.getSearchPath(XTSExt.xmlencode((String)childDefaultName));
            sSearchPaths.add(sSearchPath);
        }
        return CMRequestHelper.buildCMQueryRequest(sSearchPaths, (List)childProps);
    }

    protected List<String> getChildren(IContext context) throws CacheException, BaseFaultType {
        this.setContext(context);
        IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getSinglePropertyHandler(context, this.getResourceType(), PROPERTY_CHILDREN);
        handler.doIt(context);
        Iterator iter = handler.iterator();
        while (iter.hasNext()) {
            IResourceProperty prop;
            Object value;
            Object element = iter.next();
            if (!IResourceProperty.class.isAssignableFrom(element.getClass()) || !List.class.isAssignableFrom((value = (prop = (IResourceProperty)element).getValue()).getClass())) continue;
            return (List)value;
        }
        return new ArrayList<String>();
    }

    @Override
    protected void addQRBTParticipant(RelationshipType relationship, String sType, List<GenericCMObject> cmObjects, ArrayList<String> listOfProperties, IContext context) throws BaseFaultType {
        listOfProperties.addAll(Constants.QRBT_RESPONSE_PROP_WITHOUT_HEALTH_LIST);
        int cmCubeCount = cmObjects.size() - 1;
        boolean localizeDataSourceNames = this.xqeCubeNames != null && this.cmHasSameNumberOfCubesAsXQE(cmCubeCount, this.xqeCubeNames.size());
        for (int i = 0; i < cmObjects.size(); ++i) {
            GenericCMObject cmObj = cmObjects.get(i);
            String storeID = cmObj.getParameter("storeID", "");
            if (storeID == null || storeID.length() == 0) continue;
            String type = cmObj.getType();
            int idx = type.indexOf(":");
            if (idx != -1) {
                type = type.substring(idx + 1);
            }
            RelationshipParticipantType p = null;
            if (storeID.equals(this.getStoreID())) {
                context.setProperty("resourceMbeanType", (Object)"consolidated");
                context.setProperty("resourceMbeanPattern", (Object)this.getConsolidatedMBeanNamePattern(context));
                context.setProperty("cmResourceType", (Object)"dispatcher");
                IPropertiesHandler healthHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, "dispatcher", Constants.QRBT_RESPONSE_PROP_HEALTH_LIST);
                healthHandler.doIt(context);
                this.resetContext(context);
                QSResource cmRes = this;
                context.setProperty("cmObject", (Object)cmObj);
                context.setProperty("resourceMbeanPattern", (Object)cmRes.getMBeanNamePattern(context));
                IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, cmRes.getResourceType(), listOfProperties);
                handler.doIt(context);
                p = cmRes.generateQRBTPaticipant(handler, healthHandler, context, type.equals("dispatcher"));
            } else {
                String rolapDataSourceName;
                String sResourceType = RolapCubeResource.mapObjectClassToResourceType(cmObj.getParameter("objectClass", null));
                if (sResourceType == null) {
                    if (!CogAdminLogger.getInstance().isErrorEnabled()) continue;
                    CogAdminLogger.getInstance().error("QSResource::addQRBTParticipant - unexpected resource type (" + sResourceType + ") for store id " + storeID + ", treat as no-op.");
                    continue;
                }
                String string = rolapDataSourceName = localizeDataSourceNames ? this.xqeCubeNames.get(i - 1) : cmObj.getParameter("defaultName", storeID);
                if (!localizeDataSourceNames && CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("QSResource::addQRBTParticipant - Unable to localize dynamic cube data source name " + rolapDataSourceName + " due to a cube integrity issue between CM & Dynamic Query");
                }
                CMResourceID cubeResId = this.getCubeResourceId(sResourceType, rolapDataSourceName);
                Resource res = (Resource)ResourceLookupManager.getInstance().find(cubeResId);
                context.setProperty("cmObject", (Object)cmObj);
                ((RolapCubeResource)res).setContext(context);
                IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, res.getResourceType(), listOfProperties);
                handler.doIt(context);
                IPropertiesHandler healthHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, res.getResourceType(), Constants.QRBT_RESPONSE_PROP_HEALTH_LIST);
                healthHandler.doIt(context);
                this.resetContext(context);
                p = res.generateQRBTPaticipant(handler, healthHandler, context, type.equals("dispatcher"));
            }
            relationship.addParticipant(p);
        }
    }

    protected CMResourceID getCubeResourceId(String sResourceType, String datasourceName) throws BaseFaultType {
        CMResourceID cubeResId = new CMResourceID(sResourceType, datasourceName);
        cubeResId.setReferringResourceID(new CMResourceID(this.getResourceType(), this.getStoreID()));
        return cubeResId;
    }

    private boolean cmHasSameNumberOfCubesAsXQE(int numberOfCubesInCM, int numberOfCubesInXQE) {
        if (numberOfCubesInCM != numberOfCubesInXQE) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("QSResource::cmHasSameNumberOfCubesAsXQE - CM cube count is out of sync with XQE. The cubes will not be displayed. CM=" + numberOfCubesInCM + ", XQE=" + numberOfCubesInXQE);
            }
            return false;
        }
        return true;
    }
}

