/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.AdminMetadataRetriever;
import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.castor.CogadminCastorType;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.intf.IActionsHandler;
import com.cognos.admin.resource.v1_0.intf.IClearThresholds;
import com.cognos.admin.resource.v1_0.intf.ICogQueryRelationshipsByType;
import com.cognos.admin.resource.v1_0.intf.IExecuteResourceAction;
import com.cognos.admin.resource.v1_0.intf.IGetMultipleResourceProperties;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IQueryRelationshipsByType;
import com.cognos.admin.resource.v1_0.intf.IReadThresholds;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceAction;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.resource.v1_0.intf.IResourceLookup;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.resource.v1_0.intf.IWriteThresholds;
import com.cognos.admin.ws.cogadmin.v1_0.ArgumentType;
import com.cognos.admin.ws.cogadmin.v1_0.ClearThresholds;
import com.cognos.admin.ws.cogadmin.v1_0.ClearThresholdsResponse;
import com.cognos.admin.ws.cogadmin.v1_0.CogQueryRelationshipsByType;
import com.cognos.admin.ws.cogadmin.v1_0.CogQueryRelationshipsByTypeResponse;
import com.cognos.admin.ws.cogadmin.v1_0.Details;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceAction;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceActionResponse;
import com.cognos.admin.ws.cogadmin.v1_0.ReadThresholds;
import com.cognos.admin.ws.cogadmin.v1_0.ReadThresholdsResponse;
import com.cognos.admin.ws.cogadmin.v1_0.ThresholdBoundaryType;
import com.cognos.admin.ws.cogadmin.v1_0.WriteThresholds;
import com.cognos.admin.ws.cogadmin.v1_0.WriteThresholdsResponse;
import com.cognos.admin.ws.wsdm.muws2.v1_1.QueryRelationshipsByType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.QueryRelationshipsByTypeResponse;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipParticipantType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipTypeType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.admin.ws.wsrf.wsrf_rp.v1_2.GetMultipleResourceProperties;
import com.cognos.admin.ws.wsrf.wsrf_rp.v1_2.GetMultipleResourcePropertiesResponse;
import com.cognos.admin.ws.wsrf.wsrf_rp.v1_2.GetResourceProperty;
import com.cognos.admin.ws.wsrf.wsrf_rp.v1_2.GetResourcePropertyResponse;
import com.cognos.admin.ws.wsrf.wsrf_rp.v1_2.InvalidResourcePropertyQNameFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.xml.namespace.QName;

public abstract class Resource
implements IResource,
IGetMultipleResourceProperties,
IQueryRelationshipsByType,
IExecuteResourceAction,
IWriteThresholds,
IReadThresholds,
IClearThresholds,
ICogQueryRelationshipsByType,
Serializable {
    protected IResourceID m_id;
    protected IResourceLookup m_resourceLookup;

    @Override
    public void initialize() {
    }

    @Override
    public IResourceID getResourceID() {
        return this.m_id;
    }

    public String getResourceType() {
        return this.m_id.getType();
    }

    @Override
    public void setResourceID(IResourceID id) throws BaseFaultType {
        if (this.m_id != null) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("setID(" + id + "). id Already set");
            }
            throw new BaseFaultType("error.resourcelookup.idalreadybeenset", new String[]{"" + this.m_id}, null);
        }
        this.m_id = id;
    }

    @Override
    public QueryRelationshipsByTypeResponse queryRelationshipsByType(QueryRelationshipsByType sRelationshipType, IContext context) throws BaseFaultType {
        try {
            String requestedType = sRelationshipType.getRequestedType();
            List<GenericCMObject> participants = this.makeRelationshipRequest(context, this.buildRelationshipRequest(requestedType, context));
            QueryRelationshipsByTypeResponse result = this.getQueryRelationshipsByTypeResponse(requestedType, participants, context);
            if (result.getRelationshipCount() > 0) {
                return result;
            }
            if (CogAdminLogger.getInstance().isWarnEnabled()) {
                CogAdminLogger.getInstance().warn("QRBT(resource := '" + this.m_id + "', relationship type := '" + requestedType + "') returned no results.");
            }
            throw new BaseFaultType("error.qrbt.notfound", new String[]{sRelationshipType.getRequestedType()}, null);
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("QueryRelationshipsByTypeResponse", e);
            throw new BaseFaultType("error.exception", new String[]{sRelationshipType.getRequestedType()}, e);
        }
    }

    @Override
    public CogQueryRelationshipsByTypeResponse cogQueryRelationshipsByType(CogQueryRelationshipsByType sRelationshipType, IContext context) throws BaseFaultType {
        try {
            String requestedType = sRelationshipType.getRequestedType();
            String[] arrayOfProperties = sRelationshipType.getResourceProperty();
            ArrayList<String> listOfProperties = new ArrayList<String>(arrayOfProperties.length);
            for (int i = 0; i < arrayOfProperties.length; ++i) {
                QName prop = QName.valueOf(arrayOfProperties[i]);
                listOfProperties.add(prop.getLocalPart());
            }
            List<GenericCMObject> participants = this.makeRelationshipRequest(context, this.buildRelationshipRequest(requestedType, context));
            CogQueryRelationshipsByTypeResponse result = new CogQueryRelationshipsByTypeResponse();
            RelationshipType relationship = new RelationshipType();
            result.addRelationship(relationship);
            relationship.setName("To be decided");
            RelationshipTypeType rtype = new RelationshipTypeType();
            CogadminCastorType ctype = new CogadminCastorType(requestedType);
            rtype.setAnyObject(ctype);
            relationship.setType(rtype);
            this.addQRBTParticipant(relationship, requestedType, participants, listOfProperties, context);
            if (result.getRelationshipCount() > 0) {
                return result;
            }
            if (CogAdminLogger.getInstance().isWarnEnabled()) {
                CogAdminLogger.getInstance().warn("CogQRBT(resource := '" + this.m_id + "', relationship type := '" + requestedType + "', properties := '" + listOfProperties.toString() + ") returned no results.");
            }
            throw new BaseFaultType("error.qrbt.notfound", new String[]{sRelationshipType.getRequestedType()}, null);
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("CogQueryRelationshipsByTypeResponse", e);
            throw new BaseFaultType("error.exception", new String[]{sRelationshipType.getRequestedType()}, e);
        }
    }

    @Override
    public ExecuteResourceActionResponse executeResourceAction(ExecuteResourceAction sAction, IContext context) throws BaseFaultType {
        Object obj;
        String sName = sAction.getName().trim();
        ArrayList<String> al = new ArrayList<String>(1);
        al.add(sName);
        Enumeration e = sAction.enumerateArgument();
        while (e.hasMoreElements()) {
            ArgumentType arg = (ArgumentType)e.nextElement();
            context.setProperty(arg.getName(), (Object)arg.getContent());
        }
        this.setContext(context);
        IActionsHandler handler = this.getResourcePropertiesRetriever(context).getActionsHandler(context, this.getResourceType(), al, sAction.getCapability());
        handler.doIt(context);
        Iterator it = handler.iterator();
        if (it.hasNext() && (obj = it.next()) != null && IResourceAction.class.isAssignableFrom(obj.getClass())) {
            IResourceAction action = (IResourceAction)obj;
            ExecuteResourceActionResponse response = new ExecuteResourceActionResponse();
            response.setName(sName);
            response.setDetails((Details)action.getValue());
            return response;
        }
        throw new BaseFaultType("error.action.notfound", new String[]{"" + this.m_id}, null);
    }

    @Override
    public GetResourcePropertyResponse getResourceProperty(GetResourceProperty grp, IContext context) throws BaseFaultType, InvalidResourcePropertyQNameFaultType {
        String sPropertyName = grp.getQName().trim();
        this.setContext(context);
        IPropertiesHandler handler = this.getResourcePropertiesRetriever(context).getSinglePropertyHandler(context, this.getResourceType(), sPropertyName);
        handler.doIt(context);
        Object[] listOfResults = new Object[handler.size()];
        int idx = 0;
        Iterator iter = handler.iterator();
        while (iter.hasNext()) {
            IResourceProperty prop;
            Object propObj = iter.next();
            if (!IResourceProperty.class.isAssignableFrom(propObj.getClass()) || (prop = (IResourceProperty)propObj).getValue() == null) continue;
            if (prop.isComplexValue()) {
                listOfResults[idx] = prop.getValue();
            } else {
                CogadminCastorType cct = new CogadminCastorType((String)prop.getID());
                cct.setValue(prop);
                listOfResults[idx] = cct;
            }
            ++idx;
        }
        if (listOfResults.length == 0 && CogAdminLogger.getInstance().isWarnEnabled()) {
            CogAdminLogger.getInstance().warn("GRP(resource := '" + this.m_id + "', property := '" + sPropertyName + "' returned an empty result set.");
        }
        GetResourcePropertyResponse grpr = new GetResourcePropertyResponse();
        grpr.setAnyObject(listOfResults);
        return grpr;
    }

    @Override
    public GetMultipleResourcePropertiesResponse getMultipleResourceProperties(GetMultipleResourceProperties grrp, IContext context) throws BaseFaultType {
        String[] arrayOfProperties = grrp.getResourceProperty();
        ArrayList<String> listOfProperties = new ArrayList<String>(arrayOfProperties.length);
        for (int i = 0; i < arrayOfProperties.length; ++i) {
            QName prop = QName.valueOf(arrayOfProperties[i]);
            listOfProperties.add(prop.getLocalPart());
        }
        this.setContext(context);
        IPropertiesHandler handler = this.getResourcePropertiesRetriever(context).getPropertiesHandler(context, this.getResourceType(), listOfProperties);
        handler.doIt(context);
        ArrayList<Object> arrayOfResults = new ArrayList<Object>(handler.size());
        Iterator iter = handler.iterator();
        while (iter.hasNext()) {
            IResourceProperty prop;
            Object propObj = iter.next();
            if (!IResourceProperty.class.isAssignableFrom(propObj.getClass()) || (prop = (IResourceProperty)propObj).getValue() == null) continue;
            if (prop.isComplexValue()) {
                arrayOfResults.add(prop.getValue());
                continue;
            }
            CogadminCastorType cct = new CogadminCastorType((String)prop.getID());
            cct.setValue(prop);
            arrayOfResults.add(cct);
        }
        if (arrayOfResults.size() == 0 && CogAdminLogger.getInstance().isWarnEnabled()) {
            CogAdminLogger.getInstance().warn("GMRP(resource := '" + this.m_id + "', properties := '" + listOfProperties + "' returned an empty result set.");
        }
        Object[] listOfResults = new Object[arrayOfResults.size()];
        arrayOfResults.toArray(listOfResults);
        GetMultipleResourcePropertiesResponse gmrpr = new GetMultipleResourcePropertiesResponse();
        gmrpr.setAnyObject(listOfResults);
        return gmrpr;
    }

    public QueryRelationshipsByTypeResponse getQueryRelationshipsByTypeResponse(String sType, List<GenericCMObject> participants, IContext context) throws BaseFaultType {
        QueryRelationshipsByTypeResponse response = new QueryRelationshipsByTypeResponse();
        RelationshipType relationship = new RelationshipType();
        response.addRelationship(relationship);
        relationship.setName("To be decided");
        RelationshipTypeType rtype = new RelationshipTypeType();
        CogadminCastorType ctype = new CogadminCastorType(sType);
        rtype.setAnyObject(ctype);
        relationship.setType(rtype);
        this.addQRBTParticipant(relationship, sType, participants, new ArrayList<String>(0), context);
        return response;
    }

    public RelationshipParticipantType generateQRBTPaticipant(IPropertiesHandler handler, IPropertiesHandler healthHandler, IContext context) throws BaseFaultType {
        return this.generateQRBTPaticipant(handler, healthHandler, context, false);
    }

    protected RelationshipParticipantType generateQRBTPaticipant(IPropertiesHandler handler, IPropertiesHandler healthHandler, IContext context, boolean isGroupRoot) throws BaseFaultType {
        CogadminCastorType cct;
        IResourceProperty prop;
        RelationshipParticipantType participant = new RelationshipParticipantType();
        participant.setResourceId(this.getResourceID().toString());
        participant.setRole(new StringBuffer("cogadmin:role:").append(this.getResourceType()).toString());
        if (!(handler != null && handler.size() != 0 || healthHandler != null && healthHandler.size() != 0)) {
            return participant;
        }
        String locale = (String)context.getProperty("PRODUCT_LOCALE");
        Object[] listOfResults = new CogadminCastorType[(handler != null ? handler.size() : 0) + (healthHandler != null ? healthHandler.size() : 0)];
        int idx = 0;
        if (handler != null) {
            Iterator iter = handler.iterator();
            while (iter.hasNext()) {
                Object propObj = iter.next();
                if (!IResourceProperty.class.isAssignableFrom(propObj.getClass())) continue;
                prop = (IResourceProperty)propObj;
                cct = new CogadminCastorType((String)prop.getID());
                cct.setValue(prop);
                if (((String)prop.getID()).equals("Caption")) {
                    cct.setNSURI("http://docs.oasis-open.org/wsdm/muws2-2.xsd");
                    cct.setNSPrefix("muws2");
                    CogadminCastorType langAttr = new CogadminCastorType("lang");
                    langAttr.setNSPrefix("xml");
                    langAttr.setNSURI("http://www.w3.org/XML/1998/namespace");
                    langAttr.setValue(locale == null || locale.length() == 0 ? "en" : locale);
                    cct.addAttribute(langAttr);
                } else if (prop.getID().equals("OperationalStatus")) {
                    cct.setNSURI("http://docs.oasis-open.org/wsdm/muws2-2.xsd");
                    cct.setNSPrefix("muws2");
                }
                listOfResults[idx] = cct;
                ++idx;
            }
        }
        if (healthHandler != null) {
            Iterator hiter = healthHandler.iterator();
            while (hiter.hasNext()) {
                Object healthPropObj = hiter.next();
                if (!IResourceProperty.class.isAssignableFrom(healthPropObj.getClass())) continue;
                prop = (IResourceProperty)healthPropObj;
                cct = new CogadminCastorType((String)prop.getID());
                Object value = prop.getValue();
                if (value != null) {
                    if (AttributeList.class == value.getClass()) {
                        AttributeList valueList = (AttributeList)value;
                        for (int ii = 0; ii < valueList.size(); ++ii) {
                            Attribute attr = (Attribute)valueList.get(ii);
                            String name = attr.getName();
                            if (isGroupRoot) {
                                if (!name.equals(prop.getID())) continue;
                                cct.setValue(attr.getValue());
                            } else if (name.indexOf(",") == -1) {
                                if (!name.equals(this.getResourceType())) continue;
                                cct.setValue(attr.getValue());
                            } else {
                                String attrLastName;
                                String dispPath = "";
                                if (CMResource.class.isAssignableFrom(this.getClass())) {
                                    dispPath = ((CMResource)this).getDispatcherPath(context);
                                }
                                String string = attrLastName = this.getResourceType().equals("dispatcher") ? (String)prop.getID() : this.getResourceType();
                                if (!name.equals(new StringBuffer(dispPath).append(',').append(attrLastName).toString())) continue;
                                cct.setValue(attr.getValue());
                            }
                            break;
                        }
                    } else {
                        cct.setValue(value);
                    }
                }
                if (((String)prop.getID()).equals("OperationalStatus")) {
                    cct.setNSURI("http://docs.oasis-open.org/wsdm/muws2-2.xsd");
                    cct.setNSPrefix("muws2");
                }
                listOfResults[idx] = cct;
                ++idx;
            }
        }
        participant.setAnyObject(listOfResults);
        return participant;
    }

    public static String genSearchPathServiceFilter(IContext context) {
        ArrayList services = AdminMetadataRetriever.getInstance(context).getServiceTypeIds();
        if (services == null || services.size() == 0) {
            return "";
        }
        StringBuffer filter = new StringBuffer("[@shown='true' and (");
        for (int i = 0; i < services.size(); ++i) {
            Object name = services.get(i);
            if (name == null || name.toString().length() <= 0) continue;
            if (i > 0) {
                filter.append(" or ");
            }
            filter.append("@objectClass='").append(name).append("'");
        }
        filter.append(")]");
        return filter.toString();
    }

    protected ArrayList getServiceProperties(IContext context, ArrayList inputPropList, String defaultToResource, Locale tLocale) {
        ArrayList services = this.getServices(context);
        if (services != null && services.size() > 0) {
            String sname = services.get(0).toString();
            if (sname != null && sname.length() > 0) {
                return this.getResourcePropertiesRetriever(context).getiResourceCMProperties(sname, inputPropList, tLocale);
            }
            if (defaultToResource != null && defaultToResource.length() > 0) {
                return this.getResourcePropertiesRetriever(context).getiResourceCMProperties(defaultToResource, inputPropList, tLocale);
            }
        }
        return new ArrayList(0);
    }

    protected ArrayList getServices(IContext context) {
        return AdminMetadataRetriever.getInstance(context).getServiceTypeIds();
    }

    protected void resetContext(IContext context) {
        for (int i = 0; i < Constants.CONTEXT_PROP_LIST.size(); ++i) {
            String prop = Constants.CONTEXT_PROP_LIST.get(i).toString();
            context.setProperty(prop, null);
        }
    }

    @Override
    public WriteThresholdsResponse writeThresholds(WriteThresholds sAction, IContext context) throws BaseFaultType {
        IPropertiesHandler pHandler;
        ThresholdBoundaryType upper_poor = sAction.getUpperSidePoor();
        ThresholdBoundaryType upper_avr = sAction.getUpperSideAverage();
        ThresholdBoundaryType lower_poor = sAction.getLowerSidePoor();
        ThresholdBoundaryType lower_avr = sAction.getLowerSideAverage();
        String propName = sAction.getResourceProperty();
        if (upper_poor != null && upper_avr != null && lower_poor != null && lower_avr != null && propName != null && propName.length() > 0 && (pHandler = this.getResourcePropertiesRetriever(context).getSinglePropertyHandler(context, this.getResourceType(), propName)) != null) {
            context.setProperty("thresholdUpperPoor", (Object)upper_poor);
            context.setProperty("thresholdUpperAverage", (Object)upper_avr);
            context.setProperty("thresholdLowerPoor", (Object)lower_poor);
            context.setProperty("thresholdLowerAverage", (Object)lower_avr);
            context.setProperty("thresholdAction", (Object)"write");
            this.setContext(context);
            pHandler.doIt(context);
            WriteThresholdsResponse wtr = new WriteThresholdsResponse();
            return wtr;
        }
        CogAdminLogger.getInstance().error("The thresholds passed in from writeThreshold request are not valid, either null or empty value.");
        throw new BaseFaultType("error.threshold.write.invalidrequest");
    }

    @Override
    public ReadThresholdsResponse readThresholds(ReadThresholds sAction, IContext context) throws BaseFaultType {
        IPropertiesHandler pHandler;
        String propName = sAction.getResourceProperty();
        if (propName != null && propName.length() > 0 && (pHandler = this.getResourcePropertiesRetriever(context).getSinglePropertyHandler(context, this.getResourceType(), propName)) != null) {
            context.setProperty("thresholdAction", (Object)"read");
            this.setContext(context);
            pHandler.doIt(context);
            ArrayList propList = pHandler.getPropertyList();
            if (propList != null && propList.size() > 0) {
                IResourceProperty prop = (IResourceProperty)propList.get(0);
                Object value = prop.getValue();
                ReadThresholdsResponse rtr = this.genReadThresholdsResponse(value);
                return rtr;
            }
        }
        CogAdminLogger.getInstance().error("The property name passed in from readThreshold request is not valid, either null or empty value.");
        throw new BaseFaultType("error.threshold.read.invalidrequest");
    }

    private ReadThresholdsResponse genReadThresholdsResponse(Object value) throws BaseFaultType {
        if (value == null || value != null && CompositeData.class.isAssignableFrom(value.getClass())) {
            try {
                ReadThresholdsResponse rtr = new ReadThresholdsResponse();
                ThresholdBoundaryType upper_poor = new ThresholdBoundaryType();
                ThresholdBoundaryType upper_avr = new ThresholdBoundaryType();
                ThresholdBoundaryType lower_poor = new ThresholdBoundaryType();
                ThresholdBoundaryType lower_avr = new ThresholdBoundaryType();
                boolean isTempate = true;
                if (value != null) {
                    Boolean lowerPoorExclusiveFlag;
                    String lowerPoor;
                    Boolean lowerAvrExclusiveFlag;
                    String lowerAvr;
                    Boolean upperAvrExclusiveFlag;
                    String upperAvr;
                    Boolean upperpoorExclusiveFlag;
                    String upperpoor;
                    block8: {
                        CompositeData thresHolds = (CompositeData)value;
                        upperpoor = (String)thresHolds.get("higherSidePoor");
                        upperpoorExclusiveFlag = (Boolean)thresHolds.get("higherSidePoorExclusiveFlag");
                        upperAvr = (String)thresHolds.get("higherSideAverage");
                        upperAvrExclusiveFlag = (Boolean)thresHolds.get("higherSideAverageExclusiveFlag");
                        lowerAvr = (String)thresHolds.get("lowerSideAverage");
                        lowerAvrExclusiveFlag = (Boolean)thresHolds.get("lowerSideAverageExclusiveFlag");
                        lowerPoor = (String)thresHolds.get("lowerSidePoor");
                        lowerPoorExclusiveFlag = (Boolean)thresHolds.get("lowerSidePoorExclusiveFlag");
                        try {
                            Object bIsTempate = thresHolds.get("isTemplate");
                            isTempate = bIsTempate != null && bIsTempate instanceof Boolean ? (Boolean)bIsTempate : true;
                        }
                        catch (InvalidKeyException e) {
                            if (!CogAdminLogger.getInstance().isDebugEnabled()) break block8;
                            CogAdminLogger.getInstance().debug("Exception occured: " + e.getMessage() + ". Defaulting to " + String.valueOf(isTempate));
                        }
                    }
                    upper_poor.setContent(upperpoor != null ? upperpoor : "");
                    upper_poor.setExclusive(upperpoorExclusiveFlag != null ? upperpoorExclusiveFlag : true);
                    upper_avr.setContent(upperAvr != null ? upperAvr : "");
                    upper_avr.setExclusive(upperAvrExclusiveFlag != null ? upperAvrExclusiveFlag : true);
                    lower_poor.setContent(lowerPoor != null ? lowerPoor : "");
                    lower_poor.setExclusive(lowerPoorExclusiveFlag != null ? lowerPoorExclusiveFlag : true);
                    lower_avr.setContent(lowerAvr != null ? lowerAvr : "");
                    lower_avr.setExclusive(lowerAvrExclusiveFlag != null ? lowerAvrExclusiveFlag : true);
                } else {
                    if (CogAdminLogger.getInstance().isDebugEnabled()) {
                        CogAdminLogger.getInstance().debug("value is null, i.e. no threshold is set yet, return empty values");
                    }
                    upper_poor.deleteExclusive();
                    upper_avr.deleteExclusive();
                    lower_poor.deleteExclusive();
                    lower_avr.deleteExclusive();
                }
                rtr.setUpperSidePoor(upper_poor);
                rtr.setUpperSideAverage(upper_avr);
                rtr.setLowerSidePoor(lower_poor);
                rtr.setLowerSideAverage(lower_avr);
                rtr.setIsTemplate(isTempate);
                return rtr;
            }
            catch (Exception e) {
                CogAdminLogger.getInstance().error("Exception happened while processing the threshold values for resource " + this.getResourceID().toString(), e);
                throw new BaseFaultType("error.threshold.read.general", e);
            }
        }
        CogAdminLogger.getInstance().error("The value returned from mbean server readThreshold API is not a type of CompositeData.");
        throw new BaseFaultType("error.threshold.read.general");
    }

    @Override
    public ClearThresholdsResponse clearThresholds(ClearThresholds sAction, IContext context) throws BaseFaultType {
        IPropertiesHandler pHandler;
        String propName = sAction.getResourceProperty();
        if (propName != null && propName.length() > 0 && (pHandler = this.getResourcePropertiesRetriever(context).getSinglePropertyHandler(context, this.getResourceType(), propName)) != null) {
            context.setProperty("thresholdAction", (Object)"clear");
            this.setContext(context);
            pHandler.doIt(context);
            ClearThresholdsResponse ctr = new ClearThresholdsResponse();
            return ctr;
        }
        CogAdminLogger.getInstance().error("The property name passed in from clearThreshold request is not valid, either null or empty value.");
        throw new BaseFaultType("error.threshold.clear.invalidrequest");
    }

    protected String getMBeanNameWithServiceTypePattern(IContext context, String pattern) {
        String metricGroup = (String)context.getProperty("metricGroup");
        if (metricGroup != null) {
            try {
                String serviceType = metricGroup.substring(metricGroup.lastIndexOf("/") + 1);
                if (AdminMetadataRetriever.getInstance(context).getServiceTypeIds().contains(serviceType)) {
                    pattern = new StringBuffer(pattern).append(",service=").append(serviceType).toString();
                }
            }
            catch (IndexOutOfBoundsException e) {
                CogAdminLogger.getInstance().error("getMBeanNamePattern", e);
            }
        }
        return pattern;
    }

    protected abstract void setContext(IContext var1);

    protected abstract String buildRelationshipRequest(String var1, IContext var2) throws BaseFaultType;

    protected List<GenericCMObject> makeRelationshipRequest(IContext context, String queryRequest) throws BaseFaultType {
        return CMRequestHelper.makeCMRequest(context, queryRequest);
    }

    protected abstract void addQRBTParticipant(RelationshipType var1, String var2, List<GenericCMObject> var3, ArrayList<String> var4, IContext var5) throws BaseFaultType;

    public abstract String getMBeanNamePattern(IContext var1);

    protected boolean isTemplate() {
        return this.getResourceID() != null && this.getResourceID().getId() == null;
    }

    public ResourcePropertiesRetriever getResourcePropertiesRetriever(IContext context) {
        return ResourcePropertiesRetriever.getInstance(context);
    }
}

